/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.tagmanager.ContainerHolder;
import com.google.android.gms.tagmanager.DataLayer;
import com.google.android.gms.tagmanager.zzbg;
import com.google.android.gms.tagmanager.zzcb;
import com.google.android.gms.tagmanager.zzct;
import com.google.android.gms.tagmanager.zzcu;
import com.google.android.gms.tagmanager.zzd;
import com.google.android.gms.tagmanager.zzo;
import com.google.android.gms.tagmanager.zzp;
import com.google.android.gms.tagmanager.zzs;
import com.google.android.gms.tagmanager.zzw;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TagManager {
    private final zza zzaZo;
    private final Context mContext;
    private final DataLayer zzaVR;
    private final zzct zzaZp;
    private final ConcurrentMap<zzo, Boolean> zzaZq;
    private final zzs zzaYl;
    private static TagManager zzaZr;

    TagManager(Context context, zza containerHolderLoaderProvider, DataLayer dataLayer, zzct serviceManager) {
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        this.mContext = context.getApplicationContext();
        this.zzaZp = serviceManager;
        this.zzaZo = containerHolderLoaderProvider;
        this.zzaZq = new ConcurrentHashMap<zzo, Boolean>();
        this.zzaVR = dataLayer;
        this.zzaVR.zza(new DataLayer.zzb(){

            @Override
            public void zzJ(Map<String, Object> map) {
                Object object = map.get("event");
                if (object != null) {
                    TagManager.this.zzfa(object.toString());
                }
            }
        });
        this.zzaVR.zza(new zzd(this.mContext));
        this.zzaYl = new zzs();
        this.zzDL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TagManager getInstance(Context context) {
        Class<TagManager> clazz = TagManager.class;
        synchronized (TagManager.class) {
            if (zzaZr == null) {
                if (context == null) {
                    zzbg.e("TagManager.getInstance requires non-null context.");
                    throw new NullPointerException();
                }
                zza zza2 = new zza(){

                    @Override
                    public zzp zza(Context context, TagManager tagManager, Looper looper, String string2, int n, zzs zzs2) {
                        return new zzp(context, tagManager, looper, string2, n, zzs2);
                    }
                };
                zzw zzw2 = new zzw(context);
                zzaZr = new TagManager(context, zza2, new DataLayer(zzw2), zzcu.zzDG());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzaZr;
        }
    }

    public DataLayer getDataLayer() {
        return this.zzaVR;
    }

    public PendingResult<ContainerHolder> loadContainerDefaultOnly(String containerId, int defaultContainerResourceId) {
        zzp zzp2 = this.zzaZo.zza(this.mContext, this, null, containerId, defaultContainerResourceId, this.zzaYl);
        zzp2.zzCy();
        return zzp2;
    }

    public PendingResult<ContainerHolder> loadContainerDefaultOnly(String containerId, int defaultContainerResourceId, Handler handler) {
        zzp zzp2 = this.zzaZo.zza(this.mContext, this, handler.getLooper(), containerId, defaultContainerResourceId, this.zzaYl);
        zzp2.zzCy();
        return zzp2;
    }

    public PendingResult<ContainerHolder> loadContainerPreferNonDefault(String containerId, int defaultContainerResourceId) {
        zzp zzp2 = this.zzaZo.zza(this.mContext, this, null, containerId, defaultContainerResourceId, this.zzaYl);
        zzp2.zzCz();
        return zzp2;
    }

    public PendingResult<ContainerHolder> loadContainerPreferNonDefault(String containerId, int defaultContainerResourceId, Handler handler) {
        zzp zzp2 = this.zzaZo.zza(this.mContext, this, handler.getLooper(), containerId, defaultContainerResourceId, this.zzaYl);
        zzp2.zzCz();
        return zzp2;
    }

    public PendingResult<ContainerHolder> loadContainerPreferFresh(String containerId, int defaultContainerResourceId) {
        zzp zzp2 = this.zzaZo.zza(this.mContext, this, null, containerId, defaultContainerResourceId, this.zzaYl);
        zzp2.zzCA();
        return zzp2;
    }

    public PendingResult<ContainerHolder> loadContainerPreferFresh(String containerId, int defaultContainerResourceId, Handler handler) {
        zzp zzp2 = this.zzaZo.zza(this.mContext, this, handler.getLooper(), containerId, defaultContainerResourceId, this.zzaYl);
        zzp2.zzCA();
        return zzp2;
    }

    public void dispatch() {
        this.zzaZp.dispatch();
    }

    public void setVerboseLoggingEnabled(boolean enableVerboseLogging) {
        zzbg.setLogLevel(enableVerboseLogging ? 2 : 5);
    }

    synchronized boolean zzm(Uri uri) {
        zzcb zzcb2 = zzcb.zzDm();
        if (zzcb2.zzm(uri)) {
            String string2 = zzcb2.getContainerId();
            switch (zzcb2.zzDn()) {
                case zzaXY: {
                    for (zzo zzo2 : this.zzaZq.keySet()) {
                        if (!zzo2.getContainerId().equals(string2)) continue;
                        zzo2.zzeE(null);
                        zzo2.refresh();
                    }
                    break;
                }
                case zzaXZ: 
                case zzaYa: {
                    for (zzo zzo3 : this.zzaZq.keySet()) {
                        if (zzo3.getContainerId().equals(string2)) {
                            zzo3.zzeE(zzcb2.zzDo());
                            zzo3.refresh();
                            continue;
                        }
                        if (zzo3.zzCv() == null) continue;
                        zzo3.zzeE(null);
                        zzo3.refresh();
                    }
                    break;
                }
            }
            return true;
        }
        return false;
    }

    void zza(zzo zzo2) {
        this.zzaZq.put(zzo2, true);
    }

    boolean zzb(zzo zzo2) {
        return this.zzaZq.remove(zzo2) != null;
    }

    private void zzfa(String string2) {
        for (zzo zzo2 : this.zzaZq.keySet()) {
            zzo2.zzeC(string2);
        }
    }

    private void zzDL() {
        if (Build.VERSION.SDK_INT >= 14) {
            this.mContext.registerComponentCallbacks((ComponentCallbacks)new ComponentCallbacks2(){

                public void onTrimMemory(int i) {
                    if (i == 20) {
                        TagManager.this.dispatch();
                    }
                }

                public void onConfigurationChanged(Configuration configuration) {
                }

                public void onLowMemory() {
                }
            });
        }
    }

    public static interface zza {
        public zzp zza(Context var1, TagManager var2, Looper var3, String var4, int var5, zzs var6);
    }
}

