/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import android.content.res.Resources;
import com.google.android.gms.internal.zzaf;
import com.google.android.gms.internal.zzqz;
import com.google.android.gms.internal.zzrb;
import com.google.android.gms.internal.zzsd;
import com.google.android.gms.internal.zzse;
import com.google.android.gms.tagmanager.zzaz;
import com.google.android.gms.tagmanager.zzbf;
import com.google.android.gms.tagmanager.zzbg;
import com.google.android.gms.tagmanager.zzcb;
import com.google.android.gms.tagmanager.zzp;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONException;

class zzcn
implements zzp.zzf {
    private final Context mContext;
    private final String zzaVQ;
    private final ExecutorService zzaYr;
    private zzbf<zzqz.zza> zzaYk;

    zzcn(Context context, String string2) {
        this.mContext = context;
        this.zzaVQ = string2;
        this.zzaYr = Executors.newSingleThreadExecutor();
    }

    @Override
    public void zza(zzbf<zzqz.zza> zzbf2) {
        this.zzaYk = zzbf2;
    }

    @Override
    public void zzCD() {
        this.zzaYr.execute(new Runnable(){

            @Override
            public void run() {
                zzcn.this.zzDu();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzDu() {
        if (this.zzaYk == null) {
            throw new IllegalStateException("Callback must be set before execute");
        }
        this.zzaYk.zzCC();
        zzbg.v("Attempting to load resource from disk");
        if ((zzcb.zzDm().zzDn() == zzcb.zza.zzaXZ || zzcb.zzDm().zzDn() == zzcb.zza.zzaYa) && this.zzaVQ.equals(zzcb.zzDm().getContainerId())) {
            this.zzaYk.zza(zzbf.zza.zzaXy);
            return;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.zzDv());
        }
        catch (FileNotFoundException fileNotFoundException) {
            zzbg.zzaF("Failed to find the resource in the disk");
            this.zzaYk.zza(zzbf.zza.zzaXy);
            return;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            zzrb.zzb(fileInputStream, byteArrayOutputStream);
            zzqz.zza zza2 = zzqz.zza.zzw(byteArrayOutputStream.toByteArray());
            this.zzd(zza2);
            this.zzaYk.zzH(zza2);
        }
        catch (IOException iOException) {
            this.zzaYk.zza(zzbf.zza.zzaXz);
            zzbg.zzaH("Failed to read the resource from disk");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzaYk.zza(zzbf.zza.zzaXz);
            zzbg.zzaH("Failed to read the resource from disk. The resource is inconsistent");
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                zzbg.zzaH("Error closing stream for reading resource from disk");
            }
        }
        zzbg.v("The Disk resource was successfully read.");
    }

    @Override
    public void zzb(final zzqz.zza zza2) {
        this.zzaYr.execute(new Runnable(){

            @Override
            public void run() {
                zzcn.this.zzc(zza2);
            }
        });
    }

    @Override
    public zzrb.zzc zzjs(int n) {
        InputStream inputStream = null;
        try {
            inputStream = this.mContext.getResources().openRawResource(n);
        }
        catch (Resources.NotFoundException notFoundException) {
            zzbg.zzaH("Failed to load the container. No default container resource found with the resource ID " + n);
            return null;
        }
        zzbg.v("Attempting to load a container from the resource ID " + n + " (" + this.mContext.getResources().getResourceName(n) + ")");
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            zzrb.zzb(inputStream, byteArrayOutputStream);
            zzrb.zzc zzc2 = this.zza(byteArrayOutputStream);
            if (zzc2 != null) {
                zzbg.v("The container was successfully loaded from the resource (using JSON file format)");
                return zzc2;
            }
            return this.zzv(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            zzbg.zzaH("Error reading the default container with resource ID " + n + " (" + this.mContext.getResources().getResourceName(n) + ")");
            return null;
        }
    }

    private zzrb.zzc zza(ByteArrayOutputStream byteArrayOutputStream) {
        try {
            String string2 = byteArrayOutputStream.toString("UTF-8");
            return zzaz.zzeT(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            zzbg.zzaF("Failed to convert binary resource to string for JSON parsing; the file format is not UTF-8 format.");
            return null;
        }
        catch (JSONException jSONException) {
            zzbg.zzaH("Failed to extract the container from the resource file. Resource is a UTF-8 encoded string but doesn't contain a JSON container");
            return null;
        }
    }

    private zzrb.zzc zzv(byte[] byArray) {
        try {
            zzrb.zzc zzc2 = zzrb.zzb(zzaf.zzf.zzc(byArray));
            if (zzc2 != null) {
                zzbg.v("The container was successfully loaded from the resource (using binary file)");
            }
            return zzc2;
        }
        catch (zzsd zzsd2) {
            zzbg.e("The resource file is corrupted. The container cannot be extracted from the binary file");
            return null;
        }
        catch (zzrb.zzg zzg2) {
            zzbg.zzaH("The resource file is invalid. The container from the binary file is invalid");
            return null;
        }
    }

    @Override
    public synchronized void release() {
        this.zzaYr.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean zzc(zzqz.zza zza2) {
        FileOutputStream fileOutputStream = null;
        File file = this.zzDv();
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            zzbg.e("Error opening resource file for writing");
            return false;
        }
        try {
            fileOutputStream.write(zzse.zzf(zza2));
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            zzbg.zzaH("Error writing resource to disk. Removing resource from disk.");
            file.delete();
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                zzbg.zzaH("error closing stream for writing resource to disk");
            }
        }
        return false;
    }

    File zzDv() {
        String string2 = "resource_" + this.zzaVQ;
        File file = this.mContext.getDir("google_tagmanager", 0);
        return new File(file, string2);
    }

    private void zzd(zzqz.zza zza2) throws IllegalArgumentException {
        if (zza2.zziR == null && zza2.zzbaj == null) {
            throw new IllegalArgumentException("Resource and SupplementedResource are NULL.");
        }
    }
}

