/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.SparseArray;
import com.google.android.gms.vision.Frame;

public abstract class Detector<T> {
    private Object zzbbc = new Object();
    private Processor<T> zzbbd;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.zzbbc;
        synchronized (object) {
            if (this.zzbbd != null) {
                this.zzbbd.release();
                this.zzbbd = null;
            }
        }
    }

    public abstract SparseArray<T> detect(Frame var1);

    public boolean setFocus(int id2) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveFrame(Frame frame) {
        Object object = this.zzbbc;
        synchronized (object) {
            if (this.zzbbd == null) {
                throw new IllegalStateException("Detector processor must first be set with setProcessor in order to receive detection results.");
            }
            Frame.Metadata metadata = new Frame.Metadata(frame.getMetadata());
            metadata.zzEy();
            SparseArray<T> sparseArray = this.detect(frame);
            boolean bl = this.isOperational();
            Detections<T> detections = new Detections<T>(sparseArray, metadata, bl);
            this.zzbbd.receiveDetections(detections);
        }
    }

    public void setProcessor(Processor<T> processor) {
        this.zzbbd = processor;
    }

    public boolean isOperational() {
        return true;
    }

    public static interface Processor<T> {
        public void release();

        public void receiveDetections(Detections<T> var1);
    }

    public static class Detections<T> {
        private SparseArray<T> zzbbe;
        private Frame.Metadata zzbbf;
        private boolean zzbbg;

        public Detections(SparseArray<T> detectedItems, Frame.Metadata frameMetadata, boolean isOperational) {
            this.zzbbe = detectedItems;
            this.zzbbf = frameMetadata;
            this.zzbbg = isOperational;
        }

        public SparseArray<T> getDetectedItems() {
            return this.zzbbe;
        }

        public Frame.Metadata getFrameMetadata() {
            return this.zzbbf;
        }

        public boolean detectorIsOperational() {
            return this.zzbbg;
        }
    }
}

