/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.graphics.Bitmap;
import android.graphics.Color;
import java.nio.ByteBuffer;

public class Frame {
    public static final int ROTATION_0 = 0;
    public static final int ROTATION_90 = 1;
    public static final int ROTATION_180 = 2;
    public static final int ROTATION_270 = 3;
    private Metadata zzbbk = new Metadata();
    private ByteBuffer zzbbl = null;
    private Bitmap mBitmap = null;

    public Metadata getMetadata() {
        return this.zzbbk;
    }

    public ByteBuffer getGrayscaleImageData() {
        if (this.mBitmap != null) {
            return this.zzEx();
        }
        return this.zzbbl;
    }

    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    private Frame() {
    }

    private ByteBuffer zzEx() {
        int n = this.mBitmap.getWidth();
        int n2 = this.mBitmap.getHeight();
        int[] nArray = new int[n * n2];
        this.mBitmap.getPixels(nArray, 0, n, 0, 0, n, n2);
        byte[] byArray = new byte[n * n2];
        for (int i = 0; i < nArray.length; ++i) {
            byArray[i] = (byte)((float)Color.red((int)nArray[i]) * 0.299f + (float)Color.green((int)nArray[i]) * 0.587f + (float)Color.blue((int)nArray[i]) * 0.114f);
        }
        return ByteBuffer.wrap(byArray);
    }

    public static class Metadata {
        private int zznQ;
        private int zznR;
        private int mId;
        private long zzaAc;
        private int zzAF;

        public Metadata() {
        }

        public Metadata(Metadata metadata) {
            this.zznQ = metadata.getWidth();
            this.zznR = metadata.getHeight();
            this.mId = metadata.getId();
            this.zzaAc = metadata.getTimestampMillis();
            this.zzAF = metadata.getRotation();
        }

        public int getWidth() {
            return this.zznQ;
        }

        public int getHeight() {
            return this.zznR;
        }

        public int getId() {
            return this.mId;
        }

        public long getTimestampMillis() {
            return this.zzaAc;
        }

        public int getRotation() {
            return this.zzAF;
        }

        public void zzEy() {
            if (this.zzAF % 2 != 0) {
                int n = this.zznQ;
                this.zznQ = this.zznR;
                this.zznR = n;
            }
            this.zzAF = 0;
        }
    }

    public static class Builder {
        private Frame zzbbm = new Frame();

        public Builder setBitmap(Bitmap image) {
            int n = image.getWidth();
            int n2 = image.getHeight();
            this.zzbbm.mBitmap = image;
            Metadata metadata = this.zzbbm.getMetadata();
            metadata.zznQ = n;
            metadata.zznR = n2;
            return this;
        }

        public Builder setImageData(ByteBuffer data, int width, int height, int format) {
            if (data == null) {
                throw new IllegalArgumentException("Null image data supplied.");
            }
            if (data.capacity() < width * height) {
                throw new IllegalArgumentException("Invalid image data size.");
            }
            switch (format) {
                case 16: 
                case 17: 
                case 842094169: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported image format: " + format);
                }
            }
            this.zzbbm.zzbbl = data;
            Metadata metadata = this.zzbbm.getMetadata();
            metadata.zznQ = width;
            metadata.zznR = height;
            return this;
        }

        public Builder setId(int id2) {
            this.zzbbm.getMetadata().mId = id2;
            return this;
        }

        public Builder setTimestampMillis(long timestampMillis) {
            this.zzbbm.getMetadata().zzaAc = timestampMillis;
            return this;
        }

        public Builder setRotation(int rotation) {
            this.zzbbm.getMetadata().zzAF = rotation;
            return this;
        }

        public Frame build() {
            if (this.zzbbm.zzbbl == null && this.zzbbm.mBitmap == null) {
                throw new IllegalStateException("Missing image data.  Call either setBitmap or setImageData to specify the image");
            }
            return this.zzbbm;
        }
    }
}

