/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.barcode;

import android.content.Context;
import android.util.SparseArray;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.barcode.Barcode;
import com.google.android.gms.vision.barcode.internal.client.BarcodeDetectorOptions;
import com.google.android.gms.vision.barcode.internal.client.zzd;
import com.google.android.gms.vision.internal.client.FrameMetadataParcel;
import java.nio.ByteBuffer;

public final class BarcodeDetector
extends Detector<Barcode> {
    private final zzd zzbby;

    private BarcodeDetector() {
        throw new IllegalStateException("Default constructor called");
    }

    private BarcodeDetector(zzd nativeDetector) {
        this.zzbby = nativeDetector;
    }

    @Override
    public SparseArray<Barcode> detect(Frame frame) {
        ByteBuffer byteBuffer;
        Barcode[] barcodeArray;
        if (frame == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        Frame.Metadata metadata = frame.getMetadata();
        FrameMetadataParcel frameMetadataParcel = FrameMetadataParcel.zzc(frame);
        if (frame.getBitmap() != null) {
            barcodeArray = this.zzbby.zza(frame.getBitmap(), frameMetadataParcel);
        } else {
            byteBuffer = frame.getGrayscaleImageData();
            barcodeArray = this.zzbby.zza(byteBuffer, frameMetadataParcel);
        }
        byteBuffer = new SparseArray(barcodeArray.length);
        for (Barcode barcode : barcodeArray) {
            byteBuffer.append(barcode.rawValue.hashCode(), barcode);
        }
        return byteBuffer;
    }

    @Override
    public boolean isOperational() {
        return this.zzbby.isOperational();
    }

    public static class Builder {
        private Context mContext;
        private BarcodeDetectorOptions zzbbz;

        public Builder(Context context) {
            this.mContext = context;
            this.zzbbz = new BarcodeDetectorOptions();
        }

        public Builder setBarcodeFormats(int format) {
            this.zzbbz.zzbbA = format;
            return this;
        }

        public BarcodeDetector build() {
            zzd zzd2 = new zzd(this.mContext, this.zzbbz);
            return new BarcodeDetector(zzd2);
        }
    }
}

