/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.face;

import android.graphics.PointF;
import com.google.android.gms.vision.face.Landmark;
import java.util.Arrays;
import java.util.List;

public class Face {
    public static final float UNCOMPUTED_PROBABILITY = -1.0f;
    private int mId;
    private PointF zzbbD;
    private float zzaJX;
    private float zzaJY;
    private float zzbbE;
    private float zzbbF;
    private List<Landmark> zzbbG;
    private float zzbbH;
    private float zzbbI;
    private float zzbbJ;

    public PointF getPosition() {
        return new PointF(this.zzbbD.x - this.zzaJX / 2.0f, this.zzbbD.y - this.zzaJY / 2.0f);
    }

    public float getWidth() {
        return this.zzaJX;
    }

    public float getHeight() {
        return this.zzaJY;
    }

    public float getEulerY() {
        return this.zzbbE;
    }

    public float getEulerZ() {
        return this.zzbbF;
    }

    public List<Landmark> getLandmarks() {
        return this.zzbbG;
    }

    public float getIsLeftEyeOpenProbability() {
        return this.zzbbH;
    }

    public float getIsRightEyeOpenProbability() {
        return this.zzbbI;
    }

    public float getIsSmilingProbability() {
        return this.zzbbJ;
    }

    public int getId() {
        return this.mId;
    }

    public Face(int id2, PointF position, float width, float height, float yawDegrees, float rollDegrees, Landmark[] landmarks, float isLeftEyeOpenScore, float isRightEyeOpenScore, float isSmilingScore) {
        this.mId = id2;
        this.zzbbD = position;
        this.zzaJX = width;
        this.zzaJY = height;
        this.zzbbE = yawDegrees;
        this.zzbbF = rollDegrees;
        this.zzbbG = Arrays.asList(landmarks);
        this.zzbbH = isLeftEyeOpenScore >= 0.0f && isLeftEyeOpenScore <= 1.0f ? isLeftEyeOpenScore : -1.0f;
        this.zzbbI = isRightEyeOpenScore >= 0.0f && isRightEyeOpenScore <= 1.0f ? isRightEyeOpenScore : -1.0f;
        this.zzbbJ = this.zzbbJ >= 0.0f && this.zzbbJ <= 1.0f ? isSmilingScore : -1.0f;
    }
}

