/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.face;

import android.content.Context;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.face.Face;
import com.google.android.gms.vision.face.internal.client.FaceSettingsParcel;
import com.google.android.gms.vision.face.internal.client.zzg;
import com.google.android.gms.vision.internal.client.FrameMetadataParcel;
import com.google.android.gms.vision.zza;
import java.nio.ByteBuffer;
import java.util.HashSet;

public final class FaceDetector
extends Detector<Face> {
    public static final int NO_LANDMARKS = 0;
    public static final int ALL_LANDMARKS = 1;
    public static final int NO_CLASSIFICATIONS = 0;
    public static final int ALL_CLASSIFICATIONS = 1;
    public static final int FAST_MODE = 0;
    public static final int ACCURATE_MODE = 1;
    private final zza zzbbK = new zza();
    private final zzg zzbbL;
    private final Object zzpd = new Object();
    private boolean zzbbM = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Object object = this.zzpd;
        synchronized (object) {
            if (!this.zzbbM) {
                return;
            }
            this.zzbbL.zzEA();
            this.zzbbM = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            Object object = this.zzpd;
            synchronized (object) {
                if (this.zzbbM) {
                    Log.w((String)"FaceDetector", (String)"FaceDetector was not released with FaceDetector.release()");
                    this.release();
                }
            }
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SparseArray<Face> detect(Frame frame) {
        Face[] faceArray;
        if (frame == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        ByteBuffer byteBuffer = frame.getGrayscaleImageData();
        Object object = this.zzpd;
        synchronized (object) {
            if (!this.zzbbM) {
                throw new RuntimeException("Cannot use detector after release()");
            }
            faceArray = this.zzbbL.zzb(byteBuffer, FrameMetadataParcel.zzc(frame));
        }
        int n = 0;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        SparseArray sparseArray = new SparseArray(faceArray.length);
        for (Face face : faceArray) {
            int n2 = face.getId();
            n = Math.max(n, n2);
            if (hashSet.contains(n2)) {
                n2 = ++n;
            }
            hashSet.add(n2);
            int n3 = this.zzbbK.zzjE(n2);
            sparseArray.append(n3, (Object)face);
        }
        return sparseArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setFocus(int id2) {
        int n = this.zzbbK.zzjF(id2);
        Object object = this.zzpd;
        synchronized (object) {
            if (!this.zzbbM) {
                throw new RuntimeException("Cannot use detector after release()");
            }
            return this.zzbbL.zzjW(n);
        }
    }

    @Override
    public boolean isOperational() {
        return this.zzbbL.isOperational();
    }

    private FaceDetector() {
        throw new IllegalStateException("Default constructor called");
    }

    private FaceDetector(zzg handle) {
        this.zzbbL = handle;
    }

    public static class Builder {
        private final Context mContext;
        private int zzbbN = 0;
        private boolean zzbbO = false;
        private int zzbbP = 0;
        private boolean zzbbQ = true;
        private int zzaiz = 0;

        public Builder(Context context) {
            this.mContext = context;
        }

        public Builder setLandmarkType(int landmarkType) {
            if (landmarkType != 0 && landmarkType != 1) {
                throw new IllegalArgumentException("Invalid landmark type: " + landmarkType);
            }
            this.zzbbN = landmarkType;
            return this;
        }

        public Builder setProminentFaceOnly(boolean prominentFaceOnly) {
            this.zzbbO = prominentFaceOnly;
            return this;
        }

        public Builder setClassificationType(int classificationType) {
            if (classificationType != 0 && classificationType != 1) {
                throw new IllegalArgumentException("Invalid classification type: " + classificationType);
            }
            this.zzbbP = classificationType;
            return this;
        }

        public Builder setTrackingEnabled(boolean trackingEnabled) {
            this.zzbbQ = trackingEnabled;
            return this;
        }

        public Builder setMode(int mode) {
            switch (mode) {
                case 0: 
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid mode: " + mode);
                }
            }
            this.zzaiz = mode;
            return this;
        }

        public FaceDetector build() {
            FaceSettingsParcel faceSettingsParcel = new FaceSettingsParcel();
            faceSettingsParcel.mode = this.zzaiz;
            faceSettingsParcel.zzbbX = this.zzbbN;
            faceSettingsParcel.zzbbY = this.zzbbP;
            faceSettingsParcel.zzbbZ = this.zzbbO;
            faceSettingsParcel.zzbca = this.zzbbQ;
            zzg zzg2 = new zzg(this.mContext, faceSettingsParcel);
            return new FaceDetector(zzg2);
        }
    }
}

