/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamic.zzf;
import com.google.android.gms.internal.zzrh;
import com.google.android.gms.internal.zzri;
import com.google.android.gms.internal.zzrp;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;

public final class WalletFragment
extends Fragment {
    private zzb zzbeh;
    private boolean mCreated = false;
    private final com.google.android.gms.dynamic.zzb zzbei = com.google.android.gms.dynamic.zzb.zza(this);
    private final zzc zzbej = new zzc();
    private zza zzbek = new zza(this);
    private final Fragment zzapz = this;
    private WalletFragmentOptions zzbdY;
    private WalletFragmentInitParams zzbdZ;
    private MaskedWalletRequest zzbea;
    private MaskedWallet zzbeb;
    private Boolean zzbec;

    public static WalletFragment newInstance(WalletFragmentOptions options) {
        WalletFragment walletFragment = new WalletFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("extraWalletFragmentOptions", (Parcelable)options);
        walletFragment.zzapz.setArguments(bundle);
        return walletFragment;
    }

    public void initialize(WalletFragmentInitParams initParams) {
        if (this.zzbeh != null) {
            this.zzbeh.initialize(initParams);
            this.zzbdZ = null;
        } else if (this.zzbdZ == null) {
            this.zzbdZ = initParams;
            if (this.zzbea != null) {
                Log.w((String)"WalletFragment", (String)"updateMaskedWalletRequest() was called before initialize()");
            }
            if (this.zzbeb != null) {
                Log.w((String)"WalletFragment", (String)"updateMaskedWallet() was called before initialize()");
            }
        } else {
            Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once. Ignoring.");
        }
    }

    public void updateMaskedWalletRequest(MaskedWalletRequest request) {
        if (this.zzbeh != null) {
            this.zzbeh.updateMaskedWalletRequest(request);
            this.zzbea = null;
        } else {
            this.zzbea = request;
        }
    }

    public void updateMaskedWallet(MaskedWallet maskedWallet) {
        if (this.zzbeh != null) {
            this.zzbeh.updateMaskedWallet(maskedWallet);
            this.zzbeb = null;
        } else {
            this.zzbeb = maskedWallet;
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.zzbeh != null) {
            this.zzbeh.setEnabled(enabled);
            this.zzbec = null;
        } else {
            this.zzbec = enabled;
        }
    }

    public void setOnStateChangedListener(OnStateChangedListener listener) {
        this.zzbek.zza(listener);
    }

    public int getState() {
        return this.zzbeh != null ? this.zzbeh.getState() : 0;
    }

    public void onInflate(Activity activity, AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(activity, attrs, savedInstanceState);
        if (this.zzbdY == null) {
            this.zzbdY = WalletFragmentOptions.zza((Context)activity, attrs);
        }
        Bundle bundle = new Bundle();
        bundle.putParcelable("attrKeyWalletFragmentOptions", (Parcelable)this.zzbdY);
        this.zzbej.onInflate(activity, bundle, savedInstanceState);
    }

    public void onCreate(Bundle savedInstanceState) {
        WalletFragmentOptions walletFragmentOptions;
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            savedInstanceState.setClassLoader(WalletFragmentOptions.class.getClassLoader());
            WalletFragmentInitParams walletFragmentInitParams = (WalletFragmentInitParams)savedInstanceState.getParcelable("walletFragmentInitParams");
            if (walletFragmentInitParams != null) {
                if (this.zzbdZ != null) {
                    Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once.Ignoring.");
                }
                this.zzbdZ = walletFragmentInitParams;
            }
            if (this.zzbea == null) {
                this.zzbea = (MaskedWalletRequest)savedInstanceState.getParcelable("maskedWalletRequest");
            }
            if (this.zzbeb == null) {
                this.zzbeb = (MaskedWallet)savedInstanceState.getParcelable("maskedWallet");
            }
            if (savedInstanceState.containsKey("walletFragmentOptions")) {
                this.zzbdY = (WalletFragmentOptions)savedInstanceState.getParcelable("walletFragmentOptions");
            }
            if (savedInstanceState.containsKey("enabled")) {
                this.zzbec = savedInstanceState.getBoolean("enabled");
            }
        } else if (this.zzapz.getArguments() != null && (walletFragmentOptions = (WalletFragmentOptions)this.zzapz.getArguments().getParcelable("extraWalletFragmentOptions")) != null) {
            walletFragmentOptions.zzaT((Context)this.zzapz.getActivity());
            this.zzbdY = walletFragmentOptions;
        }
        this.mCreated = true;
        this.zzbej.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return this.zzbej.onCreateView(inflater, container, savedInstanceState);
    }

    public void onStart() {
        super.onStart();
        this.zzbej.onStart();
    }

    public void onResume() {
        super.onResume();
        this.zzbej.onResume();
        FragmentManager fragmentManager = this.zzapz.getActivity().getFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("GooglePlayServicesErrorDialog");
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commit();
            int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.zzapz.getActivity());
            GooglePlayServicesUtil.showErrorDialogFragment(n, this.zzapz.getActivity(), -1);
        }
    }

    public void onPause() {
        super.onPause();
        this.zzbej.onPause();
    }

    public void onStop() {
        super.onStop();
        this.zzbej.onStop();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.setClassLoader(WalletFragmentOptions.class.getClassLoader());
        this.zzbej.onSaveInstanceState(outState);
        if (this.zzbdZ != null) {
            outState.putParcelable("walletFragmentInitParams", (Parcelable)this.zzbdZ);
            this.zzbdZ = null;
        }
        if (this.zzbea != null) {
            outState.putParcelable("maskedWalletRequest", (Parcelable)this.zzbea);
            this.zzbea = null;
        }
        if (this.zzbeb != null) {
            outState.putParcelable("maskedWallet", (Parcelable)this.zzbeb);
            this.zzbeb = null;
        }
        if (this.zzbdY != null) {
            outState.putParcelable("walletFragmentOptions", (Parcelable)this.zzbdY);
            this.zzbdY = null;
        }
        if (this.zzbec != null) {
            outState.putBoolean("enabled", this.zzbec.booleanValue());
            this.zzbec = null;
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.mCreated = false;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (this.zzbeh != null) {
            this.zzbeh.onActivityResult(requestCode, resultCode, data);
        }
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(WalletFragment var1, int var2, int var3, Bundle var4);
    }

    static class zza
    extends zzri.zza {
        private OnStateChangedListener zzbel;
        private final WalletFragment zzbem;

        zza(WalletFragment walletFragment) {
            this.zzbem = walletFragment;
        }

        @Override
        public void zza(int n, int n2, Bundle bundle) {
            if (this.zzbel != null) {
                this.zzbel.onStateChanged(this.zzbem, n, n2, bundle);
            }
        }

        public void zza(OnStateChangedListener onStateChangedListener) {
            this.zzbel = onStateChangedListener;
        }
    }

    private static class zzb
    implements LifecycleDelegate {
        private final zzrh zzbef;

        private zzb(zzrh zzrh2) {
            this.zzbef = zzrh2;
        }

        private void initialize(WalletFragmentInitParams startParams) {
            try {
                this.zzbef.initialize(startParams);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void setEnabled(boolean enabled) {
            try {
                this.zzbef.setEnabled(enabled);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWalletRequest(MaskedWalletRequest request) {
            try {
                this.zzbef.updateMaskedWalletRequest(request);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWallet(MaskedWallet maskedWallet) {
            try {
                this.zzbef.updateMaskedWallet(maskedWallet);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private int getState() {
            try {
                return this.zzbef.getState();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onInflate(Activity activity, Bundle attrs, Bundle savedInstanceState) {
            WalletFragmentOptions walletFragmentOptions = (WalletFragmentOptions)attrs.getParcelable("extraWalletFragmentOptions");
            try {
                this.zzbef.zza(zze.zzy(activity), walletFragmentOptions, savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onCreate(Bundle savedInstanceState) {
            try {
                this.zzbef.onCreate(savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            try {
                zzd zzd2 = this.zzbef.onCreateView(zze.zzy(inflater), zze.zzy(container), savedInstanceState);
                return (View)zze.zzp(zzd2);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onStart() {
            try {
                this.zzbef.onStart();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onResume() {
            try {
                this.zzbef.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onPause() {
            try {
                this.zzbef.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onStop() {
            try {
                this.zzbef.onStop();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onDestroyView() {
        }

        @Override
        public void onDestroy() {
        }

        @Override
        public void onLowMemory() {
        }

        @Override
        public void onSaveInstanceState(Bundle outState) {
            try {
                this.zzbef.onSaveInstanceState(outState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void onActivityResult(int requestCode, int resultCode, Intent data) {
            try {
                this.zzbef.onActivityResult(requestCode, resultCode, data);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }
    }

    private class zzc
    extends com.google.android.gms.dynamic.zza<zzb>
    implements View.OnClickListener {
        private zzc() {
        }

        @Override
        protected void zza(zzf<zzb> zzf2) {
            Activity activity = WalletFragment.this.zzapz.getActivity();
            if (WalletFragment.this.zzbeh == null && WalletFragment.this.mCreated && activity != null) {
                try {
                    zzrh zzrh2 = zzrp.zza(activity, WalletFragment.this.zzbei, WalletFragment.this.zzbdY, WalletFragment.this.zzbek);
                    WalletFragment.this.zzbeh = new zzb(zzrh2);
                    WalletFragment.this.zzbdY = null;
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return;
                }
                zzf2.zza(WalletFragment.this.zzbeh);
                if (WalletFragment.this.zzbdZ != null) {
                    WalletFragment.this.zzbeh.initialize(WalletFragment.this.zzbdZ);
                    WalletFragment.this.zzbdZ = null;
                }
                if (WalletFragment.this.zzbea != null) {
                    WalletFragment.this.zzbeh.updateMaskedWalletRequest(WalletFragment.this.zzbea);
                    WalletFragment.this.zzbea = null;
                }
                if (WalletFragment.this.zzbeb != null) {
                    WalletFragment.this.zzbeh.updateMaskedWallet(WalletFragment.this.zzbeb);
                    WalletFragment.this.zzbeb = null;
                }
                if (WalletFragment.this.zzbec != null) {
                    WalletFragment.this.zzbeh.setEnabled(WalletFragment.this.zzbec);
                    WalletFragment.this.zzbec = null;
                }
            }
        }

        @Override
        protected void zza(FrameLayout frameLayout) {
            WalletFragmentStyle walletFragmentStyle;
            Button button = new Button((Context)WalletFragment.this.zzapz.getActivity());
            button.setText(R.string.wallet_buy_button_place_holder);
            int n = -1;
            int n2 = -2;
            if (WalletFragment.this.zzbdY != null && (walletFragmentStyle = WalletFragment.this.zzbdY.getFragmentStyle()) != null) {
                DisplayMetrics displayMetrics = WalletFragment.this.zzapz.getResources().getDisplayMetrics();
                n = walletFragmentStyle.zza("buyButtonWidth", displayMetrics, n);
                n2 = walletFragmentStyle.zza("buyButtonHeight", displayMetrics, n2);
            }
            button.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            button.setOnClickListener((View.OnClickListener)this);
            frameLayout.addView((View)button);
        }

        public void onClick(View view) {
            Activity activity = WalletFragment.this.zzapz.getActivity();
            int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)activity);
            GooglePlayServicesUtil.showErrorDialogFragment(n, activity, -1);
        }
    }
}

