/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.zza;

public final class WalletFragmentInitParams
implements SafeParcelable {
    public static final Parcelable.Creator<WalletFragmentInitParams> CREATOR = new zza();
    final int mVersionCode;
    private String zzRs;
    private MaskedWalletRequest zzbea;
    private int zzbeo;
    private MaskedWallet zzbeb;

    public static Builder newBuilder() {
        WalletFragmentInitParams walletFragmentInitParams = new WalletFragmentInitParams();
        walletFragmentInitParams.getClass();
        return walletFragmentInitParams.new Builder();
    }

    private WalletFragmentInitParams() {
        this.mVersionCode = 1;
        this.zzbeo = -1;
    }

    WalletFragmentInitParams(int versionCode, String accountName, MaskedWalletRequest maskedWalletRequest, int maskedWalletRequestCode, MaskedWallet maskedWallet) {
        this.mVersionCode = versionCode;
        this.zzRs = accountName;
        this.zzbea = maskedWalletRequest;
        this.zzbeo = maskedWalletRequestCode;
        this.zzbeb = maskedWallet;
    }

    public String getAccountName() {
        return this.zzRs;
    }

    public MaskedWalletRequest getMaskedWalletRequest() {
        return this.zzbea;
    }

    public int getMaskedWalletRequestCode() {
        return this.zzbeo;
    }

    public MaskedWallet getMaskedWallet() {
        return this.zzbeb;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zza.zza(this, dest, flags);
    }

    public final class Builder {
        private Builder() {
        }

        public Builder setAccountName(String accountName) {
            WalletFragmentInitParams.this.zzRs = accountName;
            return this;
        }

        public Builder setMaskedWalletRequest(MaskedWalletRequest request) {
            WalletFragmentInitParams.this.zzbea = request;
            return this;
        }

        public Builder setMaskedWalletRequestCode(int requestCode) {
            WalletFragmentInitParams.this.zzbeo = requestCode;
            return this;
        }

        public Builder setMaskedWallet(MaskedWallet maskedWallet) {
            WalletFragmentInitParams.this.zzbeb = maskedWallet;
            return this;
        }

        public WalletFragmentInitParams build() {
            zzx.zza(WalletFragmentInitParams.this.zzbeb != null && WalletFragmentInitParams.this.zzbea == null || WalletFragmentInitParams.this.zzbeb == null && WalletFragmentInitParams.this.zzbea != null, (Object)"Exactly one of MaskedWallet or MaskedWalletRequest is required");
            zzx.zza(WalletFragmentInitParams.this.zzbeo >= 0, (Object)"masked wallet request code is required and must be non-negative");
            return WalletFragmentInitParams.this;
        }
    }
}

