/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.content.Context;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzlb;
import com.google.android.gms.internal.zzlm;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.CapabilityApi;
import com.google.android.gms.wearable.Channel;
import com.google.android.gms.wearable.ChannelApi;
import com.google.android.gms.wearable.DataApi;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.DataItemBuffer;
import com.google.android.gms.wearable.MessageApi;
import com.google.android.gms.wearable.NodeApi;
import com.google.android.gms.wearable.PutDataRequest;
import com.google.android.gms.wearable.internal.PutDataResponse;
import com.google.android.gms.wearable.internal.zzav;
import com.google.android.gms.wearable.internal.zzax;
import com.google.android.gms.wearable.internal.zzay;
import com.google.android.gms.wearable.internal.zzbj;
import com.google.android.gms.wearable.internal.zzbn;
import com.google.android.gms.wearable.internal.zzbp;
import com.google.android.gms.wearable.internal.zzt;
import com.google.android.gms.wearable.zza;
import com.google.android.gms.wearable.zzc;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;

public class zzbo
extends zzj<zzax> {
    private final ExecutorService zzaYr = Executors.newCachedThreadPool();
    private final zzay<zzc.zza> zzbhf = new zzay();
    private final zzay<zza.zza> zzbhg = new zzay();
    private final zzay<ChannelApi.ChannelListener> zzbhh = new zzay();
    private final zzay<DataApi.DataListener> zzbhi = new zzay();
    private final zzay<MessageApi.MessageListener> zzbhj = new zzay();
    private final zzay<NodeApi.NodeListener> zzbhk = new zzay();
    private final zzay<NodeApi.zza> zzbhl = new zzay();
    private final Map<String, zzay<CapabilityApi.CapabilityListener>> zzbhm = new HashMap<String, zzay<CapabilityApi.CapabilityListener>>();

    public zzbo(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, zzf zzf2) {
        super(context, looper, 14, zzf2, connectionCallbacks, onConnectionFailedListener);
    }

    @Override
    protected String zzfK() {
        return "com.google.android.gms.wearable.BIND";
    }

    @Override
    protected String zzfL() {
        return "com.google.android.gms.wearable.internal.IWearableService";
    }

    protected zzax zzei(IBinder iBinder) {
        return zzax.zza.zzeg(iBinder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (Log.isLoggable((String)"WearableClient", (int)2)) {
            Log.d((String)"WearableClient", (String)("onPostInitHandler: statusCode " + n));
        }
        if (n == 0) {
            this.zzbhf.zzeh(iBinder);
            this.zzbhg.zzeh(iBinder);
            this.zzbhh.zzeh(iBinder);
            this.zzbhi.zzeh(iBinder);
            this.zzbhj.zzeh(iBinder);
            this.zzbhk.zzeh(iBinder);
            this.zzbhl.zzeh(iBinder);
            Map<String, zzay<CapabilityApi.CapabilityListener>> map = this.zzbhm;
            synchronized (map) {
                for (zzay<CapabilityApi.CapabilityListener> zzay2 : this.zzbhm.values()) {
                    zzay2.zzeh(iBinder);
                }
            }
        }
        super.zza(n, iBinder, bundle, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        this.zzbhf.zzb(this);
        this.zzbhg.zzb(this);
        this.zzbhh.zzb(this);
        this.zzbhi.zzb(this);
        this.zzbhj.zzb(this);
        this.zzbhk.zzb(this);
        this.zzbhl.zzb(this);
        Map<String, zzay<CapabilityApi.CapabilityListener>> map = this.zzbhm;
        synchronized (map) {
            for (zzay<CapabilityApi.CapabilityListener> zzay2 : this.zzbhm.values()) {
                zzay2.zzb(this);
            }
        }
        super.disconnect();
    }

    public void zza(zzlb.zzb<DataApi.DataItemResult> zzb2, PutDataRequest putDataRequest) throws RemoteException {
        Map.Entry<String, Asset> entry22;
        for (Map.Entry<String, Asset> entry22 : putDataRequest.getAssets().entrySet()) {
            Asset asset = entry22.getValue();
            if (asset.getData() != null || asset.getDigest() != null || asset.getFd() != null || asset.getUri() != null) continue;
            throw new IllegalArgumentException("Put for " + putDataRequest.getUri() + " contains invalid asset: " + asset);
        }
        PutDataRequest putDataRequest2 = PutDataRequest.zzo(putDataRequest.getUri());
        putDataRequest2.setData(putDataRequest.getData());
        entry22 = new ArrayList();
        for (Map.Entry entry3 : putDataRequest.getAssets().entrySet()) {
            Object object;
            ParcelFileDescriptor parcelFileDescriptor;
            Asset asset = (Asset)entry3.getValue();
            if (asset.getData() != null) {
                try {
                    parcelFileDescriptor = ParcelFileDescriptor.createPipe();
                }
                catch (IOException iOException) {
                    throw new IllegalStateException("Unable to create ParcelFileDescriptor for asset in request: " + putDataRequest, iOException);
                }
                if (Log.isLoggable((String)"WearableClient", (int)3)) {
                    Log.d((String)"WearableClient", (String)("processAssets: replacing data with FD in asset: " + asset + " read:" + parcelFileDescriptor[0] + " write:" + parcelFileDescriptor[1]));
                }
                putDataRequest2.putAsset((String)entry3.getKey(), Asset.createFromFd(parcelFileDescriptor[0]));
                object = this.zza(parcelFileDescriptor[1], asset.getData());
                entry22.add(object);
                this.zzaYr.submit((Runnable)object);
                continue;
            }
            if (asset.getUri() != null) {
                try {
                    parcelFileDescriptor = this.getContext().getContentResolver().openFileDescriptor(asset.getUri(), "r");
                    object = Asset.createFromFd(parcelFileDescriptor);
                    putDataRequest2.putAsset((String)entry3.getKey(), (Asset)object);
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    new zzbn.zzq(zzb2, (List<FutureTask<Boolean>>)((Object)entry22)).zza(new PutDataResponse(4005, null));
                    Log.w((String)"WearableClient", (String)("Couldn't resolve asset URI: " + asset.getUri()));
                    return;
                }
            }
            putDataRequest2.putAsset((String)entry3.getKey(), asset);
        }
        ((zzax)this.zzpc()).zza((zzav)new zzbn.zzq(zzb2, (List<FutureTask<Boolean>>)((Object)entry22)), putDataRequest2);
    }

    private FutureTask<Boolean> zza(final ParcelFileDescriptor parcelFileDescriptor, final byte[] byArray) {
        return new FutureTask<Boolean>(new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean zzFd() {
                if (Log.isLoggable((String)"WearableClient", (int)3)) {
                    Log.d((String)"WearableClient", (String)("processAssets: writing data to FD : " + parcelFileDescriptor));
                }
                ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream = new ParcelFileDescriptor.AutoCloseOutputStream(parcelFileDescriptor);
                try {
                    autoCloseOutputStream.write(byArray);
                    autoCloseOutputStream.flush();
                    if (Log.isLoggable((String)"WearableClient", (int)3)) {
                        Log.d((String)"WearableClient", (String)("processAssets: wrote data: " + parcelFileDescriptor));
                    }
                    Boolean bl = true;
                    return bl;
                }
                catch (IOException iOException) {
                    Log.w((String)"WearableClient", (String)("processAssets: writing data failed: " + parcelFileDescriptor));
                }
                finally {
                    try {
                        if (Log.isLoggable((String)"WearableClient", (int)3)) {
                            Log.d((String)"WearableClient", (String)("processAssets: closing: " + parcelFileDescriptor));
                        }
                        autoCloseOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                return false;
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.zzFd();
            }
        });
    }

    public void zza(zzlb.zzb<DataApi.DataItemResult> zzb2, Uri uri) throws RemoteException {
        ((zzax)this.zzpc()).zza((zzav)new zzbn.zzk(zzb2), uri);
    }

    public void zzm(zzlb.zzb<DataItemBuffer> zzb2) throws RemoteException {
        ((zzax)this.zzpc()).zzb(new zzbn.zzl(zzb2));
    }

    public void zza(zzlb.zzb<DataItemBuffer> zzb2, Uri uri, int n) throws RemoteException {
        ((zzax)this.zzpc()).zza((zzav)new zzbn.zzl(zzb2), uri, n);
    }

    public void zzb(zzlb.zzb<DataApi.DeleteDataItemsResult> zzb2, Uri uri, int n) throws RemoteException {
        ((zzax)this.zzpc()).zzb((zzav)new zzbn.zze(zzb2), uri, n);
    }

    public void zza(zzlb.zzb<MessageApi.SendMessageResult> zzb2, String string2, String string3, byte[] byArray) throws RemoteException {
        ((zzax)this.zzpc()).zza(new zzbn.zzt(zzb2), string2, string3, byArray);
    }

    public void zza(zzlb.zzb<DataApi.GetFdForAssetResult> zzb2, Asset asset) throws RemoteException {
        ((zzax)this.zzpc()).zza((zzav)new zzbn.zzm(zzb2), asset);
    }

    public void zza(zzlb.zzb<DataApi.GetFdForAssetResult> zzb2, DataItemAsset dataItemAsset) throws RemoteException {
        this.zza(zzb2, Asset.createFromRef(dataItemAsset.getId()));
    }

    public void zzn(zzlb.zzb<NodeApi.GetLocalNodeResult> zzb2) throws RemoteException {
        ((zzax)this.zzpc()).zzc(new zzbn.zzn(zzb2));
    }

    public void zzo(zzlb.zzb<NodeApi.GetConnectedNodesResult> zzb2) throws RemoteException {
        ((zzax)this.zzpc()).zzd(new zzbn.zzj(zzb2));
    }

    public void zzg(zzlb.zzb<CapabilityApi.GetCapabilityResult> zzb2, String string2, int n) throws RemoteException {
        ((zzax)this.zzpc()).zza((zzav)new zzbn.zzg(zzb2), string2, n);
    }

    public void zzb(zzlb.zzb<CapabilityApi.GetAllCapabilitiesResult> zzb2, int n) throws RemoteException {
        ((zzax)this.zzpc()).zza((zzav)new zzbn.zzf(zzb2), n);
    }

    public void zzr(zzlb.zzb<CapabilityApi.AddLocalCapabilityResult> zzb2, String string2) throws RemoteException {
        ((zzax)this.zzpc()).zzd(new zzbn.zza(zzb2), string2);
    }

    public void zzs(zzlb.zzb<CapabilityApi.RemoveLocalCapabilityResult> zzb2, String string2) throws RemoteException {
        ((zzax)this.zzpc()).zze(new zzbn.zzs(zzb2), string2);
    }

    public void zze(zzlb.zzb<ChannelApi.OpenChannelResult> zzb2, String string2, String string3) throws RemoteException {
        ((zzax)this.zzpc()).zza((zzav)new zzbn.zzp(zzb2), string2, string3);
    }

    public void zzt(zzlb.zzb<Status> zzb2, String string2) throws RemoteException {
        ((zzax)this.zzpc()).zzf(new zzbn.zzc(zzb2), string2);
    }

    public void zzh(zzlb.zzb<Status> zzb2, String string2, int n) throws RemoteException {
        ((zzax)this.zzpc()).zzb((zzav)new zzbn.zzd(zzb2), string2, n);
    }

    public void zzu(zzlb.zzb<Channel.GetInputStreamResult> zzb2, String string2) throws RemoteException {
        zzt zzt2 = new zzt();
        ((zzax)this.zzpc()).zza((zzav)new zzbn.zzh(zzb2, zzt2), zzt2, string2);
    }

    public void zzv(zzlb.zzb<Channel.GetOutputStreamResult> zzb2, String string2) throws RemoteException {
        zzt zzt2 = new zzt();
        ((zzax)this.zzpc()).zzb((zzav)new zzbn.zzi(zzb2, zzt2), zzt2, string2);
    }

    public void zza(zzlb.zzb<Status> zzb2, String string2, Uri uri, boolean bl) {
        try {
            this.zzaYr.execute(this.zzb(zzb2, string2, uri, bl));
        }
        catch (RuntimeException runtimeException) {
            zzb2.zzv(new Status(8));
            throw runtimeException;
        }
    }

    public void zza(zzlb.zzb<Status> zzb2, String string2, Uri uri, long l2, long l3) {
        try {
            this.zzaYr.execute(this.zzb(zzb2, string2, uri, l2, l3));
        }
        catch (RuntimeException runtimeException) {
            zzb2.zzv(new Status(8));
            throw runtimeException;
        }
    }

    public void zza(zzlb.zzb<Status> zzb2, zzc.zza zza2, zzlm<zzc.zza> zzlm2) throws RemoteException {
        this.zzbhf.zza(this, zzb2, zza2, zzbp.zzf(zzlm2));
    }

    public void zza(zzlb.zzb<Status> zzb2, zza.zza zza2, zzlm<zza.zza> zzlm2) throws RemoteException {
        this.zzbhg.zza(this, zzb2, zza2, zzbp.zze(zzlm2));
    }

    public void zza(zzlb.zzb<Status> zzb2, DataApi.DataListener dataListener, zzlm<DataApi.DataListener> zzlm2, IntentFilter[] intentFilterArray) throws RemoteException {
        this.zzbhi.zza(this, zzb2, dataListener, zzbp.zza(zzlm2, intentFilterArray));
    }

    public void zza(zzlb.zzb<Status> zzb2, MessageApi.MessageListener messageListener, zzlm<MessageApi.MessageListener> zzlm2, IntentFilter[] intentFilterArray) throws RemoteException {
        this.zzbhj.zza(this, zzb2, messageListener, zzbp.zzb(zzlm2, intentFilterArray));
    }

    public void zza(zzlb.zzb<Status> zzb2, NodeApi.NodeListener nodeListener, zzlm<NodeApi.NodeListener> zzlm2) throws RemoteException {
        this.zzbhk.zza(this, zzb2, nodeListener, zzbp.zzg(zzlm2));
    }

    public void zza(zzlb.zzb<Status> zzb2, NodeApi.zza zza2, zzlm<NodeApi.zza> zzlm2) throws RemoteException {
        this.zzbhl.zza(this, zzb2, zza2, zzbp.zzh(zzlm2));
    }

    private zzay<CapabilityApi.CapabilityListener> zzfy(String string2) {
        zzay<CapabilityApi.CapabilityListener> zzay2 = this.zzbhm.get(string2);
        if (zzay2 == null) {
            zzay2 = new zzay();
            this.zzbhm.put(string2, zzay2);
        }
        return zzay2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(zzlb.zzb<Status> zzb2, CapabilityApi.CapabilityListener capabilityListener, zzlm<CapabilityApi.CapabilityListener> zzlm2, String string2) throws RemoteException {
        Map<String, zzay<CapabilityApi.CapabilityListener>> map = this.zzbhm;
        synchronized (map) {
            this.zzfy(string2).zza(this, zzb2, capabilityListener, zzbp.zzc(zzlm2, string2));
        }
    }

    public void zza(zzlb.zzb<Status> zzb2, ChannelApi.ChannelListener channelListener, zzlm<ChannelApi.ChannelListener> zzlm2, String string2) throws RemoteException {
        if (string2 == null) {
            this.zzbhh.zza(this, zzb2, channelListener, zzbp.zzi(zzlm2));
        } else {
            zzbj zzbj2 = new zzbj(string2, channelListener);
            this.zzbhh.zza(this, zzb2, zzbj2, zzbp.zzb(zzlm2, string2));
        }
    }

    public void zza(zzlb.zzb<Status> zzb2, DataApi.DataListener dataListener) throws RemoteException {
        this.zzbhi.zza(this, zzb2, dataListener);
    }

    public void zza(zzlb.zzb<Status> zzb2, MessageApi.MessageListener messageListener) throws RemoteException {
        this.zzbhj.zza(this, zzb2, messageListener);
    }

    public void zza(zzlb.zzb<Status> zzb2, NodeApi.NodeListener nodeListener) throws RemoteException {
        this.zzbhk.zza(this, zzb2, nodeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(zzlb.zzb<Status> zzb2, CapabilityApi.CapabilityListener capabilityListener, String string2) throws RemoteException {
        Map<String, zzay<CapabilityApi.CapabilityListener>> map = this.zzbhm;
        synchronized (map) {
            zzay<CapabilityApi.CapabilityListener> zzay2 = this.zzfy(string2);
            zzay2.zza(this, zzb2, capabilityListener);
            if (zzay2.isEmpty()) {
                this.zzbhm.remove(string2);
            }
        }
    }

    public void zza(zzlb.zzb<Status> zzb2, ChannelApi.ChannelListener channelListener, String string2) throws RemoteException {
        if (string2 == null) {
            this.zzbhh.zza(this, zzb2, channelListener);
        } else {
            zzbj zzbj2 = new zzbj(string2, channelListener);
            this.zzbhh.zza(this, zzb2, zzbj2);
        }
    }

    private Runnable zzb(final zzlb.zzb<Status> zzb2, final String string2, final Uri uri, final boolean bl) {
        zzx.zzw(zzb2);
        zzx.zzw(string2);
        zzx.zzw(uri);
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ParcelFileDescriptor parcelFileDescriptor;
                if (Log.isLoggable((String)"WearableClient", (int)2)) {
                    Log.v((String)"WearableClient", (String)"Executing receiveFileFromChannelTask");
                }
                if (!"file".equals(uri.getScheme())) {
                    Log.w((String)"WearableClient", (String)"Channel.receiveFile used with non-file URI");
                    zzb2.zzv(new Status(10, "Channel.receiveFile used with non-file URI"));
                    return;
                }
                File file = new File(uri.getPath());
                int n = 0x20000000 | (bl ? 0x2000000 : 0);
                try {
                    parcelFileDescriptor = ParcelFileDescriptor.open((File)file, (int)n);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Log.w((String)"WearableClient", (String)("File couldn't be opened for Channel.receiveFile: " + file));
                    zzb2.zzv(new Status(13));
                    return;
                }
                try {
                    ((zzax)zzbo.this.zzpc()).zza((zzav)new zzbn.zzu(zzb2), string2, parcelFileDescriptor);
                }
                catch (RemoteException remoteException) {
                    Log.w((String)"WearableClient", (String)"Channel.receiveFile failed.", (Throwable)remoteException);
                    zzb2.zzv(new Status(8));
                }
                finally {
                    try {
                        parcelFileDescriptor.close();
                    }
                    catch (IOException iOException) {
                        Log.w((String)"WearableClient", (String)"Failed to close targetFd", (Throwable)iOException);
                    }
                }
            }
        };
    }

    private Runnable zzb(final zzlb.zzb<Status> zzb2, final String string2, final Uri uri, final long l2, final long l3) {
        zzx.zzw(zzb2);
        zzx.zzw(string2);
        zzx.zzw(uri);
        zzx.zzb(l2 >= 0L, "startOffset is negative: %s", l2);
        zzx.zzb(l3 >= -1L, "invalid length: %s", l3);
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ParcelFileDescriptor parcelFileDescriptor;
                if (Log.isLoggable((String)"WearableClient", (int)2)) {
                    Log.v((String)"WearableClient", (String)"Executing sendFileToChannelTask");
                }
                if (!"file".equals(uri.getScheme())) {
                    Log.w((String)"WearableClient", (String)"Channel.sendFile used with non-file URI");
                    zzb2.zzv(new Status(10, "Channel.sendFile used with non-file URI"));
                    return;
                }
                File file = new File(uri.getPath());
                try {
                    parcelFileDescriptor = ParcelFileDescriptor.open((File)file, (int)0x10000000);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Log.w((String)"WearableClient", (String)("File couldn't be opened for Channel.sendFile: " + file));
                    zzb2.zzv(new Status(13));
                    return;
                }
                try {
                    ((zzax)zzbo.this.zzpc()).zza(new zzbn.zzr(zzb2), string2, parcelFileDescriptor, l2, l3);
                }
                catch (RemoteException remoteException) {
                    Log.w((String)"WearableClient", (String)"Channel.sendFile failed.", (Throwable)remoteException);
                    zzb2.zzv(new Status(8));
                }
                finally {
                    try {
                        parcelFileDescriptor.close();
                    }
                    catch (IOException iOException) {
                        Log.w((String)"WearableClient", (String)"Failed to close sourceFd", (Throwable)iOException);
                    }
                }
            }
        };
    }

    @Override
    protected /* synthetic */ IInterface zzW(IBinder iBinder) {
        return this.zzei(iBinder);
    }
}

