/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.content.IntentFilter;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.internal.zzlb;
import com.google.android.gms.internal.zzlm;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataApi;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.DataItemBuffer;
import com.google.android.gms.wearable.PutDataRequest;
import com.google.android.gms.wearable.internal.zzb;
import com.google.android.gms.wearable.internal.zzbo;
import com.google.android.gms.wearable.internal.zzi;
import java.io.IOException;
import java.io.InputStream;

public final class zzx
implements DataApi {
    @Override
    public PendingResult<DataApi.DataItemResult> putDataItem(GoogleApiClient client, final PutDataRequest request) {
        return client.zza(new zzi<DataApi.DataItemResult>(client){

            @Override
            protected void zza(zzbo zzbo2) throws RemoteException {
                zzbo2.zza((zzlb.zzb<DataApi.DataItemResult>)this, request);
            }

            public DataApi.DataItemResult zzbn(Status status) {
                return new zza(status, null);
            }

            @Override
            public /* synthetic */ Result zzb(Status status) {
                return this.zzbn(status);
            }
        });
    }

    @Override
    public PendingResult<DataApi.DataItemResult> getDataItem(GoogleApiClient client, final Uri uri) {
        return client.zza(new zzi<DataApi.DataItemResult>(client){

            @Override
            protected void zza(zzbo zzbo2) throws RemoteException {
                zzbo2.zza((zzlb.zzb<DataApi.DataItemResult>)this, uri);
            }

            protected DataApi.DataItemResult zzbn(Status status) {
                return new zza(status, null);
            }

            @Override
            protected /* synthetic */ Result zzb(Status status) {
                return this.zzbn(status);
            }
        });
    }

    @Override
    public PendingResult<DataItemBuffer> getDataItems(GoogleApiClient client) {
        return client.zza(new zzi<DataItemBuffer>(client){

            @Override
            protected void zza(zzbo zzbo2) throws RemoteException {
                zzbo2.zzm(this);
            }

            protected DataItemBuffer zzbo(Status status) {
                return new DataItemBuffer(DataHolder.zzbu(status.getStatusCode()));
            }

            @Override
            protected /* synthetic */ Result zzb(Status status) {
                return this.zzbo(status);
            }
        });
    }

    @Override
    public PendingResult<DataItemBuffer> getDataItems(GoogleApiClient client, Uri uri) {
        return this.getDataItems(client, uri, 0);
    }

    @Override
    public PendingResult<DataItemBuffer> getDataItems(GoogleApiClient client, final Uri uri, final int filterType) {
        return client.zza(new zzi<DataItemBuffer>(client){

            @Override
            protected void zza(zzbo zzbo2) throws RemoteException {
                zzbo2.zza(this, uri, filterType);
            }

            protected DataItemBuffer zzbo(Status status) {
                return new DataItemBuffer(DataHolder.zzbu(status.getStatusCode()));
            }

            @Override
            protected /* synthetic */ Result zzb(Status status) {
                return this.zzbo(status);
            }
        });
    }

    @Override
    public PendingResult<DataApi.DeleteDataItemsResult> deleteDataItems(GoogleApiClient client, Uri uri) {
        return this.deleteDataItems(client, uri, 0);
    }

    @Override
    public PendingResult<DataApi.DeleteDataItemsResult> deleteDataItems(GoogleApiClient client, final Uri uri, final int filterType) {
        return client.zza(new zzi<DataApi.DeleteDataItemsResult>(client){

            @Override
            protected void zza(zzbo zzbo2) throws RemoteException {
                zzbo2.zzb(this, uri, filterType);
            }

            protected DataApi.DeleteDataItemsResult zzbp(Status status) {
                return new zzb(status, 0);
            }

            @Override
            protected /* synthetic */ Result zzb(Status status) {
                return this.zzbp(status);
            }
        });
    }

    private void zza(Asset asset) {
        if (asset == null) {
            throw new IllegalArgumentException("asset is null");
        }
        if (asset.getDigest() == null) {
            throw new IllegalArgumentException("invalid asset");
        }
        if (asset.getData() != null) {
            throw new IllegalArgumentException("invalid asset");
        }
    }

    @Override
    public PendingResult<DataApi.GetFdForAssetResult> getFdForAsset(GoogleApiClient client, final Asset asset) {
        this.zza(asset);
        return client.zza(new zzi<DataApi.GetFdForAssetResult>(client){

            @Override
            protected void zza(zzbo zzbo2) throws RemoteException {
                zzbo2.zza((zzlb.zzb<DataApi.GetFdForAssetResult>)this, asset);
            }

            protected DataApi.GetFdForAssetResult zzbq(Status status) {
                return new zzc(status, null);
            }

            @Override
            protected /* synthetic */ Result zzb(Status status) {
                return this.zzbq(status);
            }
        });
    }

    @Override
    public PendingResult<DataApi.GetFdForAssetResult> getFdForAsset(GoogleApiClient client, final DataItemAsset asset) {
        return client.zza(new zzi<DataApi.GetFdForAssetResult>(client){

            @Override
            protected void zza(zzbo zzbo2) throws RemoteException {
                zzbo2.zza((zzlb.zzb<DataApi.GetFdForAssetResult>)this, asset);
            }

            protected DataApi.GetFdForAssetResult zzbq(Status status) {
                return new zzc(status, null);
            }

            @Override
            protected /* synthetic */ Result zzb(Status status) {
                return this.zzbq(status);
            }
        });
    }

    @Override
    public PendingResult<Status> addListener(GoogleApiClient client, DataApi.DataListener listener) {
        return this.zza(client, listener, null);
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, DataApi.DataListener dataListener, IntentFilter[] intentFilterArray) {
        return com.google.android.gms.wearable.internal.zzb.zza(googleApiClient, zzx.zza(intentFilterArray), dataListener);
    }

    private static zzb.zza<DataApi.DataListener> zza(final IntentFilter[] intentFilterArray) {
        return new zzb.zza<DataApi.DataListener>(){

            @Override
            public void zza(zzbo zzbo2, zzlb.zzb<Status> zzb2, DataApi.DataListener dataListener, zzlm<DataApi.DataListener> zzlm2) throws RemoteException {
                zzbo2.zza(zzb2, dataListener, zzlm2, intentFilterArray);
            }
        };
    }

    @Override
    public PendingResult<Status> removeListener(GoogleApiClient client, final DataApi.DataListener listener) {
        return client.zza(new zzi<Status>(client){

            @Override
            protected void zza(zzbo zzbo2) throws RemoteException {
                zzbo2.zza((zzlb.zzb<Status>)this, listener);
            }

            public Status zzd(Status status) {
                return status;
            }

            @Override
            public /* synthetic */ Result zzb(Status status) {
                return this.zzd(status);
            }
        });
    }

    public static class zzc
    implements DataApi.GetFdForAssetResult {
        private final Status zzSC;
        private volatile ParcelFileDescriptor zzbgx;
        private volatile InputStream zzbgg;
        private volatile boolean mClosed = false;

        public zzc(Status status, ParcelFileDescriptor parcelFileDescriptor) {
            this.zzSC = status;
            this.zzbgx = parcelFileDescriptor;
        }

        @Override
        public Status getStatus() {
            return this.zzSC;
        }

        @Override
        public ParcelFileDescriptor getFd() {
            if (this.mClosed) {
                throw new IllegalStateException("Cannot access the file descriptor after release().");
            }
            return this.zzbgx;
        }

        @Override
        public InputStream getInputStream() {
            if (this.mClosed) {
                throw new IllegalStateException("Cannot access the input stream after release().");
            }
            if (this.zzbgx == null) {
                return null;
            }
            if (this.zzbgg == null) {
                this.zzbgg = new ParcelFileDescriptor.AutoCloseInputStream(this.zzbgx);
            }
            return this.zzbgg;
        }

        @Override
        public void release() {
            if (this.zzbgx == null) {
                return;
            }
            if (this.mClosed) {
                throw new IllegalStateException("releasing an already released result.");
            }
            try {
                if (this.zzbgg != null) {
                    this.zzbgg.close();
                } else {
                    this.zzbgx.close();
                }
                this.mClosed = true;
                this.zzbgx = null;
                this.zzbgg = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class zzb
    implements DataApi.DeleteDataItemsResult {
        private final Status zzSC;
        private final int zzbgw;

        public zzb(Status status, int n) {
            this.zzSC = status;
            this.zzbgw = n;
        }

        @Override
        public Status getStatus() {
            return this.zzSC;
        }

        @Override
        public int getNumDeleted() {
            return this.zzbgw;
        }
    }

    public static class zza
    implements DataApi.DataItemResult {
        private final Status zzSC;
        private final DataItem zzbgv;

        public zza(Status status, DataItem dataItem) {
            this.zzSC = status;
            this.zzbgv = dataItem;
        }

        @Override
        public Status getStatus() {
            return this.zzSC;
        }

        @Override
        public DataItem getDataItem() {
            return this.zzbgv;
        }
    }
}

