/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.arabic;

import edu.stanford.nlp.international.arabic.pipeline.DefaultLexicalMapper;
import edu.stanford.nlp.international.morph.MorphoFeatureSpecification;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.trees.BobChrisTreeNormalizer;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.international.arabic.ArabicTreebankLanguagePack;
import edu.stanford.nlp.trees.treebank.Mapper;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.util.Pair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class ArabicTreeNormalizer
extends BobChrisTreeNormalizer {
    private final boolean retainNPTmp;
    private final boolean retainNPSbj;
    private final boolean markPRDverb;
    private final boolean changeNoLabels;
    private final boolean retainPPClr;
    private final Pattern prdPattern;
    private final TregexPattern prdVerbPattern;
    private final TregexPattern npSbjPattern;
    private final String rootLabel;
    private final Mapper lexMapper = new DefaultLexicalMapper();
    private static final long serialVersionUID = -1592231121068698494L;

    public ArabicTreeNormalizer(boolean retainNPTmp, boolean markPRDverb, boolean changeNoLabels, boolean retainNPSbj, boolean retainPPClr) {
        super(new ArabicTreebankLanguagePack());
        this.retainNPTmp = retainNPTmp;
        this.retainNPSbj = retainNPSbj;
        this.markPRDverb = markPRDverb;
        this.changeNoLabels = changeNoLabels;
        this.retainPPClr = retainPPClr;
        this.rootLabel = this.tlp.startSymbol();
        this.prdVerbPattern = TregexPattern.compile("/^V[^P]/ > VP $ /-PRD$/=prd");
        this.prdPattern = Pattern.compile("^[A-Z]+-PRD");
        this.npSbjPattern = TregexPattern.compile("/^NP-SBJ/ !> @VP");
        this.emptyFilter = new ArabicEmptyFilter();
    }

    public ArabicTreeNormalizer(boolean retainNPTmp, boolean markPRDverb, boolean changeNoLabels) {
        this(retainNPTmp, markPRDverb, changeNoLabels, false, false);
    }

    public ArabicTreeNormalizer(boolean retainNPTmp, boolean markPRDverb) {
        this(retainNPTmp, markPRDverb, false);
    }

    public ArabicTreeNormalizer(boolean retainNPTmp) {
        this(retainNPTmp, false);
    }

    public ArabicTreeNormalizer() {
        this(false);
    }

    @Override
    public String normalizeNonterminal(String category) {
        String normalizedString = this.changeNoLabels ? category : (this.retainNPTmp && category != null && category.startsWith("NP-TMP") ? "NP-TMP" : (this.retainNPSbj && category != null && category.startsWith("NP-SBJ") ? "NP-SBJ" : (this.retainPPClr && category != null && category.startsWith("PP-CLR") ? "PP-CLR" : (this.markPRDverb && category != null && this.prdPattern.matcher(category).matches() ? category : super.normalizeNonterminal(category)))));
        return normalizedString.intern();
    }

    @Override
    public Tree normalizeWholeTree(Tree tree, TreeFactory tf) {
        Tree match;
        TregexMatcher m;
        tree = tree.prune(this.emptyFilter, tf).spliceOut(this.aOverAFilter, tf);
        for (Tree t : tree) {
            if (t.isLeaf()) {
                if (!t.value().contains("~#")) continue;
                String[] toks = t.value().split("~#");
                if (toks.length != 2) {
                    System.err.printf("%s: Word contains malformed morph annotation: %s%n", this.getClass().getName(), t.value());
                    continue;
                }
                if (t.label() instanceof CoreLabel) {
                    ((CoreLabel)t.label()).setValue(toks[0].trim().intern());
                    ((CoreLabel)t.label()).setWord(toks[0].trim().intern());
                    Pair<String, String> lemmaMorph = MorphoFeatureSpecification.splitMorphString(toks[0], toks[1]);
                    String lemma = lemmaMorph.first();
                    String morphAnalysis = lemmaMorph.second();
                    if (lemma.equals(toks[0])) {
                        ((CoreLabel)t.label()).setOriginalText(toks[1].trim().intern());
                        continue;
                    }
                    String newLemma = this.lexMapper.map(null, lemma);
                    if (newLemma == null || newLemma.trim().length() == 0) {
                        newLemma = lemma;
                    }
                    String newMorphAnalysis = newLemma + "|||" + morphAnalysis;
                    ((CoreLabel)t.label()).setOriginalText(newMorphAnalysis.intern());
                    continue;
                }
                System.err.printf("%s: Cannot store morph analysis in non-CoreLabel: %s%n", this.getClass().getName(), t.label().getClass().getName());
                continue;
            }
            if (t.isPreTerminal()) {
                if (t.value() == null || t.value().equals("")) {
                    System.err.printf("%s: missing tag for\n%s\n", this.getClass().getName(), t.pennString());
                    continue;
                }
                if (!(t.label() instanceof HasTag)) continue;
                ((HasTag)((Object)t.label())).setTag(t.value());
                continue;
            }
            int nk = t.numChildren();
            ArrayList<Tree> newKids = new ArrayList<Tree>(nk);
            for (int j = 0; j < nk; ++j) {
                Tree child = t.getChild(j);
                if (child.isLeaf()) {
                    System.err.printf("%s: Splicing in DUMMYTAG for%n%s%n", this.getClass().getName(), t.toString());
                    newKids.add(tf.newTreeNode("DUMMYTAG", Collections.singletonList(child)));
                    continue;
                }
                newKids.add(child);
            }
            t.setChildren(newKids);
        }
        if (this.markPRDverb) {
            m = this.prdVerbPattern.matcher(tree);
            match = null;
            while (m.find()) {
                if (m.getMatch() == match) continue;
                match = m.getMatch();
                match.label().setValue(match.label().value() + "-PRDverb");
                Tree prd = m.getNode("prd");
                prd.label().setValue(super.normalizeNonterminal(prd.label().value()));
            }
        }
        if (this.retainNPSbj) {
            m = this.npSbjPattern.matcher(tree);
            while (m.find()) {
                match = m.getMatch();
                match.label().setValue("NP");
            }
        }
        if (tree.isPreTerminal()) {
            String val = tree.label().value();
            if (val.equals("CC") || val.startsWith("PUNC") || val.equals("CONJ")) {
                System.err.printf("%s: Bare tagged word being wrapped in FRAG\n%s\n", this.getClass().getName(), tree.pennString());
                tree = tf.newTreeNode("FRAG", Collections.singletonList(tree));
            } else {
                System.err.printf("%s: Bare tagged word\n%s\n", this.getClass().getName(), tree.pennString());
            }
        }
        while (tree != null && (tree.value() == null || tree.value().equals("")) && tree.numChildren() <= 1) {
            tree = tree.firstChild();
        }
        if (tree != null && !tree.value().equals(this.rootLabel)) {
            tree = tf.newTreeNode(this.rootLabel, Collections.singletonList(tree));
        }
        return tree;
    }

    public static class ArabicEmptyFilter
    implements Predicate<Tree>,
    Serializable {
        private static final long serialVersionUID = 7417844982953945964L;

        @Override
        public boolean test(Tree t) {
            if (t.isPreTerminal() && (t.value().equals("PRON_1S") || t.value().equals("PRP")) && (t.firstChild().value().equals("nullp") || t.firstChild().value().equals("\u0646\u0644\u0644\u0629") || t.firstChild().value().equals("-~a"))) {
                return false;
            }
            return !t.isPreTerminal() || t.value() == null || !t.value().equals("-NONE-");
        }
    }
}

