/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.HashIndex;
import edu.stanford.nlp.util.Index;
import java.io.Writer;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DeltaIndex<E>
extends AbstractCollection<E>
implements Index<E> {
    private static final long serialVersionUID = -1459230891686013411L;
    private final Index<E> backingIndex;
    private final Index<E> spilloverIndex;
    private final int backingIndexSize;
    private boolean locked;

    public DeltaIndex(Index<E> backingIndex) {
        this(backingIndex, new HashIndex());
    }

    public DeltaIndex(Index<E> backingIndex, Index<E> spilloverIndex) {
        this.backingIndex = backingIndex;
        this.spilloverIndex = spilloverIndex;
        this.backingIndexSize = backingIndex.size();
    }

    @Override
    public int size() {
        return this.backingIndex.size() + this.spilloverIndex.size();
    }

    @Override
    public E get(int i) {
        if (i < this.backingIndexSize) {
            return this.backingIndex.get(i);
        }
        return this.spilloverIndex.get(i - this.backingIndexSize);
    }

    @Override
    public int indexOf(E o) {
        int index = this.backingIndex.indexOf(o);
        if (index >= 0) {
            return index;
        }
        index = this.spilloverIndex.indexOf(o);
        if (index >= 0) {
            return index + this.backingIndexSize;
        }
        return index;
    }

    @Override
    public int addToIndex(E o) {
        int index = this.backingIndex.indexOf(o);
        if (index >= 0) {
            return index;
        }
        index = this.locked ? this.spilloverIndex.indexOf(o) : this.spilloverIndex.addToIndex(o);
        if (index >= 0) {
            return index + this.backingIndexSize;
        }
        return index;
    }

    @Override
    @Deprecated
    public int indexOf(E o, boolean add) {
        if (add) {
            return this.addToIndex(o);
        }
        return this.indexOf(o);
    }

    @Override
    public List<E> objectsList() {
        ArrayList<E> result = new ArrayList<E>();
        if (result.size() > this.backingIndexSize) {
            result.addAll(this.backingIndex.objectsList().subList(0, this.backingIndexSize));
        } else {
            result.addAll(this.backingIndex.objectsList());
        }
        result.addAll(this.spilloverIndex.objectsList());
        return Collections.unmodifiableList(result);
    }

    @Override
    public Collection<E> objects(int[] indices) {
        ArrayList<E> result = new ArrayList<E>();
        for (int index : indices) {
            result.add(this.get(index));
        }
        return result;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void lock() {
        this.locked = true;
    }

    @Override
    public void unlock() {
        this.locked = false;
    }

    @Override
    public void saveToWriter(Writer out2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void saveToFilename(String s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        return this.backingIndex.contains(o) || this.spilloverIndex.contains(o);
    }

    @Override
    public boolean add(E e) {
        if (this.backingIndex.contains(e)) {
            return false;
        }
        return this.spilloverIndex.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean changed = false;
        for (E e : c) {
            if (!this.add(e)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.backingIndexSize == 0 && this.spilloverIndex.size() == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            Iterator<E> backingIterator;
            Iterator<E> spilloverIterator;
            {
                this.backingIterator = DeltaIndex.this.backingIndex.iterator();
                this.spilloverIterator = DeltaIndex.this.spilloverIndex.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.backingIterator.hasNext() || this.spilloverIterator.hasNext();
            }

            @Override
            public E next() {
                if (this.backingIterator.hasNext()) {
                    return this.backingIterator.next();
                }
                return this.spilloverIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public String toString() {
        return this.backingIndex.toString() + "," + this.spilloverIndex.toString();
    }
}

