/*
 * Decompiled with CFR 0.152.
 */
package com.dk.log;

import android.util.Log;
import com.dk.log.DKLogCallback;

public class DKLog {
    public static boolean logEnable = true;
    public static DKLogCallback gLogCallback = new DKLogCallback(){

        @Override
        public void onReceiveLogI(String tag, String msg) {
            super.onReceiveLogI(tag, msg);
            Log.i((String)tag, (String)msg);
        }

        @Override
        public void onReceiveLogD(String tag, String msg) {
            super.onReceiveLogD(tag, msg);
            Log.d((String)tag, (String)msg);
        }

        @Override
        public void onReceiveLogE(String tag, String msg) {
            super.onReceiveLogE(tag, msg);
            Log.e((String)tag, (String)msg);
        }
    };

    public static void enableLog() {
        logEnable = true;
    }

    public static void disableLog() {
        logEnable = false;
    }

    public static void setLogCallback(DKLogCallback callback) {
        gLogCallback = callback;
    }

    public static void d(String tag, String s) {
        if (!logEnable) {
            return;
        }
        if (gLogCallback != null) {
            gLogCallback.onReceiveLogD(tag, s);
        }
    }

    public static void i(String tag, String s) {
        if (!logEnable) {
            return;
        }
        if (gLogCallback != null) {
            gLogCallback.onReceiveLogI(tag, s);
        }
    }

    public static void e(String tag, String s) {
        if (!logEnable) {
            return;
        }
        if (gLogCallback != null) {
            gLogCallback.onReceiveLogE(tag, s);
        }
    }

    public static void d(String tag, Object s) {
        DKLog.d(tag, s.toString());
    }

    public static void i(String tag, Object s) {
        DKLog.i(tag, s.toString());
    }

    public static void e(String tag, Object s) {
        DKLog.e(tag, s.toString());
    }

    public static void d(String tag, StackTraceElement[] elements) {
        for (StackTraceElement elem : elements) {
            DKLog.d(tag, elem);
        }
    }

    public static void i(String tag, StackTraceElement[] elements) {
        for (StackTraceElement elem : elements) {
            DKLog.i(tag, elem);
        }
    }

    public static void e(String tag, StackTraceElement[] elements) {
        for (StackTraceElement elem : elements) {
            DKLog.e(tag, elem);
        }
    }
}

