/*
 * Decompiled with CFR 0.152.
 */
package com.dk.uart;

import android.os.CountDownTimer;
import com.dk.log.DKLog;
import com.dk.uart.ComBean;
import com.dk.uart.SerialPort;
import com.dk.uartnfc.Tool.StringTool;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidParameterException;

public abstract class SerialHelper {
    private static final String TAG = "SerialHelper";
    private SerialPort mSerialPort;
    private OutputStream mOutputStream;
    private InputStream mInputStream;
    private ReadThread mReadThread;
    private SendThread mSendThread;
    private String sPort = "/dev/ttySAC2";
    private int iBaudRate = 9600;
    private boolean _isOpen = false;
    private byte[] _bLoopData = new byte[]{48};
    private int iDelay = 500;
    private static boolean timerOutFlag = false;
    private final CountDownTimer timer = new CountDownTimer(500L, 500L){

        public void onTick(long millisUntilFinished) {
        }

        public void onFinish() {
            timerOutFlag = true;
            SerialHelper.this.timer.cancel();
        }
    };

    public SerialHelper(String sPort, int iBaudRate) {
        this.sPort = sPort;
        this.iBaudRate = iBaudRate;
    }

    public SerialHelper() {
        this("/dev/ttySAC2", 115200);
    }

    public SerialHelper(String sPort) {
        this(sPort, 115200);
    }

    public SerialHelper(String sPort, String sBaudRate) {
        this(sPort, Integer.parseInt(sBaudRate));
    }

    public void open() throws SecurityException, IOException, InvalidParameterException {
        this.mSerialPort = new SerialPort(new File(this.sPort), this.iBaudRate, 0);
        this.mOutputStream = this.mSerialPort.getOutputStream();
        this.mInputStream = this.mSerialPort.getInputStream();
        this.mReadThread = new ReadThread();
        this.mReadThread.start();
        this._isOpen = true;
    }

    public void close() {
        if (this.mReadThread != null) {
            this.mReadThread.interrupt();
        }
        if (this.mSerialPort != null) {
            this.mSerialPort.close();
            this.mSerialPort = null;
        }
        this._isOpen = false;
    }

    public void send(byte[] bOutArray) {
        try {
            this.mOutputStream.write(bOutArray);
        }
        catch (IOException e) {
            DKLog.e(TAG, e.getMessage());
            DKLog.e(TAG, e.getStackTrace());
        }
    }

    public void sendHex(String sHex) {
        byte[] bOutArray = StringTool.hexStringToBytes(sHex);
        this.send(bOutArray);
    }

    public void sendTxt(String sTxt) {
        byte[] bOutArray = sTxt.getBytes();
        this.send(bOutArray);
    }

    public int getBaudRate() {
        return this.iBaudRate;
    }

    public boolean setBaudRate(int iBaud) {
        if (this._isOpen) {
            return false;
        }
        this.iBaudRate = iBaud;
        return true;
    }

    public boolean setBaudRate(String sBaud) {
        int iBaud = Integer.parseInt(sBaud);
        return this.setBaudRate(iBaud);
    }

    public String getPort() {
        return this.sPort;
    }

    public boolean setPort(String sPort) {
        if (this._isOpen) {
            return false;
        }
        this.sPort = sPort;
        return true;
    }

    public boolean isOpen() {
        return this._isOpen;
    }

    public byte[] getbLoopData() {
        return this._bLoopData;
    }

    public void setbLoopData(byte[] bLoopData) {
        this._bLoopData = bLoopData;
    }

    public void setTxtLoopData(String sTxt) {
        this._bLoopData = sTxt.getBytes();
    }

    public void setHexLoopData(String sHex) {
        this._bLoopData = StringTool.hexStringToBytes(sHex);
    }

    public int getiDelay() {
        return this.iDelay;
    }

    public void setiDelay(int iDelay) {
        this.iDelay = iDelay;
    }

    public void startSend() {
        if (this.mSendThread != null) {
            this.mSendThread.setResume();
        }
    }

    public void stopSend() {
        if (this.mSendThread != null) {
            this.mSendThread.setSuspendFlag();
        }
    }

    protected abstract void onDataReceived(ComBean var1);

    private class SendThread
    extends Thread {
        public boolean suspendFlag = true;

        private SendThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            super.run();
            while (!this.isInterrupted()) {
                SendThread sendThread = this;
                synchronized (sendThread) {
                    while (this.suspendFlag) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            DKLog.e(SerialHelper.TAG, e.getMessage());
                            DKLog.e(SerialHelper.TAG, e.getStackTrace());
                        }
                    }
                }
                SerialHelper.this.send(SerialHelper.this.getbLoopData());
            }
        }

        public void setSuspendFlag() {
            this.suspendFlag = true;
        }

        public synchronized void setResume() {
            this.suspendFlag = false;
            this.notify();
        }
    }

    private class ReadThread
    extends Thread {
        private ReadThread() {
        }

        @Override
        public void run() {
            super.run();
            byte[] temp = new byte[3000];
            while (!this.isInterrupted()) {
                try {
                    if (SerialHelper.this.mInputStream == null) {
                        return;
                    }
                    if (SerialHelper.this.mInputStream.available() <= 0) {
                        Thread.sleep(1L);
                        continue;
                    }
                    int len = SerialHelper.this.mInputStream.read(temp);
                    if (len <= 0) continue;
                    byte[] readBytes = new byte[len];
                    System.arraycopy(temp, 0, readBytes, 0, len);
                    ComBean ComRecData = new ComBean(SerialHelper.this.sPort, readBytes, len);
                    SerialHelper.this.onDataReceived(ComRecData);
                }
                catch (Throwable e) {
                    DKLog.e(SerialHelper.TAG, e.getMessage());
                    DKLog.e(SerialHelper.TAG, e.getStackTrace());
                    return;
                }
            }
        }
    }
}

