/*
 * Decompiled with CFR 0.152.
 */
package com.dk.uartnfc.Card;

import com.dk.uartnfc.DeviceManager.Command;
import com.dk.uartnfc.DeviceManager.DeviceManager;
import com.dk.uartnfc.Exception.CardNoResponseException;
import com.dk.uartnfc.Exception.DeviceNoResponseException;

public class Card {
    public static final int CAR_NO_RESPONSE_TIME_MS = 500;
    public DeviceManager deviceManager;
    public byte[] uid;
    public byte[] atr;

    public Card(DeviceManager deviceManager) {
        this.deviceManager = deviceManager;
    }

    public Card(DeviceManager deviceManager, byte[] uid, byte[] atr) {
        this.deviceManager = deviceManager;
        this.uid = uid;
        this.atr = atr;
    }

    public String uidToString() {
        if (this.uid == null || this.uid.length == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.uid.length; ++i) {
            stringBuffer.append(String.format("%02x", this.uid[i]));
        }
        return stringBuffer.toString();
    }

    public boolean close() throws CardNoResponseException {
        try {
            byte[] nfc_return_bytes = this.deviceManager.serialManager.sendWithReturn(Command.getCmdBytes((byte)24), 500);
            return Command.verify_ack(nfc_return_bytes);
        }
        catch (DeviceNoResponseException e) {
            throw new CardNoResponseException("\u65e0\u54cd\u5e94");
        }
    }
}

