/*
 * Decompiled with CFR 0.152.
 */
package com.dk.uartnfc.Card;

import com.dk.uartnfc.Card.Card;
import com.dk.uartnfc.DeviceManager.Command;
import com.dk.uartnfc.DeviceManager.DeviceManager;
import com.dk.uartnfc.Exception.CardNoResponseException;
import com.dk.uartnfc.Exception.DeviceNoResponseException;
import com.dk.uartnfc.UartManager.DKMessageDef;
import java.util.Arrays;

public class Mifare
extends Card {
    public static final byte MIFARE_KEY_TYPE_A = 10;
    public static final byte MIFARE_KEY_TYPE_B = 11;
    public static final byte[] MIFARE_DEFAULT_KEY = new byte[]{-1, -1, -1, -1, -1, -1};

    public Mifare(DeviceManager deviceManager) {
        super(deviceManager);
    }

    public Mifare(DeviceManager deviceManager, byte[] uid, byte[] atr) {
        super(deviceManager, uid, atr);
    }

    public boolean setKey(byte bKeyType, byte[] pKey) throws CardNoResponseException {
        if (bKeyType == 10) {
            try {
                byte[] rsp = this.deviceManager.serialManager.sendWithReturn(Command.getCmdBytes((byte)3, pKey), 500);
                if (!Command.verify_ack(rsp)) {
                    return false;
                }
                rsp = this.deviceManager.serialManager.sendWithReturn(Command.getCmdBytes((byte)12, new byte[]{10}), 500);
                return Command.verify_ack(rsp);
            }
            catch (DeviceNoResponseException e) {
                throw new CardNoResponseException("\u8bfb\u5361\u5931\u8d25\uff0c\u8bf7\u4e0d\u8981\u79fb\u52a8\u5361\u7247");
            }
        }
        try {
            byte[] rsp = this.deviceManager.serialManager.sendWithReturn(Command.getCmdBytes((byte)11, pKey), 500);
            if (!Command.verify_ack(rsp)) {
                return false;
            }
            rsp = this.deviceManager.serialManager.sendWithReturn(Command.getCmdBytes((byte)12, new byte[]{11}), 500);
            return Command.verify_ack(rsp);
        }
        catch (DeviceNoResponseException e) {
            throw new CardNoResponseException("\u8bfb\u5361\u5931\u8d25\uff0c\u8bf7\u4e0d\u8981\u79fb\u52a8\u5361\u7247");
        }
    }

    public byte[] read(int addr) throws CardNoResponseException {
        return this.read((byte)addr);
    }

    public byte[] read(byte addr) throws CardNoResponseException {
        try {
            byte[] rsp = this.deviceManager.serialManager.sendWithReturn(Command.getCmdBytes((byte)4, new byte[]{addr}), 500);
            DKMessageDef msg = Command.getRspMsg(rsp);
            if (msg.data == null || msg.data.length < 16 || msg.command != 4) {
                return null;
            }
            return Arrays.copyOfRange(msg.data, 1, msg.data.length);
        }
        catch (DeviceNoResponseException e) {
            throw new CardNoResponseException("\u8bfb\u5361\u5931\u8d25\uff0c\u8bf7\u4e0d\u8981\u79fb\u52a8\u5361\u7247");
        }
    }

    public boolean write(int addr, byte[] writeData) throws CardNoResponseException {
        return this.write((byte)addr, writeData);
    }

    public boolean write(byte addr, byte[] writeData) throws CardNoResponseException {
        if (writeData.length != 16) {
            throw new CardNoResponseException("\u5199\u5165\u957f\u5ea6\u5fc5\u987b\u7b49\u4e8e16");
        }
        try {
            byte[] rsp = this.deviceManager.serialManager.sendWithReturn(Command.getCmdBytes((byte)5, addr, writeData), 500);
            return Command.verify_ack(rsp);
        }
        catch (DeviceNoResponseException e) {
            throw new CardNoResponseException("\u8bfb\u5361\u5931\u8d25\uff0c\u8bf7\u4e0d\u8981\u79fb\u52a8\u5361\u7247");
        }
    }
}

