/*
 * Decompiled with CFR 0.152.
 */
package com.dk.uartnfc.Card;

import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import com.dk.log.DKLog;
import com.dk.uartnfc.Card.Ultralight;
import com.dk.uartnfc.DeviceManager.DeviceManager;
import com.dk.uartnfc.Exception.CardNoResponseException;
import com.dk.uartnfc.Tool.StringTool;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Locale;

public class Ntag21x
extends Ultralight {
    private static final String TAG = "Ntag21x";
    public static final byte TYPE_NTAG213 = 15;
    public static final byte TYPE_NTAG215 = 17;
    public static final byte TYPE_NTAG216 = 19;
    public static final int SIZE_NTAG213 = 144;
    public static final int SIZE_NTAG215 = 504;
    public static final int SIZE_NTAG216 = 888;
    public static final String ERR_MEMORY_OUT = "Data is too long for this tag!";
    public static final String ERR_WRITE_FAIL = "Write data fail!";
    public static final String ERR_NO_ERROR = "No error";
    public static final String NDEF_TYPE = "text/plain";
    public int size = 0;
    public onReceiveScheduleListener mOnReceiveReadScheduleListener;
    public onReceiveScheduleListener mOnReceiveWriteScheduleListener;
    public onReceiveScheduleListener mOnReceiveNdefWriteScheduleListener;
    public onReceiveScheduleListener mOnReceiveNdefReadScheduleListener;

    public Ntag21x(DeviceManager deviceManager) {
        super(deviceManager);
    }

    public Ntag21x(DeviceManager deviceManager, byte[] uid, byte[] atr) {
        super(deviceManager, uid, atr);
    }

    public boolean longWrite(byte startAddress, byte[] writeBytes) throws CardNoResponseException {
        boolean isSuc;
        byte startAddressTemp = startAddress;
        byte[] returnBytes = this.read((byte)0);
        switch (returnBytes[14]) {
            case 18: {
                this.size = 144;
                break;
            }
            case 62: {
                this.size = 504;
                break;
            }
            case 109: 
            case 111: {
                this.size = 888;
                break;
            }
            default: {
                this.size = 144;
            }
        }
        if (writeBytes.length + (startAddressTemp & 0xFF) * 4 > this.size + 16) {
            throw new CardNoResponseException(ERR_MEMORY_OUT);
        }
        int currentWriteAddress = startAddress & 0xFF;
        byte[] writeByteTemp = new byte[192];
        int i = 0;
        i = 0;
        while (i + 48 <= writeBytes.length / 4) {
            System.arraycopy(writeBytes, i * 4, writeByteTemp, 0, 192);
            isSuc = this.longWriteSingle((byte)(currentWriteAddress & 0xFF), writeByteTemp);
            if (!isSuc) {
                return false;
            }
            currentWriteAddress += 48;
            i += 48;
        }
        if (writeBytes.length % 192 > 0) {
            writeByteTemp = new byte[writeBytes.length % 192];
            System.arraycopy(writeBytes, i * 4, writeByteTemp, 0, writeBytes.length % 192);
            isSuc = this.longWriteSingle((byte)(currentWriteAddress & 0xFF), writeByteTemp);
            if (!isSuc) {
                return false;
            }
        }
        return true;
    }

    public boolean longWriteWithScheduleCallback(byte startAddress, byte[] writeBytes, onReceiveScheduleListener listener) throws CardNoResponseException {
        boolean isSuc;
        this.mOnReceiveWriteScheduleListener = listener;
        byte startAddressTemp = startAddress;
        byte[] returnBytes = this.read((byte)0);
        switch (returnBytes[14]) {
            case 18: {
                this.size = 144;
                break;
            }
            case 62: {
                this.size = 504;
                break;
            }
            case 109: 
            case 111: {
                this.size = 888;
                break;
            }
            default: {
                this.size = 144;
            }
        }
        if (writeBytes.length + (startAddressTemp & 0xFF) * 4 > this.size + 16) {
            throw new CardNoResponseException(ERR_MEMORY_OUT);
        }
        int currentWriteAddress = startAddress & 0xFF;
        byte[] writeByteTemp = new byte[192];
        int i = 0;
        i = 0;
        while (i + 48 <= writeBytes.length / 4) {
            System.arraycopy(writeBytes, i * 4, writeByteTemp, 0, 192);
            isSuc = this.longWriteSingle((byte)(currentWriteAddress & 0xFF), writeByteTemp);
            if (!isSuc) {
                return false;
            }
            if (i != 0 && this.mOnReceiveWriteScheduleListener != null) {
                this.mOnReceiveWriteScheduleListener.onReceiveSchedule(i * 400 / writeBytes.length);
            }
            currentWriteAddress += 48;
            i += 48;
        }
        if (writeBytes.length % 192 > 0) {
            writeByteTemp = new byte[writeBytes.length % 192];
            System.arraycopy(writeBytes, i * 4, writeByteTemp, 0, writeBytes.length % 192);
            isSuc = this.longWriteSingle((byte)(currentWriteAddress & 0xFF), writeByteTemp);
            if (!isSuc) {
                return false;
            }
        }
        if (this.mOnReceiveWriteScheduleListener != null) {
            this.mOnReceiveWriteScheduleListener.onReceiveSchedule(100);
        }
        return true;
    }

    public byte[] longRead(byte startAddress, byte endAddress) throws CardNoResponseException {
        int surplusBlock;
        byte[] returnBytes;
        if ((startAddress & 0xFF) > (endAddress & 0xFF)) {
            throw new CardNoResponseException("Start Address must be smaller than end Address");
        }
        byte[] readDataBytes = new byte[((endAddress & 0xFF) - (startAddress & 0xFF) + 1) * 4];
        int readDataLen = 0;
        int currentStartAddress = startAddress & 0xFF;
        int currentEndAddress = currentStartAddress + 48 - 1;
        if ((endAddress & 0xFF) - (startAddress & 0xFF) + 1 >= 48) {
            while ((currentEndAddress & 0xFF) <= (endAddress & 0xFF)) {
                returnBytes = this.longReadSingle((byte)currentStartAddress, 48);
                System.arraycopy(returnBytes, 0, readDataBytes, readDataLen, returnBytes.length);
                readDataLen += 192;
                currentStartAddress = (currentEndAddress & 0xFF) + 1;
                currentEndAddress += 48;
            }
        }
        if ((surplusBlock = ((endAddress & 0xFF) - (startAddress & 0xFF) + 1) % 48) != 0) {
            returnBytes = this.longReadSingle((byte)(currentStartAddress & 0xFF), surplusBlock);
            System.arraycopy(returnBytes, 0, readDataBytes, readDataLen, surplusBlock * 4);
        }
        return readDataBytes;
    }

    public byte[] longReadWithScheduleCallback(byte startAddress, byte endAddress, onReceiveScheduleListener listener) throws CardNoResponseException {
        int surplusBlock;
        byte[] returnBytes;
        this.mOnReceiveReadScheduleListener = listener;
        if ((startAddress & 0xFF) > (endAddress & 0xFF)) {
            throw new CardNoResponseException("Start Address must be smaller than end Address");
        }
        byte[] readDataBytes = new byte[((endAddress & 0xFF) - (startAddress & 0xFF) + 1) * 4];
        int readDataLen = 0;
        int currentStartAddress = startAddress & 0xFF;
        int currentEndAddress = currentStartAddress + 48 - 1;
        if ((endAddress & 0xFF) - (startAddress & 0xFF) + 1 >= 48) {
            while ((currentEndAddress & 0xFF) <= (endAddress & 0xFF)) {
                returnBytes = this.longReadSingle((byte)currentStartAddress, 48);
                System.arraycopy(returnBytes, 0, readDataBytes, readDataLen, returnBytes.length);
                currentStartAddress = (currentEndAddress & 0xFF) + 1;
                currentEndAddress += 48;
                if (this.mOnReceiveReadScheduleListener == null || (readDataLen += 192) == 0 || readDataLen >= readDataBytes.length) continue;
                this.mOnReceiveReadScheduleListener.onReceiveSchedule(readDataLen * 100 / readDataBytes.length);
            }
        }
        if ((surplusBlock = ((endAddress & 0xFF) - (startAddress & 0xFF) + 1) % 48) != 0) {
            returnBytes = this.longReadSingle((byte)(currentStartAddress & 0xFF), surplusBlock);
            System.arraycopy(returnBytes, 0, readDataBytes, readDataLen, surplusBlock * 4);
        }
        if (this.mOnReceiveReadScheduleListener != null) {
            this.mOnReceiveReadScheduleListener.onReceiveSchedule(100);
        }
        return readDataBytes;
    }

    public boolean NdefTextWrite(String text) throws CardNoResponseException {
        byte[] rececrdByte = this.createTextRecord(text).getPayload();
        DKLog.d(TAG, StringTool.byteHexToSting(rececrdByte));
        NdefMessage ndefMessage = new NdefMessage(new NdefRecord[]{this.createTextRecord(text)});
        byte[] NDEFTextByte = ndefMessage.toByteArray();
        byte[] NDEFHandleByte = NDEFTextByte.length >= 255 ? new byte[]{3, -1, (byte)(NDEFTextByte.length >> 8 & 0xFF), (byte)(NDEFTextByte.length & 0xFF)} : new byte[]{3, (byte)NDEFTextByte.length};
        byte[] writeBytes = new byte[NDEFHandleByte.length + NDEFTextByte.length + 1];
        int index = 0;
        System.arraycopy(NDEFHandleByte, 0, writeBytes, index, NDEFHandleByte.length);
        System.arraycopy(NDEFTextByte, 0, writeBytes, index += NDEFHandleByte.length, NDEFTextByte.length);
        writeBytes[writeBytes.length - 1] = -2;
        return this.longWrite((byte)4, writeBytes);
    }

    public boolean NdefTextWriteWithScheduleCallback(String text, onReceiveScheduleListener listener) throws CardNoResponseException {
        this.mOnReceiveNdefWriteScheduleListener = listener;
        byte[] rececrdByte = this.createTextRecord(text).getPayload();
        DKLog.d(TAG, StringTool.byteHexToSting(rececrdByte));
        NdefMessage ndefMessage = new NdefMessage(new NdefRecord[]{this.createTextRecord(text)});
        byte[] NDEFTextByte = ndefMessage.toByteArray();
        byte[] NDEFHandleByte = NDEFTextByte.length >= 255 ? new byte[]{3, -1, (byte)(NDEFTextByte.length >> 8 & 0xFF), (byte)(NDEFTextByte.length & 0xFF)} : new byte[]{3, (byte)NDEFTextByte.length};
        byte[] writeBytes = new byte[NDEFHandleByte.length + NDEFTextByte.length + 1];
        int index = 0;
        System.arraycopy(NDEFHandleByte, 0, writeBytes, index, NDEFHandleByte.length);
        System.arraycopy(NDEFTextByte, 0, writeBytes, index += NDEFHandleByte.length, NDEFTextByte.length);
        writeBytes[writeBytes.length - 1] = -2;
        return this.longWriteWithScheduleCallback((byte)4, writeBytes, new onReceiveScheduleListener(){

            @Override
            public void onReceiveSchedule(int rate) {
                if (Ntag21x.this.mOnReceiveNdefWriteScheduleListener != null) {
                    Ntag21x.this.mOnReceiveNdefWriteScheduleListener.onReceiveSchedule(rate);
                }
            }
        });
    }

    public String NdefTextRead() throws CardNoResponseException {
        byte[] returnBytes = this.read((byte)4);
        if (returnBytes == null || returnBytes.length != 16) {
            throw new CardNoResponseException("Read card fail");
        }
        if (returnBytes[0] == 3 || returnBytes[1] == 3) {
            int i;
            byte[] imageBytes = NDEF_TYPE.getBytes();
            boolean searchFlag = false;
            for (i = 0; i < 15; ++i) {
                searchFlag = true;
                for (int j = i; j < 16 && j - i < 10; ++j) {
                    if (returnBytes[j] == imageBytes[j - i]) continue;
                    searchFlag = false;
                    break;
                }
                if (searchFlag) break;
            }
            if (searchFlag) {
                int imageStartAddr = i;
                int textLen = imageStartAddr > 4 && returnBytes[i - 3] == 0 && returnBytes[i - 4] == 0 ? (returnBytes[i - 1] & 0xFF) + ((returnBytes[i - 2] & 0xFF) << 8) : returnBytes[i - 1] & 0xFF;
                int recordLen = textLen + i + 10;
                byte recordEndAddress = (byte)((recordLen + 3) / 4 + 4);
                returnBytes = this.longRead((byte)4, recordEndAddress);
                if (returnBytes == null || returnBytes.length < recordLen || returnBytes.length < textLen + imageStartAddr + 10) {
                    throw new CardNoResponseException("Read card fail");
                }
                try {
                    return new String(returnBytes, imageStartAddr + 10, textLen, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new CardNoResponseException("No NDEF text payload!");
                }
            }
            throw new CardNoResponseException("No NDEF text payload!");
        }
        throw new CardNoResponseException("No NDEF text payload!");
    }

    public String NdefTextReadWithScheduleCallback(onReceiveScheduleListener listener) throws CardNoResponseException {
        this.mOnReceiveNdefReadScheduleListener = listener;
        byte[] returnBytes = this.read((byte)4);
        if (returnBytes == null || returnBytes.length != 16) {
            throw new CardNoResponseException("Read card fail");
        }
        if (returnBytes[0] == 3 || returnBytes[1] == 3) {
            int i;
            byte[] imageBytes = NDEF_TYPE.getBytes();
            boolean searchFlag = false;
            for (i = 0; i < 15; ++i) {
                searchFlag = true;
                for (int j = i; j < 16 && j - i < 10; ++j) {
                    if (returnBytes[j] == imageBytes[j - i]) continue;
                    searchFlag = false;
                    break;
                }
                if (searchFlag) break;
            }
            if (searchFlag) {
                int imageStartAddr = i;
                int textLen = imageStartAddr > 4 && returnBytes[i - 3] == 0 && returnBytes[i - 4] == 0 ? (returnBytes[i - 1] & 0xFF) + ((returnBytes[i - 2] & 0xFF) << 8) : returnBytes[i - 1] & 0xFF;
                int recordLen = textLen + i + 10;
                byte recordEndAddress = (byte)((recordLen + 3) / 4 + 4);
                returnBytes = this.longReadWithScheduleCallback((byte)4, recordEndAddress, new onReceiveScheduleListener(){

                    @Override
                    public void onReceiveSchedule(int rate) {
                        if (Ntag21x.this.mOnReceiveNdefReadScheduleListener != null) {
                            Ntag21x.this.mOnReceiveNdefReadScheduleListener.onReceiveSchedule(rate);
                        }
                    }
                });
                if (returnBytes == null || returnBytes.length < recordLen || returnBytes.length < textLen + imageStartAddr + 10) {
                    throw new CardNoResponseException("Read card fail");
                }
                try {
                    return new String(returnBytes, imageStartAddr + 10, textLen, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new CardNoResponseException("No NDEF text payload!");
                }
            }
            throw new CardNoResponseException("No NDEF text payload!");
        }
        throw new CardNoResponseException("No NDEF text payload!");
    }

    private NdefRecord createTextRecord(String text) {
        byte[] langBytes = Locale.CHINA.getLanguage().getBytes(Charset.forName("US-ASCII"));
        Charset utfEncoding = Charset.forName("UTF-8");
        byte[] textBytes = text.getBytes(utfEncoding);
        int utfBit = 0;
        char status = (char)(utfBit + langBytes.length);
        byte[] data = new byte[1 + langBytes.length + textBytes.length];
        data[0] = (byte)status;
        System.arraycopy(langBytes, 0, data, 1, langBytes.length);
        System.arraycopy(textBytes, 0, data, 1 + langBytes.length, textBytes.length);
        NdefRecord record = new NdefRecord(2, NDEF_TYPE.getBytes(), new byte[0], text.getBytes(utfEncoding));
        return record;
    }

    public static interface onReceiveScheduleListener {
        public void onReceiveSchedule(int var1);
    }
}

