/*
 * Decompiled with CFR 0.152.
 */
package com.dk.uartnfc.DKCloudID;

import com.dk.log.DKLog;
import com.dk.uartnfc.Card.Iso14443BIdCard;
import com.dk.uartnfc.Card.SamVIdCard;
import com.dk.uartnfc.DKCloudID.DKCloudID;
import com.dk.uartnfc.DKCloudID.IDCardData;
import com.dk.uartnfc.DeviceManager.Command;
import com.dk.uartnfc.Exception.CardNoResponseException;
import com.dk.uartnfc.Exception.DKCloudIDException;
import com.dk.uartnfc.Exception.DeviceNoResponseException;
import com.dk.uartnfc.Tool.StringTool;

public class IDCard {
    private static final int DEFAULT_RETRY_TIME = 3;
    private static final String TAG = "IDCard";
    SamVIdCard mSamVIdCard = null;
    DKCloudID dkCloudID = null;
    private onReceiveScheduleListener mOnReceiveScheduleListener;
    byte[] initData;
    private static IDCard instance = new IDCard();

    private IDCard() {
    }

    public static IDCard getInstance() {
        return instance;
    }

    public static IDCard getInstance(SamVIdCard samVIdCard) {
        IDCard.instance.mSamVIdCard = samVIdCard;
        return instance;
    }

    public IDCardData getIDCardData(int retryTime) throws DKCloudIDException, CardNoResponseException {
        return this.getIDCardData(retryTime, null);
    }

    public IDCardData getIDCardData(int retryTime, onReceiveScheduleListener listener) throws DKCloudIDException, CardNoResponseException {
        DKCloudIDException errMsg = null;
        int cnt = 0;
        do {
            try {
                return this.getIDCardData(this.mSamVIdCard, listener);
            }
            catch (DKCloudIDException e) {
                DKLog.e(TAG, e.getMessage());
                DKLog.e(TAG, e.getStackTrace());
                errMsg = e;
            }
            catch (CardNoResponseException e) {
                try {
                    this.mSamVIdCard.serialManager.sendWithReturn(Command.getCmdBytes((byte)24));
                }
                catch (DeviceNoResponseException deviceNoResponseException) {
                    deviceNoResponseException.printStackTrace();
                }
                throw e;
            }
        } while (cnt++ < retryTime);
        throw errMsg;
    }

    public IDCardData getIDCardData(Iso14443BIdCard iso14443BIdCard, int retryTime) throws DKCloudIDException, CardNoResponseException {
        return this.getIDCardData(iso14443BIdCard, retryTime, null);
    }

    public IDCardData getIDCardData(Iso14443BIdCard iso14443BIdCard, int retryTime, onReceiveScheduleListener listener) throws DKCloudIDException, CardNoResponseException {
        DKCloudIDException errMsg = null;
        int cnt = 0;
        do {
            try {
                return this.getIDCardData(iso14443BIdCard, listener);
            }
            catch (DKCloudIDException e) {
                DKLog.e(TAG, e.getMessage());
                DKLog.e(TAG, e.getStackTrace());
                errMsg = e;
            }
            catch (CardNoResponseException e) {
                try {
                    iso14443BIdCard.close();
                }
                catch (CardNoResponseException e1) {
                    e1.printStackTrace();
                }
                throw e;
            }
        } while (cnt++ < retryTime);
        throw errMsg;
    }

    public IDCardData getIDCardData() throws DKCloudIDException, CardNoResponseException {
        return this.getIDCardData(3, null);
    }

    public IDCardData getIDCardData(onReceiveScheduleListener listener) throws DKCloudIDException, CardNoResponseException {
        return this.getIDCardData(3, listener);
    }

    public IDCardData getIDCardData(Iso14443BIdCard iso14443BIdCard) throws DKCloudIDException, CardNoResponseException {
        return this.getIDCardData(iso14443BIdCard, null);
    }

    public IDCardData getIDCardData(SamVIdCard samVIdCard) throws DKCloudIDException, CardNoResponseException {
        return this.getIDCardData(samVIdCard, null);
    }

    public IDCardData getIDCardData(Iso14443BIdCard iso14443BIdCard, onReceiveScheduleListener listener) throws DKCloudIDException, CardNoResponseException {
        this.mSamVIdCard = new SamVIdCard(iso14443BIdCard.deviceManager, iso14443BIdCard.getSamVInitData());
        return this.getIDCardData(this.mSamVIdCard, listener);
    }

    public synchronized IDCardData getIDCardData(SamVIdCard samVIdCard, onReceiveScheduleListener listener) throws DKCloudIDException, CardNoResponseException {
        if (samVIdCard == null) {
            throw new DKCloudIDException("\u53c2\u6570\u201cSamVIdCard\u201d\u4e3anull");
        }
        int sendByteLen = 0;
        int rate = 5;
        this.mOnReceiveScheduleListener = listener;
        byte[] msgReturnBytes = samVIdCard.getSamVInitData();
        this.initData = msgReturnBytes;
        this.dkCloudID = new DKCloudID();
        if (!this.dkCloudID.isConnected()) {
            throw new DKCloudIDException("\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25");
        }
        DKLog.d(TAG, "\u5411\u670d\u52a1\u5668\u53d1\u9001\u6570\u636e\uff1a" + StringTool.byteHexToSting(msgReturnBytes));
        sendByteLen += msgReturnBytes.length;
        byte[] cloudReturnByte = this.dkCloudID.dkCloudTcpDataExchange(msgReturnBytes);
        DKLog.d(TAG, "\u63a5\u6536\u5230\u670d\u52a1\u5668\u6570\u636e\uff1a" + StringTool.byteHexToSting(cloudReturnByte));
        DKLog.d(TAG, "\u6b63\u5728\u89e3\u6790:1%");
        int schedule = 1;
        if (cloudReturnByte != null && cloudReturnByte.length >= 2 && (cloudReturnByte[0] == 3 || cloudReturnByte[0] == 4) && this.mOnReceiveScheduleListener != null) {
            this.mOnReceiveScheduleListener.onReceiveSchedule(schedule);
        }
        while (true) {
            if (cloudReturnByte == null || cloudReturnByte.length < 2 || cloudReturnByte[0] != 3 && cloudReturnByte[0] != 4) {
                if (cloudReturnByte == null || cloudReturnByte.length == 0) {
                    throw new DKCloudIDException("\u670d\u52a1\u5668\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
                }
                if (cloudReturnByte[0] == 5) {
                    throw new DKCloudIDException("\u89e3\u6790\u5931\u8d25, \u8bf7\u91cd\u65b0\u8bfb\u5361");
                }
                if (cloudReturnByte[0] == 6) {
                    throw new DKCloudIDException("\u8be5\u8bbe\u5907\u672a\u6388\u6743, \u8bf7\u63d0\u4f9bIMEI\u8054\u7cfb\u5546\u5bb6\u83b7\u53d6\u6388\u6743\u5546\u5bb6\r\n");
                }
                if (cloudReturnByte[0] == 7) {
                    throw new DKCloudIDException("\u8be5\u8bbe\u5907\u5df2\u88ab\u7981\u7528, \u8bf7\u8054\u7cfb\u5546\u5bb6");
                }
                if (cloudReturnByte[0] == 8) {
                    throw new DKCloudIDException("\u8be5\u8d26\u53f7\u5df2\u88ab\u7981\u7528, \u8bf7\u8054\u7cfb\u5546\u5bb6");
                }
                if (cloudReturnByte[0] == 9) {
                    throw new DKCloudIDException("\u4f59\u989d\u4e0d\u8db3, \u8bf7\u8054\u7cfb\u5546\u5bb6\u5145\u503c\r\n");
                }
                throw new DKCloudIDException("\u672a\u77e5\u9519\u8bef");
            }
            if (cloudReturnByte[0] == 4 && cloudReturnByte.length > 300) {
                byte[] decrypted = new byte[cloudReturnByte.length - 3];
                System.arraycopy(cloudReturnByte, 3, decrypted, 0, decrypted.length);
                if (schedule != rate && this.mOnReceiveScheduleListener != null) {
                    this.mOnReceiveScheduleListener.onReceiveSchedule(100);
                }
                IDCardData idCardData = new IDCardData(decrypted);
                DKLog.d(TAG, "\u89e3\u6790\u6210\u529f\uff1a" + idCardData.toString());
                return idCardData;
            }
            msgReturnBytes = samVIdCard.transceive(cloudReturnByte);
            if (msgReturnBytes.length == 2) {
                throw new CardNoResponseException("\u89e3\u6790\u51fa\u9519\uff1a" + String.format("%d", (msgReturnBytes[0] & 0xFF) << 8 | msgReturnBytes[1] & 0xFF));
            }
            if (msgReturnBytes.length > 0 && msgReturnBytes[0] == -77 && ((sendByteLen += msgReturnBytes.length) == 1590 || sendByteLen == 1617)) {
                rate = 4;
            }
            DKLog.d(TAG, String.format("\u6b63\u5728\u89e3\u6790%%%d ", ++schedule * 100 / rate) + sendByteLen);
            if (this.mOnReceiveScheduleListener != null) {
                this.mOnReceiveScheduleListener.onReceiveSchedule(schedule * 100 / rate);
            }
            DKLog.d(TAG, "\u5411\u670d\u52a1\u5668\u53d1\u9001\u6570\u636e\uff1a" + StringTool.byteHexToSting(msgReturnBytes));
            cloudReturnByte = this.dkCloudID.dkCloudTcpDataExchange(msgReturnBytes);
            DKLog.d(TAG, "\u63a5\u6536\u5230\u670d\u52a1\u5668\u6570\u636e\uff1a" + StringTool.byteHexToSting(cloudReturnByte));
        }
    }

    public static interface onReceiveScheduleListener {
        public void onReceiveSchedule(int var1);
    }
}

