/*
 * Decompiled with CFR 0.152.
 */
package com.dk.uartnfc.DKCloudID;

import android.graphics.Bitmap;
import com.dk.log.DKLog;
import com.zkteco.android.IDReader.IDPhotoHelper;
import com.zkteco.android.IDReader.WLTService;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class IDCardData {
    private static final String TAG = "IDCardData";
    public static final int ID_TYPE_CN = 1;
    public static final int ID_TYPE_GAT = 2;
    public static final int ID_TYPE_FOREIGN = 3;
    public String Name = null;
    public String Sex = null;
    public String Nation = null;
    public String Born = null;
    public String Address = null;
    public String IDCardNo = null;
    public String GrantDept = null;
    public String UserLifeBegin = null;
    public String UserLifeEnd = null;
    public String passport = null;
    public String issueNumber = null;
    public Bitmap PhotoBmp = null;
    public byte[] fingerprintBytes = null;
    public int type = 0;
    private static Lock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDCardData(byte[] idCardBytes) {
        IDCardData iDCardData = this;
        synchronized (iDCardData) {
            if (idCardBytes == null || idCardBytes.length < 1295) {
                return;
            }
            if (idCardBytes[0] == -86 && idCardBytes[1] == -86 && idCardBytes[2] == -86 && idCardBytes[3] == -106 && idCardBytes[4] == 105 && this.bcc(idCardBytes, 5, idCardBytes.length - 2) == idCardBytes[idCardBytes.length - 1]) {
                int wordMsgBytesLen = (idCardBytes[10] & 0xFF) << 8 | idCardBytes[11] & 0xFF;
                int photoMsgBytesLen = (idCardBytes[12] & 0xFF) << 8 | idCardBytes[13] & 0xFF;
                byte[] wordMsgBytes = new byte[wordMsgBytesLen];
                byte[] photoMsgBytes = new byte[photoMsgBytesLen];
                if (idCardBytes.length == 1295) {
                    System.arraycopy(idCardBytes, 14, wordMsgBytes, 0, wordMsgBytesLen);
                    System.arraycopy(idCardBytes, 14 + wordMsgBytesLen, photoMsgBytes, 0, photoMsgBytesLen);
                } else {
                    int fingerprintBytesLen = (idCardBytes[14] & 0xFF) << 8 | idCardBytes[15] & 0xFF;
                    this.fingerprintBytes = new byte[fingerprintBytesLen];
                    System.arraycopy(idCardBytes, 16, wordMsgBytes, 0, wordMsgBytesLen);
                    System.arraycopy(idCardBytes, 16 + wordMsgBytesLen, photoMsgBytes, 0, photoMsgBytesLen);
                    System.arraycopy(idCardBytes, 16 + wordMsgBytesLen + photoMsgBytesLen, this.fingerprintBytes, 0, fingerprintBytesLen);
                }
                this.type = wordMsgBytes[248] == 74 ? 2 : (wordMsgBytes[248] == 73 ? 3 : 1);
                int index = 0;
                byte[] bytes = new byte[30];
                System.arraycopy(wordMsgBytes, index, bytes, 0, bytes.length);
                index += bytes.length;
                try {
                    this.Name = new String(bytes, "UTF_16LE");
                }
                catch (UnsupportedEncodingException e) {
                    DKLog.e(TAG, e.getMessage());
                    DKLog.e(TAG, e.getStackTrace());
                }
                this.Sex = wordMsgBytes[30] == 49 ? "\u7537" : "\u5973";
                index += 2;
                if (this.type == 1) {
                    bytes = new byte[4];
                    System.arraycopy(wordMsgBytes, index, bytes, 0, bytes.length);
                    try {
                        String str = new String(bytes, "UTF_16LE");
                        if (str.length() == 2) {
                            int nationCode = Integer.valueOf(str, 10);
                            this.Nation = this.getNation(nationCode);
                        }
                    }
                    catch (Exception e) {
                        DKLog.e(TAG, e.getMessage());
                        DKLog.e(TAG, e.getStackTrace());
                    }
                }
                bytes = new byte[16];
                System.arraycopy(wordMsgBytes, index += 4, bytes, 0, bytes.length);
                index += bytes.length;
                try {
                    this.Born = new String(bytes, "UTF_16LE");
                }
                catch (UnsupportedEncodingException e) {
                    DKLog.e(TAG, e.getMessage());
                    DKLog.e(TAG, e.getStackTrace());
                }
                bytes = new byte[70];
                System.arraycopy(wordMsgBytes, index, bytes, 0, bytes.length);
                index += bytes.length;
                try {
                    this.Address = new String(bytes, "UTF_16LE");
                }
                catch (UnsupportedEncodingException e) {
                    DKLog.e(TAG, e.getMessage());
                    DKLog.e(TAG, e.getStackTrace());
                }
                bytes = new byte[36];
                System.arraycopy(wordMsgBytes, index, bytes, 0, bytes.length);
                index += bytes.length;
                try {
                    this.IDCardNo = new String(bytes, "UTF_16LE");
                }
                catch (UnsupportedEncodingException e) {
                    DKLog.e(TAG, e.getMessage());
                    DKLog.e(TAG, e.getStackTrace());
                }
                bytes = new byte[30];
                System.arraycopy(wordMsgBytes, index, bytes, 0, bytes.length);
                index += bytes.length;
                try {
                    this.GrantDept = new String(bytes, "UTF_16LE");
                }
                catch (UnsupportedEncodingException e) {
                    DKLog.e(TAG, e.getMessage());
                    DKLog.e(TAG, e.getStackTrace());
                }
                bytes = new byte[16];
                System.arraycopy(wordMsgBytes, index, bytes, 0, bytes.length);
                index += bytes.length;
                try {
                    this.UserLifeBegin = new String(bytes, "UTF_16LE");
                }
                catch (UnsupportedEncodingException e) {
                    DKLog.e(TAG, e.getMessage());
                    DKLog.e(TAG, e.getStackTrace());
                }
                bytes = new byte[16];
                System.arraycopy(wordMsgBytes, index, bytes, 0, bytes.length);
                index += bytes.length;
                try {
                    this.UserLifeEnd = new String(bytes, "UTF_16LE");
                }
                catch (UnsupportedEncodingException e) {
                    DKLog.e(TAG, e.getMessage());
                    DKLog.e(TAG, e.getStackTrace());
                }
                if (this.type == 2) {
                    bytes = new byte[18];
                    System.arraycopy(wordMsgBytes, index, bytes, 0, bytes.length);
                    index += bytes.length;
                    try {
                        this.passport = new String(bytes, "UTF_16LE");
                    }
                    catch (UnsupportedEncodingException e) {
                        DKLog.e(TAG, e.getMessage());
                        DKLog.e(TAG, e.getStackTrace());
                    }
                    bytes = new byte[4];
                    System.arraycopy(wordMsgBytes, index, bytes, 0, bytes.length);
                    index += bytes.length;
                    try {
                        this.issueNumber = new String(bytes, "UTF_16LE");
                    }
                    catch (UnsupportedEncodingException e) {
                        DKLog.e(TAG, e.getMessage());
                        DKLog.e(TAG, e.getStackTrace());
                    }
                }
                lock.lock();
                if (photoMsgBytesLen > 0) {
                    try {
                        byte[] buf = new byte[WLTService.imgLength];
                        if (1 == WLTService.wlt2Bmp(photoMsgBytes, buf)) {
                            this.PhotoBmp = IDPhotoHelper.Bgr2Bitmap(buf);
                        }
                    }
                    catch (Exception e) {
                        DKLog.e(TAG, e.getMessage());
                        DKLog.e(TAG, e.getStackTrace());
                    }
                }
                lock.unlock();
            }
        }
    }

    private byte bcc(byte[] bytes, int startIndex, int endIndex) {
        byte bcc_sum = 0;
        for (int i = startIndex; i <= endIndex; ++i) {
            bcc_sum = (byte)(bytes[i] & 0xFF ^ bcc_sum & 0xFF);
        }
        return bcc_sum;
    }

    String getNation(int code) {
        switch (code) {
            case 1: {
                return "\u6c49";
            }
            case 2: {
                return "\u8499\u53e4";
            }
            case 3: {
                return "\u56de";
            }
            case 4: {
                return "\u85cf";
            }
            case 5: {
                return "\u7ef4\u543e\u5c14";
            }
            case 6: {
                return "\u82d7";
            }
            case 7: {
                return "\u5f5d";
            }
            case 8: {
                return "\u58ee";
            }
            case 9: {
                return "\u5e03\u4f9d";
            }
            case 10: {
                return "\u671d\u9c9c";
            }
            case 11: {
                return "\u6ee1";
            }
            case 12: {
                return "\u4f97";
            }
            case 13: {
                return "\u7476";
            }
            case 14: {
                return "\u767d";
            }
            case 15: {
                return "\u571f\u5bb6";
            }
            case 16: {
                return "\u54c8\u5c3c";
            }
            case 17: {
                return "\u54c8\u8428\u514b";
            }
            case 18: {
                return "\u50a3";
            }
            case 19: {
                return "\u9ece";
            }
            case 20: {
                return "\u5088\u50f3";
            }
            case 21: {
                return "\u4f64";
            }
            case 22: {
                return "\u7572";
            }
            case 23: {
                return "\u9ad8\u5c71";
            }
            case 24: {
                return "\u62c9\u795c";
            }
            case 25: {
                return "\u6c34";
            }
            case 26: {
                return "\u4e1c\u4e61";
            }
            case 27: {
                return "\u7eb3\u897f";
            }
            case 28: {
                return "\u666f\u9887";
            }
            case 29: {
                return "\u67ef\u5c14\u514b\u5b5c";
            }
            case 30: {
                return "\u571f";
            }
            case 31: {
                return "\u8fbe\u65a1\u5c14";
            }
            case 32: {
                return "\u4eeb\u4f6c";
            }
            case 33: {
                return "\u7f8c";
            }
            case 34: {
                return "\u5e03\u6717";
            }
            case 35: {
                return "\u6492\u62c9";
            }
            case 36: {
                return "\u6bdb\u5357";
            }
            case 37: {
                return "\u4ee1\u4f6c";
            }
            case 38: {
                return "\u9521\u4f2f";
            }
            case 39: {
                return "\u963f\u660c";
            }
            case 40: {
                return "\u666e\u7c73";
            }
            case 41: {
                return "\u5854\u5409\u514b";
            }
            case 42: {
                return "\u6012";
            }
            case 43: {
                return "\u4e4c\u5b5c\u522b\u514b";
            }
            case 44: {
                return "\u4fc4\u7f57\u65af";
            }
            case 45: {
                return "\u9102\u6e29\u514b";
            }
            case 46: {
                return "\u5fb7\u6602";
            }
            case 47: {
                return "\u4fdd\u5b89";
            }
            case 48: {
                return "\u88d5\u56fa";
            }
            case 49: {
                return "\u4eac";
            }
            case 50: {
                return "\u5854\u5854\u5c14";
            }
            case 51: {
                return "\u72ec\u9f99";
            }
            case 52: {
                return "\u9102\u4f26\u6625";
            }
            case 53: {
                return "\u8d6b\u54f2";
            }
            case 54: {
                return "\u95e8\u5df4";
            }
            case 55: {
                return "\u73de\u5df4";
            }
            case 56: {
                return "\u57fa\u8bfa";
            }
            case 97: {
                return "\u5176\u4ed6";
            }
            case 98: {
                return "\u5916\u56fd\u8840\u7edf\u4e2d\u56fd\u7c4d\u4eba\u58eb";
            }
        }
        return "";
    }

    public String toString() {
        if (this.type == 2) {
            return "\r\n\u59d3        \u540d\uff1a" + this.Name + "\r\n\u6027        \u522b\uff1a" + this.Sex + "\r\n\u51fa\u751f\u65e5\u671f\uff1a" + this.Born + "\r\n\u4f4f        \u5740\uff1a" + this.Address + "\r\n\u8eab\u4efd \u8bc1\u53f7\uff1a" + this.IDCardNo + "\r\n\u7b7e\u53d1 \u673a\u5173\uff1a" + this.GrantDept + "\r\n\u6709  \u6548  \u671f\uff1a" + this.UserLifeBegin + "-" + this.UserLifeEnd + "\r\n\u901a\u884c \u8bc1\u53f7\uff1a" + this.passport + "\r\n\u7b7e\u53d1 \u6b21\u6570\uff1a" + this.issueNumber;
        }
        return "\r\n\u59d3        \u540d\uff1a" + this.Name + "\r\n\u6027        \u522b\uff1a" + this.Sex + "\r\n\u540d        \u65cf\uff1a" + this.Nation + "\r\n\u51fa\u751f\u65e5\u671f\uff1a" + this.Born + "\r\n\u4f4f        \u5740\uff1a" + this.Address + "\r\n\u8eab\u4efd \u8bc1\u53f7\uff1a" + this.IDCardNo + "\r\n\u7b7e\u53d1 \u673a\u5173\uff1a" + this.GrantDept + "\r\n\u6709  \u6548  \u671f\uff1a" + this.UserLifeBegin + "-" + this.UserLifeEnd;
    }
}

