/*
 * Decompiled with CFR 0.152.
 */
package com.dk.uartnfc.DeviceManager;

import com.dk.uartnfc.Exception.CardNoResponseException;
import com.dk.uartnfc.UartManager.DKMessageDef;
import java.util.Arrays;

public class Command {
    public static final String TAG = "Command";
    public static final byte FRAME_START_CODE = -86;
    public static final byte SAM_V_FRAME_START_CODE = -69;
    public static final byte GET_UID = 1;
    public static final byte GET_PICC_TYPE = 2;
    public static final byte M1_SAVE_KEY_A = 3;
    public static final byte M1_READ_BLOCK = 4;
    public static final byte M1_WRITE_BLOCK = 5;
    public static final byte M1_VALUE_INIT = 6;
    public static final byte M1_VALUE_ADD = 7;
    public static final byte M1_VALUE_SUB = 8;
    public static final byte UL_READ_BLOCK = 9;
    public static final byte UL_WRITE_BLOCK = 10;
    public static final byte M1_SAVE_KEY_B = 11;
    public static final byte M1_SET_KEY_TYPE = 12;
    public static final byte B_READ_BLOCK = 13;
    public static final byte B_WRITE_BLOCK = 14;
    public static final byte M1_READ_ALL = 15;
    public static final byte UL_READ_ALL = 16;
    public static final byte B_READ_ALL = 17;
    public static final byte EEROM_READ = 18;
    public static final byte EEROM_WRITE = 19;
    public static final byte B_ACTIVIT = 20;
    public static final byte A_ACTIVIT = 21;
    public static final byte B_PDU_COM = 22;
    public static final byte A_PDU_COM = 23;
    public static final byte PDU_DEACTIVIT = 24;
    public static final byte SAM_ACTIVIT = 25;
    public static final byte SAM_PDU_COM = 26;
    public static final byte SAM_DEACTIVIT = 27;
    public static final byte UL_FAST_READ = 28;
    public static final byte UL_FAST_WRITE = 29;
    public static final byte GET_FINANCIAL_NUM = 30;
    public static final byte B_GET_DN_NUM = 31;
    public static final byte SRI512_READ_COM = 32;
    public static final byte SRI512_WRITE_COM = 33;
    public static final byte NFC_P2P_EXCHANGE = 34;
    public static final byte GET_ATR_CMD = 35;
    public static final byte ENTER_UPDATE_CMD = 36;
    public static final byte UL_EXCHANGE_CMD = 37;
    public static final byte B_GET_SAMV_DN = 38;
    public static final byte EPASS_ACTIVIT = 48;
    public static final byte EPASS_READ_FILE = 49;
    public static final byte SAM_V_INIT_COM = 50;
    public static final byte SAM_V_APDU_COM = 51;
    public static final byte SAM_V_SUCCEED_COM = 52;
    public static final byte SAM_V_ERROR_COM = 53;
    public static final byte SAM_V_GET_AES_KEY_COM = 54;
    public static final byte SAM_V_GET_DEVICE_ID = 55;
    public static final byte AL_ISO15693_READ_SINGLE_BLOCK = -112;
    public static final byte AL_ISO15693_READ_MULTIPLE_BLOCK = -111;
    public static final byte AL_ISO15693_WRITE_SINGLE_BLOCK = -110;
    public static final byte AL_ISO15693_WRITE_MULTIPLE_BLOCK = -109;
    public static final byte AL_ISO15693_LOCK_BLOCK = -108;
    public static final byte AL_AUTO_SEARCH_CARD_SW = -107;
    public static final byte AL_ISO15693_READ_ALL = -106;
    public static final byte CONFIG_UART_BAUD = -96;
    public static final byte CONFIG_SYS_P = -95;
    public static final byte GET_CONFIG_SYS_P = -94;
    public static final byte SAVE_ACCOUNT_COM = -93;
    public static final byte SAVE_ADDR_COM = -92;
    public static final byte GET_VERSION = -80;
    public static final byte GET_HW_VERSION = -79;
    public static final byte OPEN_BEEP_CMD = -78;
    public static final byte GET_BEEP_CMD = -77;
    public static final byte UART_RESEND = -76;
    public static final byte EER_TAG_TYPE = -32;
    public static final byte EER_NO_FINE_TAG = -31;
    public static final byte EER_KEY_NO_AUTH = -30;
    public static final byte EER_READ_BLOCK = -29;
    public static final byte EER_WRITE_BLOCK = -28;
    public static final byte EER_VALUE_INIT = -27;
    public static final byte EER_VALUE_ADD = -26;
    public static final byte EER_VALUE_SUB = -25;
    public static final byte EER_EEROM_OVER = -24;
    public static final byte EER_EEROM_WRITE = -23;
    public static final byte EER_NO_ACTIVIT = -22;
    public static final byte EER_DETECT_MORE_CAR = -21;
    public static final byte COM_ACK = -2;
    public static final byte COM_NACK = -1;
    public static final byte PICC_TYPE_M1 = 1;
    public static final byte PICC_TYPE_UL = 2;
    public static final byte PICC_TYPE_B = 3;
    public static final byte PICC_TYPE_ACPU = 4;
    public static final byte PICC_TYPE_15693 = 5;
    public static final byte PICC_TYPE_FELICA = 6;
    public static final byte PICC_TYPE_SRI512 = 7;
    public static final byte PICC_TYPE_COPY = 8;
    public static final byte PICC_TYPE_DF = 9;
    public static final byte CARD_TYPE_NO_DEFINE = 0;
    public static final byte CARD_TYPE_ISO4443_A = 4;
    public static final byte CARD_TYPE_ISO4443_B = 3;
    public static final byte CARD_TYPE_FELICA = 6;
    public static final byte CARD_TYPE_MIFARE = 1;
    public static final byte CARD_TYPE_ISO15693 = 5;
    public static final byte CARD_TYPE_ULTRALIGHT = 2;
    public static final byte CARD_TYPE_DESFire = 9;
    public static final byte CARD_TYPE_SAMV_ID = -93;

    public static byte[] getCmdBytes(byte cmd, byte[] data) {
        byte[] bytes = new byte[data.length + 3];
        int cmdLen = data.length + 1;
        bytes[0] = -86;
        bytes[1] = (byte)(cmdLen & 0xFF);
        bytes[2] = cmd;
        System.arraycopy(data, 0, bytes, 3, data.length);
        return bytes;
    }

    public static byte[] getCmdBytes(byte cmd, byte addr, byte[] data) {
        byte[] bytes = new byte[data.length + 4];
        int cmdLen = data.length + 2;
        bytes[0] = -86;
        bytes[1] = (byte)(cmdLen & 0xFF);
        bytes[2] = cmd;
        bytes[3] = addr;
        System.arraycopy(data, 0, bytes, 4, data.length);
        return bytes;
    }

    public static byte[] getCmdBytes(byte cmd, byte addr, byte param, byte[] data) {
        byte[] bytes = new byte[data.length + 5];
        int cmdLen = data.length + 3;
        bytes[0] = -86;
        bytes[1] = (byte)(cmdLen & 0xFF);
        bytes[2] = cmd;
        bytes[3] = addr;
        bytes[4] = param;
        System.arraycopy(data, 0, bytes, 5, data.length);
        return bytes;
    }

    public static byte[] getCmdBytes(byte cmd) {
        byte[] bytes = new byte[]{-86, 1, cmd};
        return bytes;
    }

    public static boolean verify_ack(byte[] data) {
        if (data == null || data.length != 3) {
            return false;
        }
        if (data[0] != -86) {
            return false;
        }
        return data[2] == -2;
    }

    public static DKMessageDef getRspMsg(byte[] data) throws CardNoResponseException {
        if (data == null || data.length < 3) {
            throw new CardNoResponseException("\u6570\u636e\u4e3a\u7a7a\u6216\u8005\u6570\u636e\u957f\u5ea6\u8fc7\u5c0f");
        }
        if (data[0] != -86 && data[0] != -69) {
            throw new CardNoResponseException("\u5e27\u5934\u9519\u8bef");
        }
        DKMessageDef dkMessageDef = new DKMessageDef(false);
        int index = 0;
        dkMessageDef.start = data[index++];
        if (dkMessageDef.start == -86) {
            dkMessageDef.len = data[index++] & 0xFF;
            if (dkMessageDef.len + 2 != data.length) {
                throw new CardNoResponseException("\u957f\u5ea6\u5b57\u8282\u9519\u8bef");
            }
        } else if (dkMessageDef.start == -69) {
            dkMessageDef.len = (data[index] & 0xFF) << 8 | data[index + 1] & 0xFF;
            index += 2;
            if (dkMessageDef.len + 4 != data.length) {
                throw new CardNoResponseException("\u957f\u5ea6\u5b57\u8282\u9519\u8bef");
            }
            byte bcc_sum = 0;
            for (int i = 0; i < data.length - 1; ++i) {
                bcc_sum = (byte)(bcc_sum ^ data[i]);
            }
            if (bcc_sum != data[data.length - 1]) {
                throw new CardNoResponseException("\u548c\u6821\u9a8c\u5931\u8d25");
            }
            dkMessageDef.bcc = data[data.length - 1];
        }
        dkMessageDef.command = data[index++];
        if (dkMessageDef.len == 1) {
            dkMessageDef.dataLen = 0;
            return dkMessageDef;
        }
        if (dkMessageDef.start == -86) {
            dkMessageDef.data = Arrays.copyOfRange(data, index, data.length);
        } else if (dkMessageDef.start == -69) {
            dkMessageDef.data = Arrays.copyOfRange(data, index, data.length - 1);
        }
        dkMessageDef.dataLen = dkMessageDef.data.length;
        return dkMessageDef;
    }
}

