/*
 * Decompiled with CFR 0.152.
 */
package com.dk.uartnfc.DeviceManager;

import com.dk.uartnfc.DKCloudID.DKCloudID;
import com.dk.uartnfc.DeviceManager.Command;
import com.dk.uartnfc.DeviceManager.DeviceManager;
import com.dk.uartnfc.Exception.CardNoResponseException;
import com.dk.uartnfc.Exception.DeviceNoResponseException;
import com.dk.uartnfc.Tool.StringTool;
import com.dk.uartnfc.UartManager.DKMessageDef;

public class UartNfcDevice
extends DeviceManager {
    public boolean openDevice(String portName) {
        return this.serialManager.open(portName, "115200");
    }

    public boolean openDevice(String portName, String baudRate) {
        return this.serialManager.open(portName, baudRate);
    }

    public boolean closeDevice() {
        this.destroy();
        return true;
    }

    public void destroy() {
        if (this.serialManager != null) {
            this.serialManager.close();
        }
        DKCloudID.Close();
        this.release();
    }

    public boolean openBeep(int delayMs, int n) throws DeviceNoResponseException {
        try {
            byte[] nfc_return_bytes = this.cmd(Command.getCmdBytes((byte)-78, (byte)(delayMs / 10), new byte[]{(byte)n}), 500);
            return Command.verify_ack(nfc_return_bytes);
        }
        catch (DeviceNoResponseException e) {
            throw new DeviceNoResponseException("\u65e0\u54cd\u5e94");
        }
    }

    public String getFirmwareVersion() throws DeviceNoResponseException {
        try {
            byte[] nfc_return_bytes = this.cmd(Command.getCmdBytes((byte)-80), 500);
            DKMessageDef msg = Command.getRspMsg(nfc_return_bytes);
            if (msg.data == null || msg.data.length < 1) {
                throw new DeviceNoResponseException("\u65e0\u54cd\u5e94");
            }
            return StringTool.byteHexToSting(msg.data);
        }
        catch (CardNoResponseException | DeviceNoResponseException e) {
            throw new DeviceNoResponseException("\u65e0\u54cd\u5e94");
        }
    }

    public String cmd(String cmdStr) throws DeviceNoResponseException {
        return StringTool.byteHexToSting(this.cmd(StringTool.hexStringToBytes(cmdStr)));
    }

    public String cmd(String cmdStr, int timeout) throws DeviceNoResponseException {
        return StringTool.byteHexToSting(this.cmd(StringTool.hexStringToBytes(cmdStr), timeout));
    }

    public byte[] cmd(byte[] bytes) throws DeviceNoResponseException {
        return this.serialManager.sendWithReturn(bytes);
    }

    public byte[] cmd(byte[] bytes, int timeout) throws DeviceNoResponseException {
        return this.serialManager.sendWithReturn(bytes, timeout);
    }
}

