/*
 * Decompiled with CFR 0.152.
 */
package com.dk.uartnfc.OTA;

import com.dk.uartnfc.OTA.CRC;
import com.dk.uartnfc.OTA.TimeoutException;
import com.dk.uartnfc.OTA.Timer;
import com.dk.uartnfc.UartManager.SerialManager;
import java.io.DataInputStream;
import java.io.IOException;

class Modem {
    private SerialManager mUartManager;
    protected static final byte SOH = 1;
    protected static final byte STX = 2;
    protected static final byte EOT = 4;
    protected static final byte ACK = 6;
    protected static final byte NAK = 21;
    protected static final byte CAN = 24;
    protected static final byte CPMEOF = 26;
    protected static final byte ST_C = 67;
    protected static final int MAXERRORS = 3;
    protected static final int BLOCK_TIMEOUT = 1000;
    protected static final int REQUEST_TIMEOUT = 3000;
    protected static final int WAIT_FOR_RECEIVER_TIMEOUT = 60000;
    protected static final int SEND_BLOCK_TIMEOUT = 10000;

    protected Modem(SerialManager manager) {
        this.mUartManager = manager;
    }

    protected boolean waitReceiverRequest(Timer timer) throws IOException {
        try {
            byte character;
            do {
                if ((character = this.readByte(timer)) != 21) continue;
                return false;
            } while (character != 67);
            return true;
        }
        catch (TimeoutException e) {
            throw new IOException("Timeout waiting for receiver");
        }
    }

    protected void sendDataBlocks(DataInputStream dataStream, int blockNumber, CRC crc, byte[] block) throws IOException {
        int dataLength;
        while ((dataLength = dataStream.read(block)) != -1) {
            this.sendBlock(blockNumber++, block, dataLength, crc);
        }
    }

    protected void sendEOT() throws IOException {
        Timer timer = new Timer(1000L);
        for (int errorCount = 0; errorCount < 10; ++errorCount) {
            this.sendByte((byte)4);
            try {
                byte character = this.readByte(timer.start());
                if (character == 6 || character == 21) {
                    return;
                }
                if (character != 24) continue;
                throw new IOException("Transmission terminated");
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
        }
    }

    protected void sendBlock(int blockNumber, byte[] block, int dataLength, CRC crc) throws IOException {
        Timer timer = new Timer(10000L);
        if (dataLength < block.length) {
            block[dataLength] = 26;
        }
        int errorCount = 0;
        while (errorCount < 3) {
            timer.start();
            byte[] sendTmp = new byte[block.length + 3 + crc.getCRCLength()];
            sendTmp[0] = block.length == 1024 ? 2 : 1;
            sendTmp[1] = (byte)blockNumber;
            sendTmp[2] = (byte)(~blockNumber);
            System.arraycopy(block, 0, sendTmp, 3, block.length);
            byte[] crcBytes = new byte[crc.getCRCLength()];
            long crcValue = crc.calcCRC(block);
            for (int i = 0; i < crc.getCRCLength(); ++i) {
                crcBytes[crc.getCRCLength() - i - 1] = (byte)(crcValue >> 8 * i & 0xFFL);
            }
            System.arraycopy(crcBytes, 0, sendTmp, block.length + 3, crcBytes.length);
            this.write(sendTmp);
            try {
                byte character = this.readByte(timer);
                if (character == 6) {
                    return;
                }
                if (character == 21) {
                    ++errorCount;
                    continue;
                }
                if (character == 24) {
                    throw new IOException("Transmission terminated");
                }
                ++errorCount;
            }
            catch (TimeoutException e) {
                ++errorCount;
            }
        }
        throw new IOException("Too many errors caught, abandoning transfer");
    }

    private void writeCRC(byte[] block, CRC crc) throws IOException {
        byte[] crcBytes = new byte[crc.getCRCLength()];
        long crcValue = crc.calcCRC(block);
        for (int i = 0; i < crc.getCRCLength(); ++i) {
            crcBytes[crc.getCRCLength() - i - 1] = (byte)(crcValue >> 8 * i & 0xFFL);
        }
        this.write(crcBytes);
    }

    protected void sendByte(byte b) throws IOException {
        this.write(new byte[]{b});
    }

    private void shortSleep() {
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            try {
                this.interruptTransmission();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new RuntimeException("Transmission was interrupted", e);
        }
    }

    protected void interruptTransmission() throws IOException {
        this.sendByte((byte)24);
        this.sendByte((byte)24);
    }

    private byte readByte(Timer timer) throws IOException, TimeoutException {
        byte[] buf = new byte[1];
        int read = this.mUartManager.read(buf, 1, 1100, 20);
        if (read > 0) {
            return buf[0];
        }
        throw new TimeoutException();
    }

    public void write(byte[] b) {
        this.mUartManager.send(b);
    }
}

