/*
 * Decompiled with CFR 0.152.
 */
package com.dk.uartnfc.OTA;

import android.os.Build;
import com.dk.log.DKLog;
import com.dk.uartnfc.OTA.CRC;
import com.dk.uartnfc.OTA.CRC16;
import com.dk.uartnfc.OTA.CRC8;
import com.dk.uartnfc.OTA.Constants;
import com.dk.uartnfc.OTA.Modem;
import com.dk.uartnfc.OTA.Timer;
import com.dk.uartnfc.UartManager.SerialManager;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class YModem {
    private Modem modem;
    private onReceiveScheduleListener mOnReceiveScheduleListener;

    public YModem(SerialManager manager) {
        this.modem = new Modem(manager);
    }

    public void send(File file, onReceiveScheduleListener l) throws IOException {
        this.mOnReceiveScheduleListener = l;
        if (Build.VERSION.SDK_INT >= 19) {
            try (DataInputStream dataStream = new DataInputStream(new FileInputStream(file));){
                int dataLength;
                Timer timer = new Timer(60000L).start();
                boolean useCRC16 = this.modem.waitReceiverRequest(timer);
                CRC crc = useCRC16 ? new CRC16() : new CRC8();
                if (this.mOnReceiveScheduleListener != null) {
                    this.mOnReceiveScheduleListener.onReceiveSchedule(1);
                }
                String fileNameString = file.getName() + '\u0000' + file.length() + ' ';
                int packCount = (int)Math.ceil((double)file.length() / 1024.0);
                DKLog.i("gh0st", "fileNameString:" + fileNameString + "packCount:" + (packCount + 1));
                Constants.sCountPro = packCount + 1;
                byte[] fileNameBytes = Arrays.copyOf(fileNameString.getBytes(), 128);
                this.modem.sendBlock(0, Arrays.copyOf(fileNameBytes, 128), 128, crc);
                this.modem.waitReceiverRequest(timer);
                byte[] block = new byte[1024];
                int blockNumber = 1;
                while ((dataLength = dataStream.read(block)) != -1) {
                    this.modem.sendBlock(blockNumber++, block, dataLength, crc);
                    int progress = (int)((float)block.length * (float)blockNumber / (float)file.length() * 100.0f);
                    if (this.mOnReceiveScheduleListener == null) continue;
                    this.mOnReceiveScheduleListener.onReceiveSchedule(progress);
                }
                this.modem.sendEOT();
                this.modem.sendEOT();
                this.modem.sendBlock(0, new byte[128], 128, crc);
                if (this.mOnReceiveScheduleListener != null) {
                    this.mOnReceiveScheduleListener.onReceiveSchedule(100);
                }
            }
        }
    }

    public void send(InputStream file, onReceiveScheduleListener l) throws IOException {
        this.mOnReceiveScheduleListener = l;
        if (Build.VERSION.SDK_INT >= 19) {
            try (DataInputStream dataStream = new DataInputStream(file);){
                int dataLength;
                Timer timer = new Timer(60000L).start();
                boolean useCRC16 = this.modem.waitReceiverRequest(timer);
                CRC crc = useCRC16 ? new CRC16() : new CRC8();
                if (this.mOnReceiveScheduleListener != null) {
                    this.mOnReceiveScheduleListener.onReceiveSchedule(1);
                }
                int total_len = file.available();
                String fileNameString = "\u0000" + total_len + ' ';
                int packCount = (int)Math.ceil((double)total_len / 128.0);
                DKLog.i("gh0st", "fileNameString:" + fileNameString + "packCount:" + (packCount + 1));
                Constants.sCountPro = packCount + 1;
                byte[] fileNameBytes = Arrays.copyOf(fileNameString.getBytes(), 128);
                this.modem.sendBlock(0, Arrays.copyOf(fileNameBytes, 128), 128, crc);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                byte[] block = new byte[128];
                int blockNumber = 1;
                while ((dataLength = dataStream.read(block)) != -1) {
                    this.modem.sendBlock(blockNumber++, block, dataLength, crc);
                    int progress = (int)((float)block.length * (float)blockNumber / (float)total_len * 100.0f);
                    if (this.mOnReceiveScheduleListener == null) continue;
                    this.mOnReceiveScheduleListener.onReceiveSchedule(progress);
                }
                this.modem.sendEOT();
                this.modem.sendEOT();
                this.modem.sendBlock(0, new byte[128], 128, crc);
                if (this.mOnReceiveScheduleListener != null) {
                    this.mOnReceiveScheduleListener.onReceiveSchedule(100);
                }
            }
        }
    }

    public void batchSend(File ... files) throws IOException {
        for (File file : files) {
            this.send(file, null);
        }
        this.sendBatchStop();
    }

    private void sendBatchStop() throws IOException {
        Timer timer = new Timer(60000L).start();
        boolean useCRC16 = this.modem.waitReceiverRequest(timer);
        CRC crc = useCRC16 ? new CRC16() : new CRC8();
        byte[] bytes = new byte[128];
        this.modem.sendBlock(0, bytes, bytes.length, crc);
    }

    public static interface onReceiveScheduleListener {
        public void onReceiveSchedule(int var1);
    }
}

