/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.speech;

import android.content.Context;
import android.content.Intent;
import android.os.RemoteException;
import com.iflytek.cloud.InitListener;
import com.iflytek.cloud.SpeechUtility;
import com.iflytek.speech.SpeechModuleAidl;
import com.iflytek.speech.SynthesizeToUrlListener;
import com.iflytek.speech.SynthesizerListener;
import com.iflytek.speech.aidl.ISpeechSynthesizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpeechSynthesizerAidl
extends SpeechModuleAidl<ISpeechSynthesizer> {
    public SpeechSynthesizerAidl(Context context, InitListener initListener) {
        super(context, initListener, "com.iflytek.component.speechsynthesizer");
    }

    public int synthesizeToUrl(String string, SynthesizeToUrlListener synthesizeToUrlListener) {
        if (this.mService == null) {
            return 21003;
        }
        if (synthesizeToUrlListener == null) {
            return 20012;
        }
        try {
            Intent intent = this.getIntent();
            intent.putExtra("text", string);
            return ((ISpeechSynthesizer)this.mService).synthesizeToUrl(intent, synthesizeToUrlListener);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return 21004;
        }
    }

    public int startSpeaking(String string, SynthesizerListener synthesizerListener) {
        if (this.mService == null) {
            return 21003;
        }
        if (synthesizerListener == null) {
            return 20012;
        }
        try {
            Intent intent = this.getIntent();
            intent.putExtra("text", string);
            return ((ISpeechSynthesizer)this.mService).startSpeaking(intent, synthesizerListener);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return 21004;
        }
    }

    public int pauseSpeaking(SynthesizerListener synthesizerListener) {
        if (this.mService == null) {
            return 21003;
        }
        if (synthesizerListener == null) {
            return 20012;
        }
        try {
            return ((ISpeechSynthesizer)this.mService).pauseSpeaking(synthesizerListener);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return 21004;
        }
    }

    public int resumeSpeaking(SynthesizerListener synthesizerListener) {
        if (this.mService == null) {
            return 21003;
        }
        if (synthesizerListener == null) {
            return 20012;
        }
        try {
            return ((ISpeechSynthesizer)this.mService).resumeSpeaking(synthesizerListener);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return 21004;
        }
    }

    public int stopSpeaking(SynthesizerListener synthesizerListener) {
        if (this.mService == null) {
            return 21003;
        }
        if (synthesizerListener == null) {
            return 20012;
        }
        try {
            return ((ISpeechSynthesizer)this.mService).stopSpeaking(synthesizerListener);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return 21004;
        }
    }

    public boolean isSpeaking() {
        boolean bl = false;
        try {
            if (this.mService != null) {
                bl = ((ISpeechSynthesizer)this.mService).isSpeaking();
            }
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        return bl;
    }

    @Override
    public int setParameter(String string, String string2) {
        return super.setParameter(string, string2);
    }

    @Override
    public String getParameter(String string) {
        if (string.equals("local_speakers")) {
            try {
                if (SpeechUtility.getUtility() == null) {
                    return null;
                }
                int n = SpeechUtility.getUtility().getServiceVersion();
                if (n < 44 || n >= 10000 && n < 10013) {
                    return null;
                }
                return ((ISpeechSynthesizer)this.mService).getLocalSpeakerList();
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
                return "20999";
            }
        }
        return super.getParameter(string);
    }

    @Override
    public boolean destory() {
        this.mService = null;
        return super.destory();
    }
}

