/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.speech.aidl;

import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.iflytek.speech.SynthesizeToUrlListener;
import com.iflytek.speech.SynthesizerListener;

public interface ISpeechSynthesizer
extends IInterface {
    public int synthesizeToUrl(Intent var1, SynthesizeToUrlListener var2) throws RemoteException;

    public int startSpeaking(Intent var1, SynthesizerListener var2) throws RemoteException;

    public int pauseSpeaking(SynthesizerListener var1) throws RemoteException;

    public int resumeSpeaking(SynthesizerListener var1) throws RemoteException;

    public int stopSpeaking(SynthesizerListener var1) throws RemoteException;

    public boolean isSpeaking() throws RemoteException;

    public String getLocalSpeakerList() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISpeechSynthesizer {
        private static final String DESCRIPTOR = "com.iflytek.speech.aidl.ISpeechSynthesizer";
        static final int TRANSACTION_synthesizeToUrl = 1;
        static final int TRANSACTION_startSpeaking = 2;
        static final int TRANSACTION_pauseSpeaking = 3;
        static final int TRANSACTION_resumeSpeaking = 4;
        static final int TRANSACTION_stopSpeaking = 5;
        static final int TRANSACTION_isSpeaking = 6;
        static final int TRANSACTION_getLocalSpeakerList = 7;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ISpeechSynthesizer asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof ISpeechSynthesizer) {
                return (ISpeechSynthesizer)iInterface;
            }
            return new Proxy(iBinder);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Intent intent = 0 != parcel.readInt() ? (Intent)Intent.CREATOR.createFromParcel(parcel) : null;
                    SynthesizeToUrlListener synthesizeToUrlListener = SynthesizeToUrlListener.Stub.asInterface(parcel.readStrongBinder());
                    int n3 = this.synthesizeToUrl(intent, synthesizeToUrlListener);
                    parcel2.writeNoException();
                    parcel2.writeInt(n3);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Intent intent = 0 != parcel.readInt() ? (Intent)Intent.CREATOR.createFromParcel(parcel) : null;
                    SynthesizerListener synthesizerListener = SynthesizerListener.Stub.asInterface(parcel.readStrongBinder());
                    int n4 = this.startSpeaking(intent, synthesizerListener);
                    parcel2.writeNoException();
                    parcel2.writeInt(n4);
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    SynthesizerListener synthesizerListener = SynthesizerListener.Stub.asInterface(parcel.readStrongBinder());
                    int n5 = this.pauseSpeaking(synthesizerListener);
                    parcel2.writeNoException();
                    parcel2.writeInt(n5);
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    SynthesizerListener synthesizerListener = SynthesizerListener.Stub.asInterface(parcel.readStrongBinder());
                    int n6 = this.resumeSpeaking(synthesizerListener);
                    parcel2.writeNoException();
                    parcel2.writeInt(n6);
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    SynthesizerListener synthesizerListener = SynthesizerListener.Stub.asInterface(parcel.readStrongBinder());
                    int n7 = this.stopSpeaking(synthesizerListener);
                    parcel2.writeNoException();
                    parcel2.writeInt(n7);
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isSpeaking();
                    parcel2.writeNoException();
                    parcel2.writeInt(bl ? 1 : 0);
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string = this.getLocalSpeakerList();
                    parcel2.writeNoException();
                    parcel2.writeString(string);
                    return true;
                }
            }
            return super.onTransact(n, parcel, parcel2, n2);
        }

        private static class Proxy
        implements ISpeechSynthesizer {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int synthesizeToUrl(Intent intent, SynthesizeToUrlListener synthesizeToUrlListener) throws RemoteException {
                int n;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intent != null) {
                        parcel.writeInt(1);
                        intent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeStrongBinder(synthesizeToUrlListener != null ? synthesizeToUrlListener.asBinder() : null);
                    this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    n = parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int startSpeaking(Intent intent, SynthesizerListener synthesizerListener) throws RemoteException {
                int n;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intent != null) {
                        parcel.writeInt(1);
                        intent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeStrongBinder(synthesizerListener != null ? synthesizerListener.asBinder() : null);
                    this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    n = parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int pauseSpeaking(SynthesizerListener synthesizerListener) throws RemoteException {
                int n;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(synthesizerListener != null ? synthesizerListener.asBinder() : null);
                    this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    n = parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int resumeSpeaking(SynthesizerListener synthesizerListener) throws RemoteException {
                int n;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(synthesizerListener != null ? synthesizerListener.asBinder() : null);
                    this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    n = parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int stopSpeaking(SynthesizerListener synthesizerListener) throws RemoteException {
                int n;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(synthesizerListener != null ? synthesizerListener.asBinder() : null);
                    this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    n = parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean isSpeaking() throws RemoteException {
                boolean bl;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    bl = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String getLocalSpeakerList() throws RemoteException {
                String string;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    string = parcel2.readString();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return string;
            }
        }
    }
}

