/*
 * Decompiled with CFR 0.152.
 */
package com.ipay;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.TextView;
import android.widget.Toast;
import com.ipay.Ipay;
import com.ipay.IpayPayment;
import com.ipay.IpayResultDelegate;
import com.ipay.log.LoggingInfo;
import com.ipay.log.LoggingTask;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;

public class IpaySelectionActivity
extends Activity
implements View.OnClickListener {
    private RadioGroup radioGroup;
    private RadioButton ccRbtn;
    private RadioButton obRbtn;
    private Button proceedButton;
    private Button cancelButton;
    private IpayPayment ipayPayment;
    private IpayResultDelegate ipayResult;
    private final String RHB_RBTN_TAG = IpaySelectionActivity.class.getName() + ".RHB_RBTN";
    private final String CC_RBTN_TAG = IpaySelectionActivity.class.getName() + ".CC_RBTN";
    private final String OB_RBTN_TAG = IpaySelectionActivity.class.getName() + ".OB_RBTN";
    private final String PROCEED_BTN_TAG = IpaySelectionActivity.class.getName() + ".PROCEED_BTN";
    private final String CANCEL_BTN_TAG = IpaySelectionActivity.class.getName() + ".CANCEL_BTN";
    private final String LABEL_TEXT = "Please select a payment method";
    private final String RHB_RBTN_TEXT = "RHB Now";
    private final String CC_RBTN_TEXT = "Credit Card";
    private final String OB_RBTN_TEXT = "Online Banking";
    private final String PROCEED_BTN_TEXT = "Proceed";
    private final String CANCEL_BTN_TEXT = "Cancel";
    private final int HASH_COUNT_PORT = 8243;
    private final String HASH_COUNT_URL = "https://vm-mpayment.cloudapp.net:8243/PaymentGateway/RHX";
    private final int LOGGING_PORT = 8080;
    private final String LOGGING_URL = "http://10.0.2.2:8080/logserver/log";
    private HashCountTask hashCountTask;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.initializeLayout();
        this.ipayPayment = (IpayPayment)this.getIntent().getSerializableExtra("com.ipay.android.IPAY_PAYMENT");
        this.ipayResult = (IpayResultDelegate)((Object)this.getIntent().getSerializableExtra("com.paypal.android.RESULT_DELEGATE"));
        this.initiateRhbGateway();
    }

    public void onClick(View view) {
        if (this.PROCEED_BTN_TAG.equals(view.getTag())) {
            int checkedId = this.radioGroup.getCheckedRadioButtonId();
            if (checkedId != -1) {
                if (checkedId == this.ccRbtn.getId() || checkedId == this.obRbtn.getId()) {
                    Intent checkoutIntent = Ipay.getInstance().checkout(this.ipayPayment, (Context)this, this.ipayResult);
                    this.startActivityForResult(checkoutIntent, 1);
                }
            } else {
                Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"Please select a payment method", (int)0).show();
            }
        } else {
            this.finish();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.setResult(resultCode, data);
        this.finish();
    }

    private void initializeLayout() {
        LinearLayout ll = new LinearLayout((Context)this);
        ll.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        ll.setOrientation(1);
        LinearLayout.LayoutParams labelLp = new LinearLayout.LayoutParams(-1, -2);
        labelLp.setMargins(20, 50, 20, 20);
        TextView title = new TextView((Context)this);
        title.setText((CharSequence)"Please select a payment method");
        title.setTextSize(20.0f);
        title.setLayoutParams((ViewGroup.LayoutParams)labelLp);
        ImageView lineView = new ImageView((Context)this);
        lineView.setBackgroundColor(-1);
        lineView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 1));
        this.radioGroup = new RadioGroup((Context)this);
        this.ccRbtn = new RadioButton((Context)this);
        this.obRbtn = new RadioButton((Context)this);
        LinearLayout.LayoutParams radioGroupLp = new LinearLayout.LayoutParams(-1, 0, 1.0f);
        radioGroupLp.setMargins(10, 30, 0, 0);
        this.radioGroup.setLayoutParams((ViewGroup.LayoutParams)radioGroupLp);
        this.ccRbtn.setText((CharSequence)"Credit Card");
        this.ccRbtn.setTag((Object)this.CC_RBTN_TAG);
        this.ccRbtn.setPadding(10, 20, 10, 20);
        this.obRbtn.setText((CharSequence)"Online Banking");
        this.obRbtn.setTag((Object)this.OB_RBTN_TAG);
        this.obRbtn.setPadding(10, 20, 10, 20);
        this.radioGroup.addView((View)this.ccRbtn);
        this.radioGroup.addView((View)this.obRbtn);
        LinearLayout btnLl = new LinearLayout((Context)this);
        btnLl.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2, 0.0f));
        btnLl.setOrientation(1);
        btnLl.setPadding(0, 0, 0, 20);
        this.proceedButton = new Button((Context)this);
        this.proceedButton.setText((CharSequence)"Proceed");
        this.proceedButton.setHeight(10);
        this.proceedButton.setOnClickListener((View.OnClickListener)this);
        this.proceedButton.setTag((Object)this.PROCEED_BTN_TAG);
        this.cancelButton = new Button((Context)this);
        this.cancelButton.setText((CharSequence)"Cancel");
        this.cancelButton.setHeight(10);
        this.cancelButton.setOnClickListener((View.OnClickListener)this);
        this.cancelButton.setTag((Object)this.CANCEL_BTN_TAG);
        btnLl.addView((View)this.proceedButton);
        btnLl.addView((View)this.cancelButton);
        ll.addView((View)title);
        ll.addView((View)lineView);
        ll.addView((View)this.radioGroup);
        ll.addView((View)btnLl);
        this.setContentView((View)ll);
    }

    private void initiateRhbGateway() {
        if (this.hashCountTask != null) {
            this.hashCountTask.cancel(true);
            this.hashCountTask = null;
        }
        this.hashCountTask = new HashCountTask(this);
    }

    private void logToServer(String merchantCode, String orderNo, String paymentStatus, String message) {
        LoggingInfo info = new LoggingInfo();
        info.setUrl("http://10.0.2.2:8080/logserver/log");
        info.setPort(8080);
        info.setMerchantCode(merchantCode);
        info.setUsername(this.ipayPayment.getUserName());
        info.setAmount(this.ipayPayment.getAmount());
        info.setGateway("RHB");
        info.setRefNo(orderNo);
        info.setSuccess(false);
        info.setStatus(paymentStatus);
        info.setMessage(message);
        info.setPaymentTime(new Date());
        LoggingTask t = new LoggingTask();
        if (Build.VERSION.SDK_INT >= 11) {
            t.executeOnExecutor(LoggingTask.THREAD_POOL_EXECUTOR, new LoggingInfo[]{info});
        } else {
            t.execute(new LoggingInfo[]{info});
        }
    }

    public void finish() {
        super.finish();
        if (this.hashCountTask != null && this.hashCountTask.getStatus() == AsyncTask.Status.RUNNING) {
            try {
                this.hashCountTask.cancel(true);
                this.hashCountTask = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public class MySSLSocketFactory
    extends SSLSocketFactory {
        SSLContext sslContext;

        public MySSLSocketFactory(KeyStore truststore) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
            super(truststore);
            this.sslContext = SSLContext.getInstance("TLS");
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            this.sslContext.init(null, new TrustManager[]{tm}, null);
        }

        public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
            return this.sslContext.getSocketFactory().createSocket(socket, host, port, autoClose);
        }

        public Socket createSocket() throws IOException {
            return this.sslContext.getSocketFactory().createSocket();
        }
    }

    private class HashCountTask
    extends AsyncTask<String, String, String> {
        private IpaySelectionActivity activity;
        private ProgressDialog progressDialog;

        public HashCountTask(IpaySelectionActivity activity) {
            this.activity = activity;
        }

        protected String doInBackground(String ... params) {
            String responseString;
            block5: {
                String merchantCode = params[0];
                String orderNo = params[1];
                String amount = params[2];
                Log.i((String)"com.ipay", (String)("merchantCode=" + merchantCode));
                Log.i((String)"com.ipay", (String)("orderNo=" + orderNo));
                Log.i((String)"com.ipay", (String)("amount=" + amount));
                responseString = null;
                try {
                    ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
                    nameValuePairs.add(new BasicNameValuePair("merchantId", merchantCode));
                    nameValuePairs.add(new BasicNameValuePair("orderNo", orderNo));
                    nameValuePairs.add(new BasicNameValuePair("amount", amount));
                    HttpPost post = new HttpPost("https://vm-mpayment.cloudapp.net:8243/PaymentGateway/RHX");
                    post.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs));
                    BasicHttpParams httpParams = new BasicHttpParams();
                    HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)10000);
                    HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)10000);
                    DefaultHttpClient httpClient = new DefaultHttpClient((HttpParams)httpParams);
                    KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                    trustStore.load(null, null);
                    MySSLSocketFactory ssf = new MySSLSocketFactory(trustStore);
                    ssf.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
                    httpClient.getConnectionManager().getSchemeRegistry().register(new Scheme("https", (SocketFactory)ssf, 8243));
                    HttpResponse response = httpClient.execute((HttpUriRequest)post);
                    if (response.getStatusLine().getStatusCode() == 200) {
                        if (response.getEntity() != null) {
                            responseString = EntityUtils.toString((HttpEntity)response.getEntity());
                            if (responseString != null) {
                                responseString = responseString.trim();
                            }
                            break block5;
                        }
                        throw new NullPointerException("response entity is null");
                    }
                    response.getEntity().getContent().close();
                    throw new IOException(response.getStatusLine().getReasonPhrase());
                }
                catch (Exception e) {
                    Log.e((String)"com.ipay", (String)e.getMessage(), (Throwable)e);
                }
            }
            return responseString;
        }

        protected void onPreExecute() {
            super.onPreExecute();
            Log.d((String)"com.ipay", (String)"pre execute");
            IpaySelectionActivity.this.proceedButton.setEnabled(false);
            this.progressDialog = new ProgressDialog((Context)this.activity);
            this.progressDialog.setTitle((CharSequence)"Loading");
            this.progressDialog.setMessage((CharSequence)"Please wait");
            this.progressDialog.show();
        }

        protected void onPostExecute(String hashCount) {
            super.onPostExecute((Object)hashCount);
            Log.d((String)"com.ipay", (String)"post execute");
            IpaySelectionActivity.this.proceedButton.setEnabled(true);
            this.progressDialog.dismiss();
            if (hashCount == null || hashCount.trim().isEmpty()) {
                IpaySelectionActivity.this.setResult(-1);
                IpaySelectionActivity.this.finish();
            } else {
                String custId = IpaySelectionActivity.this.ipayPayment.getUserName();
                String orderNo = "PG" + IpaySelectionActivity.this.ipayPayment.getRefNo();
                String string2 = IpaySelectionActivity.this.ipayPayment.getAmount();
            }
        }
    }
}

