/*
 * Decompiled with CFR 0.152.
 */
package com.ipay.log;

import android.annotation.SuppressLint;
import android.os.AsyncTask;
import android.util.Log;
import com.ipay.log.LoggingInfo;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;

public class LoggingTask
extends AsyncTask<LoggingInfo, String, String> {
    @SuppressLint(value={"SimpleDateFormat"})
    protected String doInBackground(LoggingInfo ... params) {
        String responseString = null;
        try {
            LoggingInfo info = params[0];
            Log.i((String)((Object)((Object)this)).getClass().getCanonicalName(), (String)"logging to server");
            HttpPost post = new HttpPost(info.getUrl());
            SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
            String dateInString = sdf.format(info.getPaymentTime());
            ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
            nameValuePairs.add(new BasicNameValuePair("merchantCode", info.getMerchantCode()));
            nameValuePairs.add(new BasicNameValuePair("username", info.getUsername()));
            nameValuePairs.add(new BasicNameValuePair("refNo", info.getRefNo()));
            nameValuePairs.add(new BasicNameValuePair("amount", info.getAmount()));
            nameValuePairs.add(new BasicNameValuePair("gateway", info.getGateway()));
            nameValuePairs.add(new BasicNameValuePair("status", info.getStatus()));
            nameValuePairs.add(new BasicNameValuePair("message", info.getMessage()));
            nameValuePairs.add(new BasicNameValuePair("paymentTime", dateInString));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs));
            BasicHttpParams httpParams = new BasicHttpParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)10000);
            HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)10000);
            DefaultHttpClient httpClient = new DefaultHttpClient((HttpParams)httpParams);
            try {
                KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                trustStore.load(null, null);
                MySSLSocketFactory ssf = new MySSLSocketFactory(trustStore);
                ssf.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
                httpClient.getConnectionManager().getSchemeRegistry().register(new Scheme("https", (SocketFactory)ssf, info.getPort()));
            }
            catch (Exception trustStore) {
                // empty catch block
            }
            HttpResponse response = httpClient.execute((HttpUriRequest)post);
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() == 200) {
                if (response.getEntity() == null) {
                    throw new NullPointerException("response entity is null");
                }
                responseString = EntityUtils.toString((HttpEntity)response.getEntity());
            } else {
                response.getEntity().getContent().close();
                throw new IOException(statusLine.getReasonPhrase());
            }
            Log.i((String)((Object)((Object)this)).getClass().getCanonicalName(), (String)responseString);
        }
        catch (ClientProtocolException e) {
            Log.e((String)((Object)((Object)this)).getClass().getCanonicalName(), (String)e.getMessage());
        }
        catch (IOException e) {
            Log.e((String)((Object)((Object)this)).getClass().getCanonicalName(), (String)e.getMessage());
        }
        return responseString;
    }

    public class MySSLSocketFactory
    extends SSLSocketFactory {
        SSLContext sslContext;

        public MySSLSocketFactory(KeyStore truststore) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
            super(truststore);
            this.sslContext = SSLContext.getInstance("TLS");
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            this.sslContext.init(null, new TrustManager[]{tm}, null);
        }

        public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
            return this.sslContext.getSocketFactory().createSocket(socket, host, port, autoClose);
        }

        public Socket createSocket() throws IOException {
            return this.sslContext.getSocketFactory().createSocket();
        }
    }
}

