/*
 * Decompiled with CFR 0.152.
 */
package com.my.target.ads.mediation;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.customevent.CustomEventBanner;
import com.google.android.gms.ads.mediation.customevent.CustomEventBannerListener;
import com.my.target.Tracer;
import com.my.target.ads.CustomParams;
import com.my.target.ads.MyTargetView;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.json.JSONObject;

public class MyTargetAdmobCustomEventBanner
implements CustomEventBanner {
    private static final CustomParams customParams = new CustomParams();
    private static final String SLOT_ID_KEY = "slotId";
    private MyTargetView myTargetView;
    private CustomEventBannerListener bannerListener;
    private final MyTargetView.MyTargetViewListener myTargetViewListener = new MyTargetView.MyTargetViewListener(){

        @Override
        public void onLoad(MyTargetView myTargetView) {
            myTargetView.start();
            if (MyTargetAdmobCustomEventBanner.this.bannerListener != null) {
                MyTargetAdmobCustomEventBanner.this.bannerListener.onAdLoaded((View)myTargetView);
            }
        }

        @Override
        public void onNoAd(String string, MyTargetView myTargetView) {
            if (MyTargetAdmobCustomEventBanner.this.bannerListener != null) {
                MyTargetAdmobCustomEventBanner.this.bannerListener.onAdFailedToLoad(3);
            }
        }

        @Override
        public void onClick(MyTargetView myTargetView) {
            if (MyTargetAdmobCustomEventBanner.this.bannerListener != null) {
                MyTargetAdmobCustomEventBanner.this.bannerListener.onAdClicked();
                MyTargetAdmobCustomEventBanner.this.bannerListener.onAdOpened();
                MyTargetAdmobCustomEventBanner.this.bannerListener.onAdLeftApplication();
            }
        }
    };

    public void requestBannerAd(Context object, CustomEventBannerListener object2, String string, AdSize adSize, MediationAdRequest mediationAdRequest, Bundle object3) {
        int n2;
        try {
            n2 = new JSONObject(string).getInt(SLOT_ID_KEY);
        }
        catch (Exception exception) {
            Tracer.i("Unable to get slotId from parameter json. Probably Admob mediation misconfiguration.");
            if (object2 != null) {
                object2.onAdFailedToLoad(0);
            }
            return;
        }
        if (AdSize.BANNER.equals((Object)adSize)) {
            this.bannerListener = object2;
            if (this.myTargetView == null) {
                this.myTargetView = new MyTargetView((Context)object);
                if (mediationAdRequest != null) {
                    customParams.setGender(mediationAdRequest.getGender());
                    object3 = mediationAdRequest.getBirthday();
                    if (object3 != null && ((Date)object3).getTime() != -1L) {
                        object = new GregorianCalendar();
                        object2 = new GregorianCalendar();
                        ((Calendar)object).setTimeInMillis(((Date)object3).getTime());
                        int n3 = ((Calendar)object2).get(1) - ((Calendar)object).get(1);
                        if (n3 >= 0) {
                            customParams.setAge(n3);
                        }
                    }
                }
                this.myTargetView.init(n2, customParams, false);
                this.myTargetView.setListener(this.myTargetViewListener);
            }
            this.myTargetView.load();
            return;
        }
        if (object2 != null) {
            object2.onAdFailedToLoad(0);
        }
    }

    public void onDestroy() {
        if (this.myTargetView != null) {
            this.myTargetView.destroy();
            this.myTargetView = null;
        }
        this.bannerListener = null;
    }

    public void onPause() {
    }

    public void onResume() {
    }
}

