/*
 * Decompiled with CFR 0.152.
 */
package com.my.target.ads.mediation;

import android.content.Context;
import android.view.View;
import com.mopub.MopubCustomParamsFactory;
import com.mopub.mobileads.CustomEventBanner;
import com.mopub.mobileads.MoPubErrorCode;
import com.my.target.Tracer;
import com.my.target.ads.CustomParams;
import com.my.target.ads.MyTargetView;
import java.util.Map;

public class MyTargetMopubCustomEventBanner
extends CustomEventBanner {
    private static final String SLOT_ID_KEY = "slotId";
    private MyTargetView myTargetView;
    private CustomEventBanner.CustomEventBannerListener bannerListener;
    private MyTargetView.MyTargetViewListener myTargetViewListener = new MyTargetView.MyTargetViewListener(){

        @Override
        public void onLoad(MyTargetView myTargetView) {
            myTargetView.start();
            if (MyTargetMopubCustomEventBanner.this.bannerListener != null) {
                MyTargetMopubCustomEventBanner.this.bannerListener.onBannerLoaded((View)myTargetView);
            }
        }

        @Override
        public void onNoAd(String string, MyTargetView myTargetView) {
            if (MyTargetMopubCustomEventBanner.this.bannerListener != null) {
                MyTargetMopubCustomEventBanner.this.bannerListener.onBannerFailed(MoPubErrorCode.NO_FILL);
            }
        }

        @Override
        public void onClick(MyTargetView myTargetView) {
            if (MyTargetMopubCustomEventBanner.this.bannerListener != null) {
                MyTargetMopubCustomEventBanner.this.bannerListener.onBannerClicked();
                MyTargetMopubCustomEventBanner.this.bannerListener.onLeaveApplication();
            }
        }
    };

    protected void loadBanner(Context context, CustomEventBanner.CustomEventBannerListener customEventBannerListener, Map<String, Object> object, Map<String, String> map) {
        if (map.size() == 0 || !map.containsKey(SLOT_ID_KEY)) {
            Tracer.i("Unable to get slotId from parameter json. Probably Admob mediation misconfiguration.");
            if (customEventBannerListener != null) {
                customEventBannerListener.onBannerFailed(MoPubErrorCode.NO_FILL);
            }
            return;
        }
        int n2 = Integer.parseInt(map.get(SLOT_ID_KEY));
        object = MopubCustomParamsFactory.getCustomParams(object);
        this.bannerListener = customEventBannerListener;
        if (this.myTargetView == null) {
            this.myTargetView = new MyTargetView(context);
            this.myTargetView.init(n2, (CustomParams)object, false);
            this.myTargetView.setListener(this.myTargetViewListener);
        }
        this.myTargetView.load();
    }

    protected void onInvalidate() {
        if (this.myTargetView != null) {
            this.myTargetView.destroy();
            this.myTargetView = null;
        }
        this.bannerListener = null;
    }
}

