/*
 * Decompiled with CFR 0.152.
 */
package com.my.target.nativeads.views;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.StateSet;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.my.target.nativeads.NativeAppwallAd;
import com.my.target.nativeads.banners.NativeAppwallBanner;
import com.my.target.nativeads.views.AppwallAdTeaserView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AppwallAdView
extends FrameLayout
implements ViewTreeObserver.OnGlobalLayoutListener,
AbsListView.OnScrollListener,
AdapterView.OnItemClickListener {
    private ViewTreeObserver viewTreeObserver;
    private ListView listView;
    private BannerClickListener bannerClickListener;
    private BannerVisibilityListener bannerVisibilityListener;
    private HashMap<String, Boolean> viewMap = new HashMap();

    public void onScrollStateChanged(AbsListView absListView, int n2) {
    }

    public void onScroll(AbsListView absListView, int n2, int n3, int n4) {
        this.countVisibleBanners();
    }

    public AppwallAdView(Context context) {
        super(context);
        this.initLayout(context);
        this.setVerticalFadingEdgeEnabled(false);
        this.setBackgroundColor(-1);
    }

    private void initLayout(Context context) {
        int n2 = (int)TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
        int n3 = (int)TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
        this.listView = new ListView(context);
        this.listView.setDividerHeight(0);
        this.listView.setVerticalFadingEdgeEnabled(false);
        this.listView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.listView.setOnScrollListener((AbsListView.OnScrollListener)this);
        this.listView.setPadding(0, n2, 0, n3);
        this.listView.setClipToPadding(false);
        this.addView((View)this.listView, -1, -1);
        this.listView.setBackgroundColor(-1118482);
    }

    public void setupView(NativeAppwallAd nativeAppwallAd) {
        this.listView.setAdapter((ListAdapter)new AppwallAdapter(this.getContext(), nativeAppwallAd.getBanners()));
    }

    public void notifyDataSetChanged() {
        if (this.listView != null) {
            ((AppwallAdapter)this.listView.getAdapter()).notifyDataSetChanged();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.countVisibleBanners();
        this.viewTreeObserver = this.getViewTreeObserver();
        if (this.viewTreeObserver.isAlive()) {
            this.viewTreeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
    }

    public void onGlobalLayout() {
        this.countVisibleBanners();
    }

    private void countVisibleBanners() {
        if (this.listView == null || this.listView.getAdapter() == null) {
            return;
        }
        int n2 = this.listView.getLastVisiblePosition();
        ArrayList<NativeAppwallBanner> arrayList = new ArrayList<NativeAppwallBanner>();
        for (int i2 = this.listView.getFirstVisiblePosition(); i2 <= n2; ++i2) {
            NativeAppwallBanner nativeAppwallBanner = (NativeAppwallBanner)this.listView.getAdapter().getItem(i2);
            if (this.viewMap.get(nativeAppwallBanner.getId()) != null) continue;
            arrayList.add(nativeAppwallBanner);
            this.viewMap.put(nativeAppwallBanner.getId(), true);
        }
        if (arrayList.size() > 0 && this.bannerVisibilityListener != null) {
            this.bannerVisibilityListener.onBannersShown(arrayList);
        }
    }

    public void removeBanners() {
        this.listView.setAdapter(null);
        if (this.viewTreeObserver != null && this.viewTreeObserver.isAlive()) {
            this.viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
    }

    public void setBannerVisibilityListener(BannerVisibilityListener bannerVisibilityListener) {
        this.bannerVisibilityListener = bannerVisibilityListener;
    }

    public void setBannerClickListener(BannerClickListener bannerClickListener) {
        this.bannerClickListener = bannerClickListener;
    }

    public void onItemClick(AdapterView<?> object, View view, int n2, long l2) {
        object = (AppwallCardPlaceholder)view;
        if (this.bannerClickListener != null) {
            this.bannerClickListener.onBannerClick(((AppwallCardPlaceholder)((Object)object)).getView());
        }
    }

    public static class AppwallCardPlaceholder
    extends FrameLayout {
        private AppwallAdTeaserView view;
        private LinearLayout rootLayout;

        public AppwallCardPlaceholder(AppwallAdTeaserView appwallAdTeaserView, Context context) {
            super(context);
            this.view = appwallAdTeaserView;
            int n2 = (int)TypedValue.applyDimension((int)1, (float)9.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
            int n3 = (int)TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
            int n4 = (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
            this.rootLayout = new LinearLayout(context);
            this.rootLayout.setOrientation(1);
            this.rootLayout.setBackgroundColor(-1118482);
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
            layoutParams.setMargins(n2, n3, n2, n3);
            appwallAdTeaserView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.rootLayout.addView((View)appwallAdTeaserView);
            if (Build.VERSION.SDK_INT >= 21) {
                appwallAdTeaserView.setElevation(n4);
                context = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{-1, -1});
                GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{-1118482, -1118482});
                StateListDrawable stateListDrawable = new StateListDrawable();
                stateListDrawable.addState(new int[]{16842919}, (Drawable)gradientDrawable);
                stateListDrawable.addState(StateSet.WILD_CARD, (Drawable)context);
                appwallAdTeaserView.setBackground((Drawable)stateListDrawable);
            } else {
                context = new View(context);
                LinearLayout.LayoutParams layoutParams2 = new LinearLayout.LayoutParams(-1, n3);
                Object object = new int[]{-3355444, -1118482};
                object = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, object);
                context.setBackgroundDrawable((Drawable)object);
                context.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
                this.rootLayout.addView((View)context);
                context = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{-1, -1});
                context.setStroke(1, -3355444);
                layoutParams2 = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{-1118482, -1118482});
                layoutParams2.setStroke(1, -3355444);
                StateListDrawable stateListDrawable = new StateListDrawable();
                object = stateListDrawable;
                stateListDrawable.addState(new int[]{16842919}, (Drawable)layoutParams2);
                object.addState(StateSet.WILD_CARD, (Drawable)context);
                appwallAdTeaserView.setBackgroundDrawable((Drawable)object);
                layoutParams.setMargins(0, n3, 0, 0);
                this.rootLayout.setPadding(n2, 0, n2, 0);
            }
            this.addView((View)this.rootLayout, -2, -2);
        }

        public AppwallAdTeaserView getView() {
            return this.view;
        }
    }

    public class AppwallAdapter
    extends ArrayAdapter<NativeAppwallBanner> {
        public AppwallAdapter(Context context, List<NativeAppwallBanner> list) {
            super(context, 0, list);
        }

        public View getView(int n2, View object, ViewGroup viewGroup) {
            NativeAppwallBanner nativeAppwallBanner = (NativeAppwallBanner)this.getItem(n2);
            if (object == null) {
                object = new AppwallAdTeaserView(this.getContext());
                object = new AppwallCardPlaceholder((AppwallAdTeaserView)((Object)object), this.getContext());
            }
            ((AppwallCardPlaceholder)((Object)object)).getView().setNativeAppwallBanner(nativeAppwallBanner);
            return object;
        }
    }

    public static interface BannerClickListener {
        public void onBannerClick(AppwallAdTeaserView var1);
    }

    public static interface BannerVisibilityListener {
        public void onBannersShown(List<NativeAppwallBanner> var1);
    }
}

