/*
 * Decompiled with CFR 0.152.
 */
package com.android.uhflibs;

import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.speedata.libuhf.DeviceControl;
import com.speedata.libuhf.INV_TIME;
import com.speedata.libuhf.IUHFService;
import com.speedata.libuhf.Tag_Data;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class as3992_native
implements IUHFService {
    private int fd;
    private byte[] buf;
    private byte[] lock = new byte[0];
    private boolean read_ok = false;
    private boolean isChecking = false;
    private Handler mHandler = null;
    private static final String TAG = "as3992_native";
    private get_inventoryData_thread mGetInventoryDataThread;
    private DeviceControl deviceControl;
    private ReadThread rthread;
    private byte[] mEpc;

    static {
        System.loadLibrary("package");
        System.loadLibrary("uhfrfid");
    }

    @Override
    public int OpenDev() {
        if (Build.VERSION.RELEASE.equals("4.4.2")) {
            this.deviceControl = new DeviceControl("/sys/class/misc/mtgpio/pin", 64);
        } else if (Build.VERSION.RELEASE.equals("5.1")) {
            String xinghao = Build.MODEL;
            this.deviceControl = xinghao.equals("KT80") || xinghao.equals("W6") || xinghao.equals("N80") ? new DeviceControl("/sys/class/misc/mtgpio/pin", 119) : new DeviceControl("/sys/class/misc/mtgpio/pin", 94);
        }
        if (this.OpenComPort("/dev/ttyMT2") != 0) {
            return -1;
        }
        try {
            this.deviceControl.PowerOnDevice();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    public int OpenComPort(String device) {
        this.fd = this.open_serial(device);
        Log.i((String)TAG, (String)("file is " + this.fd));
        if (this.fd < 0) {
            Log.e((String)TAG, (String)"native open returns null");
            return -1;
        }
        return 0;
    }

    @Override
    public void CloseDev() {
        this.CloseComPort();
        this.deviceControl.PowerOffDevice();
    }

    public void CloseComPort() {
        this.close_serial(this.fd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] get_version(int which) {
        byte[] cmd;
        cmd = new byte[]{16, (byte)cmd.length, (byte)which};
        int reval = this.try_write(this.fd, this.wrap(cmd));
        if (reval < 0) {
            Log.e((String)TAG, (String)"write get_ver cmd failed");
            return null;
        }
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            try {
                this.lock.wait(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.read_ok) {
                this.read_ok = false;
                byte[] res = this.buf;
                Log.i((String)TAG, (String)"get vaild ver data");
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return res;
            }
            Log.e((String)TAG, (String)"time out or no valid ver data");
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read_thread() {
        byte[] head = this.try_read(this.fd, 5, 10);
        if (head == null) {
            return;
        }
        if (head[0] != 2) {
            this.drop_data(this.fd);
            return;
        }
        int lens = this.btoi(head[1]) * 256 + this.btoi(head[2]);
        if (lens - 2 != head[4]) {
            Log.e((String)"as3992_thread", (String)("frame head is " + lens + " and data head is " + head[4] + " not equal"));
            this.drop_data(this.fd);
            return;
        }
        if (head[4] < 3) {
            Log.e((String)"as3992_thread", (String)("wrong data length is " + head[4] + "!!!!!!!!!!!!!!!!!!!!!!"));
            this.drop_data(this.fd);
            return;
        }
        switch (head[3]) {
            case 17: 
            case 25: 
            case 27: 
            case 29: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 72: 
            case 80: 
            case 86: 
            case 88: 
            case 90: {
                Log.d((String)"as3992", (String)"read thread get in sync");
                byte[] tp = this.try_read(this.fd, head[4], 10);
                if (tp == null) {
                    this.drop_data(this.fd);
                    Log.e((String)"as3992", (String)"read valid data failed");
                    return;
                }
                if (tp[tp.length - 2] != 3) {
                    this.drop_data(this.fd);
                    Log.e((String)"as3992", (String)"etx value is not 3");
                    return;
                }
                byte lrc = (byte)(255 + head[3] + head[4]);
                int sl = 0;
                while (sl < tp.length - 1) {
                    lrc = (byte)(lrc + tp[sl]);
                    ++sl;
                }
                if (lrc != tp[tp.length - 1]) {
                    this.drop_data(this.fd);
                    Log.e((String)"as3992", (String)"lrc checksum error");
                    return;
                }
                byte[] byArray = this.lock;
                synchronized (this.lock) {
                    this.buf = new byte[tp.length - 2];
                    System.arraycopy(tp, 0, this.buf, 0, this.buf.length);
                    Log.d((String)"as3992", (String)("read valid data ok, ins is " + head[3]));
                    this.read_ok = true;
                    this.lock.notify();
                    // ** MonitorExit[var5_6] (shouldn't be in output)
                    break;
                }
            }
            default: {
                Log.e((String)"as3992", (String)"get error data");
            }
        }
        {
            Log.d((String)"as3992", (String)"leave success");
            return;
        }
    }

    private int btoi(byte a) {
        return a < 0 ? a + 256 : a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList<Tag_Data> search_card() {
        ArrayList<Tag_Data> cx = new ArrayList<Tag_Data>();
        byte[] cmd = new byte[]{49, 3, 1};
        int card_num = 0;
        int reval = this.try_write(this.fd, this.wrap(cmd));
        if (reval < 0) {
            return null;
        }
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            block10: {
                block9: {
                    do {
                        try {
                            Log.d((String)"as3992", (String)"search begin to wait");
                            this.lock.wait(100L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        if (!this.read_ok || this.buf.length < 2 || this.buf[1] <= 2 || this.buf.length < this.buf[1] + 2) break block9;
                        Log.d((String)"as3992", (String)"search card read ok");
                        this.read_ok = false;
                        if (card_num == 0) {
                            if (this.buf[0] == 0) {
                                Log.e((String)"as3992", (String)"no card found");
                                // ** MonitorExit[var5_5] (shouldn't be in output)
                                return null;
                            }
                            card_num = this.buf[0];
                            Log.d((String)"as3992", (String)"get at last one card");
                        }
                        int epc_length = this.buf[1] - 2;
                        byte[] pc = new byte[2];
                        byte[] epc = new byte[epc_length];
                        System.arraycopy(this.buf, 2, pc, 0, 2);
                        System.arraycopy(this.buf, 4, epc, 0, epc_length);
                        cx.add(new Tag_Data(pc, epc));
                    } while (--card_num > 0);
                    break block10;
                }
                this.read_ok = false;
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return cx;
        }
    }

    @Override
    public void inventory_start() {
        if (this.isChecking) {
            return;
        }
        this.isChecking = true;
        this.rthread = new ReadThread();
        this.rthread.start();
        this.mGetInventoryDataThread = new get_inventoryData_thread();
        this.mGetInventoryDataThread.start();
    }

    @Override
    public void inventory_start(Handler hd) {
        this.reg_handler(hd);
        this.inventory_start();
    }

    @Override
    public void inventory_stop() {
        if (!this.isChecking) {
            return;
        }
        this.isChecking = false;
        this.mGetInventoryDataThread.interrupt();
    }

    @Override
    public byte[] read_area(int area, int addr, int count, int passwd) {
        byte[] res = null;
        do {
            if (this.mEpc != null && this.select_card(this.mEpc) < 0) {
                Log.e((String)"as3992", (String)"read select failed");
                continue;
            }
            res = this.read_area(area, addr, count / 2);
        } while (res == null);
        return res;
    }

    @Override
    public String read_area(int area, String str_addr, String str_count, String str_passwd) {
        long passwd;
        int num_count;
        int num_addr;
        try {
            num_addr = Integer.parseInt(str_addr, 16);
            num_count = Integer.parseInt(str_count, 10);
            passwd = Long.parseLong(str_passwd, 16);
        }
        catch (NumberFormatException p) {
            return null;
        }
        String res = this.read_card(area, num_addr, num_count * 2, (int)passwd);
        return res;
    }

    private String read_card(int area, int addr, int count, int passwd) {
        byte[] v = this.read_area(area, addr, count, passwd);
        if (v == null) {
            return null;
        }
        String j = new String();
        byte[] byArray = v;
        int n = v.length;
        int n2 = 0;
        while (n2 < n) {
            byte i = byArray[n2];
            j = String.valueOf(j) + String.format("%02x ", i);
            ++n2;
        }
        return j;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] read_area(int area, int addr, int count) {
        byte[] cmd = new byte[]{55, 5, (byte)area, (byte)addr, (byte)count};
        int reval = this.try_write(this.fd, this.wrap(cmd));
        if (reval < 0) {
            return null;
        }
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            try {
                this.lock.wait(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (!(!this.read_ok || this.buf[1] <= 0 || this.buf.length <= 1 || count != 0 && this.buf[1] != count || count != 0 && this.buf[0] != 0)) {
                this.read_ok = false;
                Log.i((String)TAG, (String)("readed " + this.buf[1]));
                if (count == 0 && this.buf[1] == 0) {
                    Log.e((String)TAG, (String)"try read more faild");
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                    return null;
                }
                if (this.buf.length < 2 + this.buf[1] * 2) {
                    Log.e((String)TAG, (String)"read_area don't get enough data");
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                    return null;
                }
                byte[] res = new byte[this.buf[1] * 2];
                System.arraycopy(this.buf, 2, res, 0, res.length);
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return res;
            }
            if (this.buf.length >= 2) {
                Log.e((String)"as3992", (String)("read area failed " + this.read_ok + " error " + this.buf[0] + " readed number " + this.buf[1]));
            } else {
                Log.e((String)"as3992", (String)("read area failed " + this.read_ok + " error"));
            }
            this.read_ok = false;
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return null;
        }
    }

    @Override
    public int write_area(int area, int addr, int passwd, byte[] content) {
        byte[] rpaswd = new byte[4];
        int i = 0;
        while (i < 4) {
            rpaswd[i] = (byte)(passwd >>> 24 - i * 8);
            ++i;
        }
        i = -1;
        do {
            if (this.mEpc != null && this.select_card(this.mEpc) < 0) {
                Log.e((String)"as3992", (String)"read select failed");
                continue;
            }
            i = this.write_area(area, addr, content.length / 2, rpaswd, content);
        } while (i == -1);
        return 0;
    }

    @Override
    public int write_area(int area, String addr, String pwd, String count, String content) {
        long passwd;
        int num_count;
        int num_addr;
        try {
            num_addr = Integer.parseInt(addr, 16);
            num_count = Integer.parseInt(count, 10);
            passwd = Long.parseLong(pwd, 16);
        }
        catch (NumberFormatException p) {
            return -3;
        }
        StringTokenizer cn = new StringTokenizer(content);
        if (cn.countTokens() < num_count) {
            return -2;
        }
        byte[] cf = new byte[num_count];
        int index = 0;
        while (cn.hasMoreTokens() && index < num_count) {
            try {
                int k = Integer.parseInt(cn.nextToken(), 16);
                if (k > 255) {
                    throw new NumberFormatException("can't bigger than 0xff");
                }
                cf[index++] = (byte)k;
            }
            catch (NumberFormatException p) {
                return -3;
            }
        }
        return this.write_area(area, num_addr, (int)passwd, cf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int write_area(int area, int addr, int count, byte[] passwd, byte[] content) {
        if (count * 2 != content.length) {
            return -1;
        }
        byte[] cmd = new byte[11];
        cmd[0] = 53;
        cmd[1] = (byte)cmd.length;
        cmd[2] = (byte)area;
        System.arraycopy(passwd, 0, cmd, 4, passwd.length);
        cmd[8] = 1;
        int rts = 0;
        int i = 0;
        while (i < count) {
            cmd[3] = (byte)(addr + i);
            System.arraycopy(content, i * 2, cmd, 9, 2);
            int reval = this.try_write(this.fd, this.wrap(cmd));
            if (reval < 0) {
                return -1;
            }
            byte[] byArray = this.lock;
            // MONITORENTER : this.lock
            try {
                this.lock.wait(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.read_ok && this.buf.length >= 2 && this.buf[0] == 0) {
                this.read_ok = false;
                Log.i((String)TAG, (String)("writed " + this.buf[1] + " words"));
                ++i;
                rts = 0;
            } else {
                if (this.buf.length >= 2) {
                    Log.e((String)TAG, (String)("wrtie area failed " + this.read_ok + " error " + this.buf[0] + " write ok : write number " + this.buf[1]));
                } else {
                    Log.e((String)TAG, (String)("wrtie area failed " + this.read_ok));
                }
                this.read_ok = false;
                if (++rts == 10) {
                    Log.e((String)"as3992_debug", (String)("only write " + i + " words"));
                    // MONITOREXIT : byArray
                    return i;
                }
            }
            // MONITOREXIT : byArray
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int select_card(byte[] epc) {
        this.mEpc = epc;
        byte[] cmd = new byte[3 + epc.length];
        cmd[0] = 51;
        cmd[1] = (byte)cmd.length;
        cmd[2] = (byte)epc.length;
        System.arraycopy(epc, 0, cmd, 3, epc.length);
        int reval = this.try_write(this.fd, this.wrap(cmd));
        if (reval < 0) {
            return -1;
        }
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            block9: {
                try {
                    this.lock.wait(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (!this.read_ok || this.buf.length < 1 || this.buf[0] != 0) break block9;
                this.read_ok = false;
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return 0;
            }
            if (this.buf.length >= 1) {
                Log.e((String)"as3992", (String)("selsect card " + this.read_ok + " error " + this.buf[0]));
            } else {
                Log.e((String)"as3992", (String)("selsect card " + this.read_ok));
            }
            this.read_ok = false;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return -1;
        }
    }

    @Override
    public int select_card(String epc) {
        int select_card;
        StringTokenizer sepc = new StringTokenizer(epc);
        byte[] eepc = new byte[sepc.countTokens()];
        int index = 0;
        while (sepc.hasMoreTokens()) {
            try {
                eepc[index++] = (byte)Integer.parseInt(sepc.nextToken(), 16);
            }
            catch (NumberFormatException p) {
                return -1;
            }
        }
        int i = 0;
        while ((select_card = this.select_card(eepc)) != 0 && ++i < 5) {
        }
        if (select_card != 0) {
            return -1;
        }
        return 0;
    }

    @Override
    public int set_Password(int which, String cur_pass, String new_pass) {
        if (which > 1 || which < 0) {
            return -1;
        }
        try {
            long cp = Long.parseLong(cur_pass, 16);
            if (cp > 0xFFFFFFFFL || cp < 0L) {
                throw new NumberFormatException("can't bigger than 0xffffffff");
            }
            long np = Long.parseLong(new_pass, 16);
            if (np > 0xFFFFFFFFL || np < 0L) {
                throw new NumberFormatException("can't bigger than 0xffffffff");
            }
            byte[] nps = new byte[4];
            nps[3] = (byte)(np >> 0 & 0xFFL);
            nps[2] = (byte)(np >> 8 & 0xFFL);
            nps[1] = (byte)(np >> 16 & 0xFFL);
            nps[0] = (byte)(np >> 24 & 0xFFL);
            return this.write_area(0, which * 2, (int)cp, nps);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    @Override
    public int set_antenna_power(int power) {
        int i = power == 0 ? this.set_antenna_power(false) : this.set_antenna_power(true);
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_antenna_power(boolean power) {
        byte[] cmd;
        cmd = new byte[]{24, (byte)cmd.length, (byte)(power ? 255 : 0)};
        int reval = this.try_write(this.fd, this.wrap(cmd));
        if (reval < 0) {
            return -1;
        }
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            block7: {
                try {
                    this.lock.wait(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (!this.read_ok) break block7;
                this.read_ok = false;
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return 0;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return -1;
        }
    }

    @Override
    public int get_antenna_power() {
        return -1;
    }

    @Override
    public int set_freq_region(int region) {
        int result = -1;
        int time = 0;
        do {
            switch (region) {
                case 0: {
                    result = this.set_freq(840125, 844875, 250, -40, 0);
                    break;
                }
                case 1: {
                    result = this.set_freq(920625, 924375, 750, -40, 0);
                    break;
                }
                case 2: {
                    result = this.set_freq(902750, 927250, 500, -40, 0);
                    break;
                }
                case 3: {
                    result = this.set_freq(865700, 867500, 600, -40, 0);
                }
            }
        } while (result != 0 && ++time < 15);
        if (result != 0) {
            return -1;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int set_freq(int start, int stop, int increment, int rssi, int id) {
        if (increment <= 0) {
            Log.e((String)"as3993", (String)"inc value can't be 0");
            return -1;
        }
        int mode = 8;
        byte[] cmd = new byte[8];
        cmd[0] = 65;
        cmd[1] = (byte)cmd.length;
        cmd[6] = (byte)rssi;
        cmd[7] = (byte)id;
        int freq = start;
        while (freq <= stop) {
            block10: {
                cmd[2] = mode;
                cmd[3] = (byte)freq;
                cmd[4] = (byte)(freq >> 8);
                cmd[5] = (byte)(freq >> 16);
                int reval = this.try_write(this.fd, this.wrap(cmd));
                if (reval < 0) {
                    Log.e((String)"as3992", (String)("write set freq cmd failed in " + freq));
                    return -1;
                }
                byte[] byArray = this.lock;
                // MONITORENTER : this.lock
                try {
                    this.lock.wait(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (this.read_ok && this.buf.length >= 1 && this.buf[0] != 0) {
                    Log.d((String)"as3992", (String)("set freq " + freq + " ok"));
                    this.read_ok = false;
                    // MONITOREXIT : byArray
                    break block10;
                }
                Log.e((String)"as3992", (String)("set freq failed or wait too long time " + freq));
                if (this.buf != null && this.buf.length >= 1 && this.buf[0] == 0) {
                    Log.e((String)"as3992", (String)"freq list is full");
                    // MONITOREXIT : byArray
                    return -2;
                }
                this.read_ok = false;
                // MONITOREXIT : byArray
                return -1;
            }
            mode = 4;
            freq += increment;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Freq_Msg get_freq() {
        byte[] cmd = new byte[]{65, 3, 17};
        int reval = this.try_write(this.fd, this.wrap(cmd));
        if (reval < 0) {
            Log.e((String)"as3992", (String)"write get freq cmd failed");
            return null;
        }
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            try {
                this.lock.wait(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.read_ok && this.buf.length >= 18) {
                Log.d((String)"as3992", (String)"get freq ok");
                Log.i((String)"as3392_native", (String)("number of freq " + this.buf[15]));
                int start = this.btoi(this.buf[9]) + (this.btoi(this.buf[10]) << 8) + (this.btoi(this.buf[11]) << 16);
                int stop = this.btoi(this.buf[12]) + (this.btoi(this.buf[13]) << 8) + (this.btoi(this.buf[14]) << 16);
                int inc = this.btoi(this.buf[15]) == 1 ? 0 : (stop - start) / (this.btoi(this.buf[15]) - 1);
                byte rssi = this.buf[16];
                byte id = this.buf[2];
                int listentime = this.btoi(this.buf[3]) + (this.btoi(this.buf[4]) << 8);
                int allocationtime = this.btoi(this.buf[5]) + (this.btoi(this.buf[6]) << 8);
                int idletime = this.btoi(this.buf[7]) + (this.btoi(this.buf[8]) << 8);
                Log.i((String)"as3992_natvie", (String)("start " + start + " stop " + stop + " inc " + inc + " rssi " + rssi + " listen " + listentime + " alloc " + allocationtime + " idle " + idletime));
                this.read_ok = false;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return new Freq_Msg(start, stop, inc, rssi, id, listentime, allocationtime, idletime);
            }
            Log.e((String)"as3992", (String)("get freq failed " + this.read_ok + " buflength " + this.buf.length));
            this.read_ok = false;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return null;
        }
    }

    @Override
    public int get_freq_region() {
        Freq_Msg res = this.get_freq();
        if (res == null) {
            return -1;
        }
        if (res.start == 840125) {
            return 0;
        }
        if (res.start == 920625) {
            return 1;
        }
        if (res.start == 902750) {
            return 2;
        }
        if (res.start == 865700) {
            return 3;
        }
        return -1;
    }

    @Override
    public void reg_handler(Handler hd) {
        this.mHandler = hd;
    }

    @Override
    public INV_TIME get_inventory_time() {
        return null;
    }

    @Override
    public int set_inventory_time(int work_t, int rest_t) {
        return 0;
    }

    @Override
    public int MakeSetValid() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setlock(byte type, byte area, byte[] passwd) {
        byte[] cmd = new byte[8];
        cmd[0] = 59;
        cmd[1] = (byte)cmd.length;
        cmd[2] = type;
        cmd[3] = area;
        System.arraycopy(passwd, 0, cmd, 4, 4);
        int reval = this.try_write(this.fd, this.wrap(cmd));
        if (reval < 0) {
            return -1;
        }
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            block9: {
                try {
                    this.lock.wait(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (!this.read_ok || this.buf.length < 1 || this.buf[0] != 0) break block9;
                this.read_ok = false;
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return 0;
            }
            if (this.buf.length >= 1) {
                Log.e((String)"as3992", (String)("lock card failed " + this.read_ok + " error " + this.buf[0]));
            } else {
                Log.e((String)"as3992", (String)("lock card failed " + this.read_ok));
            }
            this.read_ok = false;
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return -1;
        }
    }

    @Override
    public int setlock(int type, int area, int passwd) {
        byte[] rpaswd = new byte[4];
        int i = 0;
        while (i < 4) {
            rpaswd[i] = (byte)(passwd >>> 24 - i * 8);
            ++i;
        }
        int setlock = this.setlock((byte)type, (byte)area, rpaswd);
        return setlock;
    }

    private byte[] wrap(byte[] in) {
        byte[] res = new byte[in.length + 5];
        res[0] = 2;
        res[1] = (byte)(in.length + 2 >> 8);
        res[2] = (byte)(in.length + 2);
        System.arraycopy(in, 0, res, 3, in.length);
        res[3 + in.length] = 3;
        int cc = -1;
        int i = 0;
        while (i < in.length) {
            cc = (byte)(cc + in[i]);
            ++i;
        }
        res[4 + in.length] = cc = (int)((byte)(cc + 3));
        return res;
    }

    @Override
    public int get_inventory_mode() {
        return 0;
    }

    @Override
    public int set_inventory_mode(int m) {
        return 0;
    }

    private native int open_serial(String var1);

    private native void close_serial(int var1);

    private native int try_write(int var1, byte[] var2);

    private native byte[] try_read(int var1, int var2, int var3);

    private native void drop_data(int var1);

    public class Freq_Msg {
        public int start;
        public int stop;
        public int inc;
        public int rssi;
        public int id;
        public int listentime;
        public int allocationtime;
        public int idletime;

        Freq_Msg(int n_start, int n_stop, int n_inc, int n_rssi, int n_id, int n_listentime, int n_allocationtime, int n_idletime) {
            this.start = n_start;
            this.stop = n_stop;
            this.inc = n_inc;
            this.rssi = n_rssi;
            this.id = n_id;
            this.listentime = n_listentime;
            this.allocationtime = n_allocationtime;
            this.idletime = n_idletime;
        }
    }

    class ReadThread
    extends Thread {
        ReadThread() {
        }

        @Override
        public void run() {
            super.run();
            while (!this.isInterrupted()) {
                as3992_native.this.read_thread();
            }
        }
    }

    private class get_inventoryData_thread
    extends Thread {
        private get_inventoryData_thread() {
        }

        @Override
        public void run() {
            super.run();
            while (as3992_native.this.isChecking) {
                Message msg = new Message();
                ArrayList<Tag_Data> tg = as3992_native.this.search_card();
                if (tg == null) continue;
                msg.what = 1;
                msg.obj = tg;
                as3992_native.this.mHandler.sendMessage(msg);
            }
        }
    }
}

