/*
 * Decompiled with CFR 0.152.
 */
package com.speedata.libuhf;

import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.speedata.libuhf.INV_TIME;
import com.speedata.libuhf.IUHFService;
import com.speedata.libuhf.Single_Inventory_Time_Config;
import com.speedata.libuhf.Tag_Data;
import com.uhf_sdk.linkage.Linkage;
import com.uhf_sdk.model.Inventory_Data;
import com.uhf_sdk.model.Value_c;
import com.uhf_sdk.uhfpower.UhfPowaer;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;

public class FLX_QiLian
implements IUHFService {
    private static String TAG = "FLX_QiLian";
    private Handler mHandler = null;
    private boolean isChecking = false;
    private static UhfPowaer sUhfPowaer;
    public static int open_Com;
    private inventory_command_thread mInventoryCommandThread = null;
    private get_inventoryData_thread mGetInventoryDataThread;
    private Timer timer = new Timer(true);
    private MyTimerTask task;
    private static final int KILL_PASSWORD_AREA = 0;
    private static final int ACCESS_PASSWORD_AREA = 1;
    private static final int EPC_AREA = 2;
    private static final int TID_AREA = 3;
    private static final int USER_AREA = 4;

    static {
        open_Com = 0;
    }

    @Override
    public int OpenDev() {
        if (Build.VERSION.RELEASE.equals("4.4.2")) {
            sUhfPowaer = new UhfPowaer("/sys/class/misc/mtgpio/pin", 64);
        } else if (Build.VERSION.RELEASE.equals("5.1")) {
            String xinghao = Build.MODEL;
            sUhfPowaer = xinghao.equals("KT80") || xinghao.equals("W6") || xinghao.equals("N80") ? new UhfPowaer("/sys/class/misc/mtgpio/pin", 119) : (xinghao.equals("KT55") ? new UhfPowaer("/sys/class/misc/mtgpio/pin", 88) : new UhfPowaer("/sys/class/misc/mtgpio/pin", 94));
        }
        try {
            sUhfPowaer.PowerOffDevice();
            sUhfPowaer.PowerOnDevice();
            Thread.sleep(400L);
            open_Com = Linkage.open_Serial((String)"/dev/ttyMT2");
            if (open_Com > 0) {
                Log.i((String)TAG, (String)("-----open_Com-----" + open_Com));
                return 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return -1;
    }

    @Override
    public void CloseDev() {
        Linkage.close_Serial((int)open_Com);
        sUhfPowaer.PowerOffDevice();
    }

    @Override
    public void inventory_start() {
        if (this.isChecking) {
            return;
        }
        this.isChecking = true;
        this.mInventoryCommandThread = new inventory_command_thread();
        this.mInventoryCommandThread.start();
        this.mGetInventoryDataThread = new get_inventoryData_thread();
        this.mGetInventoryDataThread.start();
        if (this.timer != null) {
            if (this.task != null) {
                this.task.cancel();
            }
            this.task = new MyTimerTask();
            this.timer.schedule((TimerTask)this.task, 600000L, 600000L);
        }
    }

    @Override
    public void inventory_start(Handler hd) {
        this.reg_handler(hd);
        this.inventory_start();
    }

    @Override
    public void inventory_stop() {
        if (!this.isChecking) {
            return;
        }
        this.isChecking = false;
        this.mGetInventoryDataThread.interrupt();
        this.mInventoryCommandThread.interrupt();
        Linkage.inventory_Stop((int)open_Com);
    }

    private ArrayList<Tag_Data> get_inventory_data() {
        ArrayList<Tag_Data> tagData = new ArrayList<Tag_Data>();
        Inventory_Data[] stInvData = new Inventory_Data[512];
        int num = Linkage.inventory_Data((int)open_Com, (Inventory_Data[])stInvData);
        if (num > 0) {
            int i = 0;
            while (i < num) {
                if (stInvData[i].getEPC_len() > 0 && stInvData[i].getEPC_len() < 80) {
                    byte[] n_epc_result = new byte[stInvData[i].getEPC_len()];
                    byte[] n_epc = stInvData[i].getEPC_Data();
                    int j = 0;
                    while (j < n_epc_result.length) {
                        n_epc_result[j] = n_epc[j];
                        ++j;
                    }
                    tagData.add(new Tag_Data(null, n_epc_result));
                }
                ++i;
            }
            return tagData;
        }
        return null;
    }

    @Override
    public byte[] read_area(int area, int addr, int count, int passwd) {
        Value_c result = new Value_c();
        if (area > 4 || area < 0) {
            return null;
        }
        char[] access_password = this.getCharsPassword(passwd);
        char[] ReadText = Linkage.read_Label((int)open_Com, (int)area, (int)addr, (int)(count / 2), (char[])access_password, (Value_c)result);
        if (ReadText != null && result.value == 0) {
            Log.i((String)TAG, (String)("--------ReadText \u539f\u59cb--------" + Linkage.c2hexs((char[])ReadText, (int)ReadText.length)));
            return FLX_QiLian.charToByte(ReadText, ReadText.length);
        }
        return null;
    }

    @Override
    public String read_area(int area, String str_addr, String str_count, String str_passwd) {
        long passwd;
        int num_count;
        int num_addr;
        try {
            num_addr = Integer.parseInt(str_addr, 16);
            num_count = Integer.parseInt(str_count, 10);
            passwd = Long.parseLong(str_passwd);
        }
        catch (NumberFormatException p) {
            return null;
        }
        String res = this.read_card(area, num_addr, num_count * 2, (int)passwd);
        return res;
    }

    private String read_card(int area, int addr, int count, int passwd) {
        byte[] v = this.read_area(area, addr, count, passwd);
        if (v == null) {
            return null;
        }
        String j = new String();
        byte[] byArray = v;
        int n = v.length;
        int n2 = 0;
        while (n2 < n) {
            byte i = byArray[n2];
            j = String.valueOf(j) + String.format("%02x ", i);
            ++n2;
        }
        return j;
    }

    private static char[] byteToChar(byte[] data, int length) {
        if (length % 2 == 0) {
            char[] chars = new char[length / 4];
            int i = 0;
            while (i < chars.length) {
                chars[i] = (char)((data[i * 4] & 0xF) << 12 | (data[i * 4 + 1] & 0xF) << 8 | (data[i * 4 + 2] & 0xF) << 4 | data[i * 4 + 3] & 0xF);
                ++i;
            }
            return chars;
        }
        return null;
    }

    private static byte[] charToByte(char[] data, int length) {
        byte[] bytes = new byte[2 * length];
        int i = 0;
        while (i < length) {
            bytes[2 * i] = (byte)(data[i] >> 8);
            bytes[2 * i + 1] = (byte)data[i];
            ++i;
        }
        return bytes;
    }

    @Override
    public int write_area(int area, int addr, int passwd, byte[] content) {
        if (content.length % 2 != 0) {
            return -3;
        }
        int result = -1;
        if (area >= 0 && area <= 3) {
            char[] access_password = this.getCharsPassword(passwd);
            if (access_password.length % 2 != 0) {
                return -2;
            }
            result = Linkage.write_Label((int)open_Com, (int)area, (int)addr, (int)(content.length / 4), (char[])FLX_QiLian.byteToChar(content, content.length), (char[])access_password);
        }
        return result;
    }

    @Override
    public int write_area(int area, String addr, String pwd, String count, String content) {
        long passwd;
        int num_count;
        int num_addr;
        try {
            num_addr = Integer.parseInt(addr, 16);
            num_count = Integer.parseInt(count, 10);
            passwd = Long.parseLong(pwd);
        }
        catch (NumberFormatException p) {
            return -3;
        }
        int rev = this.write_card(area, num_addr, num_count * 2, (int)passwd, content);
        return rev;
    }

    private int write_card(int area, int addr, int count, int passwd, String cnt) {
        byte[] cf = this.getBytes(cnt);
        return this.write_area(area, addr, passwd, cf);
    }

    private byte[] getBytes(String data) {
        String newData = data.trim().replace(" ", "");
        byte[] datas = new byte[newData.length()];
        int i = 0;
        while (i < datas.length) {
            datas[i] = Byte.parseByte(newData.substring(i, i + 1), 16);
            ++i;
        }
        return datas;
    }

    private char[] getCharsPassword(int passwd) {
        char[] access_password = passwd == 0 ? new char[]{(char)(passwd / 0x1000000 % 256), (char)(passwd / 65536 % 256), (char)(passwd / 256 % 256), (char)(passwd % 256)} : Linkage.s2char((String)("" + passwd));
        return access_password;
    }

    @Override
    public int select_card(byte[] epc) {
        int epc_area = 1;
        int epc_lenght = epc.length / 4;
        int epc_add = 2;
        int mask_sel = 0;
        int mask_session = 0;
        if (epc.length > 0) {
            return Linkage.set_Mask((int)open_Com, (int)mask_sel, (int)mask_session, (int)epc_area, (int)epc_add, (int)epc_lenght, (char[])FLX_QiLian.byteToChar(epc, epc.length));
        }
        return -1;
    }

    @Override
    public int select_card(String epc) {
        byte[] eepc = this.getBytes(epc);
        if (this.select_card(eepc) != 0) {
            return -1;
        }
        return 0;
    }

    @Override
    public int set_Password(int which, String cur_pass, String new_pass) {
        if (which > 1 || which < 0) {
            return -1;
        }
        long cp = Long.parseLong(cur_pass);
        byte[] nps = this.getBytes(new_pass);
        return this.write_area(0, which * 2, (int)cp, nps);
    }

    @Override
    public int set_antenna_power(int power) {
        int iu32 = power * 100;
        return Linkage.set_Power((int)open_Com, (int)iu32);
    }

    @Override
    public int get_antenna_power() {
        Value_c value_c = new Value_c();
        int power_value = Linkage.get_Power((int)open_Com, (Value_c)value_c);
        if (value_c.value == 0) {
            return power_value / 100;
        }
        return -1;
    }

    @Override
    public INV_TIME get_inventory_time() {
        Single_Inventory_Time_Config t = new Single_Inventory_Time_Config();
        return new INV_TIME(t.iWorkTime, t.iRestTime);
    }

    @Override
    public int set_inventory_time(int work_t, int rest_t) {
        Single_Inventory_Time_Config t = new Single_Inventory_Time_Config(work_t, rest_t);
        return 0;
    }

    @Override
    public int MakeSetValid() {
        return 0;
    }

    @Override
    public int get_inventory_mode() {
        return -1;
    }

    @Override
    public int set_inventory_mode(int m) {
        return -1;
    }

    @Override
    public int set_freq_region(int region) {
        Linkage.RFID_18K6C_COUNTRY_REGION region_ql = null;
        switch (region) {
            case 0: {
                region_ql = Linkage.RFID_18K6C_COUNTRY_REGION.China840_845;
                break;
            }
            case 1: {
                region_ql = Linkage.RFID_18K6C_COUNTRY_REGION.China920_925;
                break;
            }
            case 2: {
                return -1;
            }
            case 3: {
                region_ql = Linkage.RFID_18K6C_COUNTRY_REGION.Europe_Area;
            }
        }
        return Linkage.set_Region((int)open_Com, (Linkage.RFID_18K6C_COUNTRY_REGION)region_ql);
    }

    @Override
    public int get_freq_region() {
        return -1;
    }

    @Override
    public void reg_handler(Handler hd) {
        this.mHandler = hd;
    }

    @Override
    public int setlock(int type, int area, int passwd) {
        int lock_statue = 0;
        if (type < 0 || type > 3 || area < 0 || area > 4) {
            return -1;
        }
        int newType = -1;
        if (type == 0) {
            newType = 0;
        }
        if (type == 1) {
            newType = 2;
        }
        if (type == 2) {
            newType = 1;
        }
        if (type == 3) {
            newType = 3;
        }
        char[] access_password = this.getCharsPassword(passwd);
        switch (area) {
            case 0: {
                lock_statue = Linkage.lock_Label((int)open_Com, (char[])access_password, (int)1, (int)newType, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0);
                break;
            }
            case 1: {
                lock_statue = Linkage.lock_Label((int)open_Com, (char[])access_password, (int)0, (int)0, (int)1, (int)newType, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0);
                break;
            }
            case 2: {
                lock_statue = Linkage.lock_Label((int)open_Com, (char[])access_password, (int)0, (int)0, (int)0, (int)0, (int)1, (int)newType, (int)0, (int)0, (int)0, (int)0);
                break;
            }
            case 3: {
                lock_statue = Linkage.lock_Label((int)open_Com, (char[])access_password, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)1, (int)newType, (int)0, (int)0);
                break;
            }
            case 4: {
                lock_statue = Linkage.lock_Label((int)open_Com, (char[])access_password, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)1, (int)newType);
            }
        }
        Log.i((String)"lei", (String)("------------lock_statue=" + lock_statue));
        if (lock_statue != 0) {
            return -1;
        }
        return lock_statue;
    }

    public int setkill(int ap, int kp) {
        char[] kill_password = new char[]{(char)(kp / 0x1000000 % 256), (char)(kp / 65536 % 256), (char)(kp / 256 % 256), (char)(kp % 256)};
        int kill_status = Linkage.kill_Label((int)open_Com, (char[])kill_password);
        if (kill_status != 0) {
            return -1;
        }
        return kill_status;
    }

    private class MyTimerTask
    extends TimerTask {
        private MyTimerTask() {
        }

        @Override
        public void run() {
            Linkage.inventory_Start((int)open_Com);
        }
    }

    private class get_inventoryData_thread
    extends Thread {
        private get_inventoryData_thread() {
        }

        @Override
        public void run() {
            super.run();
            while (FLX_QiLian.this.isChecking) {
                Message msg = new Message();
                ArrayList tg = FLX_QiLian.this.get_inventory_data();
                if (tg == null) continue;
                msg.what = 1;
                msg.obj = tg;
                FLX_QiLian.this.mHandler.sendMessage(msg);
            }
        }
    }

    private class inventory_command_thread
    extends Thread {
        private inventory_command_thread() {
        }

        @Override
        public void run() {
            super.run();
            Linkage.inventory_Start((int)open_Com);
        }
    }
}

