/*
 * Decompiled with CFR 0.152.
 */
package com.speedata.libuhf;

import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.speedata.libuhf.DeviceControl;
import com.speedata.libuhf.INV_TIME;
import com.speedata.libuhf.IUHFService;
import com.speedata.libuhf.Tag_Data;
import com.uhf.constants.Constants;
import com.uhf.linkage.Linkage;
import com.uhf.structures.DynamicQParms;
import com.uhf.structures.FixedQParms;
import com.uhf.structures.Rfid_Value;
import com.uhf.structures.Rfid_dValue;
import com.uhf.structures.SelectCriteria;
import com.uhf.structures.Single_Inventory_Time_Config;
import com.uhf.structures.St_Inv_Data;
import com.uhf.structures.TagGroup;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class R2K
implements IUHFService {
    private static final String TAG = "r2000_native";
    private Linkage lk = new Linkage();
    private Handler h = null;
    private boolean inSearch = false;
    private inv_thread invs = null;
    private get_invdata gd;
    private DeviceControl pw;
    public static final int KILL_PW_L = 0;
    public static final int ACCESS_PW_L = 1;
    public static final int EPC_L = 2;
    public static final int TID_L = 3;
    public static final int USER_L = 4;
    public static final int UNLOCK = 0;
    public static final int LOCK = 1;
    public static final int P_UNLOCK = 2;
    public static final int P_LOCK = 3;
    private static final int[] vp = new int[]{Constants.RFID_18K6C_TAG_PWD_PERM.ACCESSIBLE.getValue(), Constants.RFID_18K6C_TAG_PWD_PERM.SECURED_ACCESSIBLE.getValue(), Constants.RFID_18K6C_TAG_PWD_PERM.ALWAYS_ACCESSIBLE.getValue(), Constants.RFID_18K6C_TAG_PWD_PERM.ALWAYS_NOT_ACCESSIBLE.getValue()};
    private static final int[] va = new int[]{Constants.RFID_18K6C_TAG_MEM_PERM.WRITEABLE.getValue(), Constants.RFID_18K6C_TAG_MEM_PERM.SECURED_WRITEABLE.getValue(), Constants.RFID_18K6C_TAG_MEM_PERM.ALWAYS_WRITEABLE.getValue(), Constants.RFID_18K6C_TAG_MEM_PERM.ALWAYS_NOT_WRITEABLE.getValue()};
    public static final int ANTENNA_P_MIN = 0;
    public static final int ANTENNA_P_MAX = 30;
    public static final int DSB_ASK_M0_40KHZ = 0;
    public static final int PR_ASK_M2_250KHZ = 1;
    public static final int PR_ASK_M2_300KHZ = 2;
    public static final int DSB_ASK_M0_400KHZ = 3;

    @Override
    public void reg_handler(Handler hd) {
        this.h = hd;
    }

    @Override
    public int OpenDev() {
        if (Build.VERSION.RELEASE.equals("4.4.2")) {
            this.pw = new DeviceControl("/sys/class/misc/mtgpio/pin", 64);
        } else if (Build.VERSION.RELEASE.equals("5.1")) {
            String xinghao = Build.MODEL;
            this.pw = xinghao.equals("KT80") || xinghao.equals("W6") || xinghao.equals("N80") ? new DeviceControl("/sys/class/misc/mtgpio/pin", 119) : (xinghao.equals("KT55") ? new DeviceControl("/sys/class/misc/mtgpio/pin", 88) : new DeviceControl("/sys/class/misc/mtgpio/pin", 94));
        }
        this.pw.PowerOffDevice();
        int fd = this.pw.PowerOnDevice();
        if (fd != 0) {
            Log.e((String)"r2000_kt45", (String)"power on returns null");
            return -1;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Log.d((String)"r2000_kt45", (String)"power ok");
        fd = this.lk.Radio_Initialization();
        if (fd != Constants.Result.RFID_STATUS_OK.getValue()) {
            Log.e((String)"r2000_kt45", (String)"native open returns null");
            this.pw.PowerOffDevice();
            return -1;
        }
        Log.d((String)"r2000_kt45", (String)"init ok");
        fd = this.lk.open_serial("/dev/ttyMT2");
        if (fd != Constants.Result.RFID_STATUS_OK.getValue()) {
            Log.e((String)"r2000_kt45", (String)"open serial port returns null");
            this.pw.PowerOffDevice();
        }
        Log.d((String)"r2000_kt45", (String)"serial ok");
        return 0;
    }

    @Override
    public void CloseDev() {
        this.lk.close_serial();
        this.lk.DestroyRadioFuncIntegration();
        this.pw.PowerOffDevice();
    }

    private int btoi(byte a) {
        return a < 0 ? a + 256 : a;
    }

    @Override
    public int set_inventory_mode(int m) {
        int res = Constants.Result.RFID_ERROR_FAILURE.getValue();
        if (m >= 0 && m <= 3) {
            switch (m) {
                case 0: {
                    res = this.lk.Radio_SetInvMode(Constants.InvMode.HighSpeedMode);
                    break;
                }
                case 1: {
                    res = this.lk.Radio_SetInvMode(Constants.InvMode.IntelligentMode);
                    break;
                }
                case 2: {
                    res = this.lk.Radio_SetInvMode(Constants.InvMode.LowPowerMode);
                    break;
                }
                case 3: {
                    res = this.lk.Radio_SetInvMode(Constants.InvMode.UserDefined);
                }
            }
        }
        if (res != Constants.Result.RFID_STATUS_OK.getValue()) {
            return -1;
        }
        return 0;
    }

    @Override
    public int get_inventory_mode() {
        Rfid_Value res = new Rfid_Value();
        int m = this.lk.Radio_GetInvMode(res);
        if (m != Constants.Result.RFID_STATUS_OK.getValue()) {
            return -1;
        }
        if (res.value == Constants.InvMode.HighSpeedMode.getValue()) {
            return 0;
        }
        if (res.value == Constants.InvMode.IntelligentMode.getValue()) {
            return 1;
        }
        if (res.value == Constants.InvMode.LowPowerMode.getValue()) {
            return 2;
        }
        if (res.value == Constants.InvMode.UserDefined.getValue()) {
            return 3;
        }
        return -1;
    }

    @Override
    public void inventory_start() {
        if (this.inSearch) {
            return;
        }
        this.inSearch = true;
        this.invs = new inv_thread();
        this.invs.start();
        this.gd = new get_invdata();
        this.gd.start();
    }

    @Override
    public void inventory_start(Handler hd) {
        this.reg_handler(hd);
        this.inventory_start();
    }

    @Override
    public void inventory_stop() {
        if (!this.inSearch) {
            return;
        }
        this.inSearch = false;
        this.gd.interrupt();
        this.invs.interrupt();
        this.lk.CancelOperation();
    }

    @Override
    public int setlock(int type, int area, int passwd) {
        int kp = Constants.RFID_18K6C_TAG_PWD_PERM.NO_CHANGE.getValue();
        int ap = Constants.RFID_18K6C_TAG_PWD_PERM.NO_CHANGE.getValue();
        int ta = Constants.RFID_18K6C_TAG_MEM_PERM.NO_CHANGE.getValue();
        int ea = Constants.RFID_18K6C_TAG_MEM_PERM.NO_CHANGE.getValue();
        int ua = Constants.RFID_18K6C_TAG_MEM_PERM.NO_CHANGE.getValue();
        int res = Constants.Result.RFID_ERROR_FAILURE.getValue();
        if (type >= 0 && type <= 3 && area >= 0 && area <= 4) {
            switch (area) {
                case 0: {
                    kp = vp[type];
                    break;
                }
                case 1: {
                    ap = vp[type];
                    break;
                }
                case 2: {
                    ea = va[type];
                    break;
                }
                case 3: {
                    ta = va[type];
                    break;
                }
                case 4: {
                    ua = va[type];
                }
            }
            res = this.lk.Radio_LockTag((long)passwd, (long)ap, (long)kp, ea, ta, ua, 1);
        }
        if (res != Constants.Result.RFID_STATUS_OK.getValue()) {
            return -1;
        }
        return 0;
    }

    public int setkill(int ap, int kp) {
        int res = this.lk.Radio_KillTag((long)ap, (long)kp, 1);
        if (res != Constants.Result.RFID_STATUS_OK.getValue()) {
            return -1;
        }
        return 0;
    }

    private ArrayList<Tag_Data> get_inventory_data() {
        ArrayList<Tag_Data> cx = new ArrayList<Tag_Data>();
        St_Inv_Data[] arg0 = new St_Inv_Data[512];
        int sn = this.lk.GetInvData(arg0);
        if (sn > 0 && arg0 != null) {
            Log.d((String)"r2000_kt45", (String)("get " + sn + " cards " + "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"));
            int i = 0;
            while (i < sn) {
                Log.e((String)"r2000_kt45", (String)("epc leng is " + arg0[i].nLength + " tid leng is " + arg0[i].tidLength));
                if (arg0[i].nLength > 0 && arg0[i].nLength < 66) {
                    byte[] n_tid;
                    byte[] n_epc = new byte[arg0[i].nLength];
                    System.arraycopy(arg0[i].INV_Data, 0, n_epc, 0, n_epc.length);
                    if (arg0[i].tidLength == 12) {
                        n_tid = new byte[arg0[i].tidLength];
                        System.arraycopy(arg0[i].TID_Data, 0, n_tid, 0, n_tid.length);
                    } else {
                        n_tid = null;
                    }
                    cx.add(new Tag_Data(n_tid, n_epc));
                }
                ++i;
            }
            return cx;
        }
        return null;
    }

    public int inventory_show_tid(boolean b) {
        int res = b ? this.lk.Radio_SetInvTagArea(Constants.RFID_INVENTORY_TAG_AREA.RFID_INVENTORY_TAG_TID) : this.lk.Radio_SetInvTagArea(Constants.RFID_INVENTORY_TAG_AREA.RFID_INVENTORY_TAG_EPC);
        if (res != Constants.Result.RFID_STATUS_OK.getValue()) {
            return -1;
        }
        return 0;
    }

    @Override
    public int set_inventory_time(int work_t, int rest_t) {
        Single_Inventory_Time_Config t = new Single_Inventory_Time_Config(work_t, rest_t);
        int res = this.lk.Radio_SetSingleInvTimeConfig(t);
        if (res != Constants.Result.RFID_STATUS_OK.getValue()) {
            return -1;
        }
        return 0;
    }

    @Override
    public INV_TIME get_inventory_time() {
        Single_Inventory_Time_Config t = new Single_Inventory_Time_Config();
        int res = this.lk.Radio_GetSingleInvTimeConfig(t);
        if (res != Constants.Result.RFID_STATUS_OK.getValue()) {
            return null;
        }
        return new INV_TIME(t.iWorkTime, t.iRestTime);
    }

    @Override
    public byte[] read_area(int area, int addr, int count, int passwd) {
        Rfid_Value res = new Rfid_Value();
        if (area > 3 || area < 0 || count % 2 != 0) {
            return null;
        }
        int bk = 3;
        switch (area) {
            case 0: {
                bk = Constants.MemoryBank.RESERVED.getValue();
                break;
            }
            case 1: {
                bk = Constants.MemoryBank.EPC.getValue();
                break;
            }
            case 2: {
                bk = Constants.MemoryBank.TID.getValue();
                break;
            }
            case 3: {
                bk = Constants.MemoryBank.USER.getValue();
            }
        }
        char[] kn = this.lk.Radio_ReadTag(count / 2, addr, bk, (long)passwd, res, 1);
        if (res.value == Constants.Result.RFID_STATUS_OK.getValue() && kn != null) {
            byte[] s = new byte[count];
            int i = 0;
            while (i < count / 2) {
                s[i * 2 + 1] = (byte)(kn[i] & 0xFF);
                s[i * 2] = (byte)(kn[i] >> 8 & 0xFF);
                ++i;
            }
            return s;
        }
        Log.e((String)"r2000_kt45", (String)("reval is " + res.value));
        return null;
    }

    @Override
    public String read_area(int area, String str_addr, String str_count, String str_passwd) {
        long passwd;
        int num_count;
        int num_addr;
        try {
            num_addr = Integer.parseInt(str_addr, 16);
            num_count = Integer.parseInt(str_count, 10);
            passwd = Long.parseLong(str_passwd, 16);
        }
        catch (NumberFormatException p) {
            return null;
        }
        String res = this.read_card(area, num_addr, num_count * 2, (int)passwd);
        return res;
    }

    private String read_card(int area, int addr, int count, int passwd) {
        byte[] v = this.read_area(area, addr, count, passwd);
        if (v == null) {
            return null;
        }
        String j = new String();
        byte[] byArray = v;
        int n = v.length;
        int n2 = 0;
        while (n2 < n) {
            byte i = byArray[n2];
            j = String.valueOf(j) + String.format("%02x ", i);
            ++n2;
        }
        return j;
    }

    public int set_fix_freq(double freq, int region) {
        int res = Constants.Result.RFID_ERROR_FAILURE.getValue();
        switch (region) {
            case 0: {
                if (!(freq <= 845.0) || !(freq >= 840.0)) break;
                res = this.lk.Radio_SetSingleFrequency(freq, Constants.RFID_18K6C_COUNTRY_REGION.China840_845);
                break;
            }
            case 1: {
                if (!(freq >= 920.0) || !(freq <= 925.0)) break;
                res = this.lk.Radio_SetSingleFrequency(freq, Constants.RFID_18K6C_COUNTRY_REGION.China920_925);
                break;
            }
            case 2: {
                if (!(freq >= 902.0) || !(freq <= 928.0)) break;
                res = this.lk.Radio_SetSingleFrequency(freq, Constants.RFID_18K6C_COUNTRY_REGION.Open_Area902_928);
            }
        }
        if (res != Constants.Result.RFID_STATUS_OK.getValue()) {
            return -1;
        }
        return 0;
    }

    public double get_fix_freq() {
        Rfid_dValue rv = new Rfid_dValue();
        int x = this.lk.Radio_GetSingleFrequency(rv);
        if (x != Constants.Result.RFID_STATUS_OK.getValue()) {
            return -1.0;
        }
        return rv.value;
    }

    @Override
    public int MakeSetValid() {
        int j = this.lk.Radio_MacReset();
        if (j != Constants.Result.RFID_STATUS_OK.getValue()) {
            return -1;
        }
        return 0;
    }

    @Override
    public int set_freq_region(int region) {
        int res = Constants.Result.RFID_ERROR_FAILURE.getValue();
        switch (region) {
            case 0: {
                res = this.lk.Radio_MacSetRegion(Constants.RFID_18K6C_COUNTRY_REGION.China840_845);
                break;
            }
            case 1: {
                res = this.lk.Radio_MacSetRegion(Constants.RFID_18K6C_COUNTRY_REGION.China920_925);
                break;
            }
            case 2: {
                res = this.lk.Radio_MacSetRegion(Constants.RFID_18K6C_COUNTRY_REGION.Open_Area902_928);
                break;
            }
            case 3: {
                return -1;
            }
        }
        if (res != Constants.Result.RFID_STATUS_OK.getValue()) {
            return -1;
        }
        return 0;
    }

    @Override
    public int get_freq_region() {
        Rfid_Value rv = new Rfid_Value();
        int rs = this.lk.Radio_MacGetRegion(rv);
        if (rs != Constants.Result.RFID_STATUS_OK.getValue()) {
            return -1;
        }
        if (rv.value == Constants.RFID_18K6C_COUNTRY_REGION.China840_845.getValue()) {
            return 0;
        }
        if (rv.value == Constants.RFID_18K6C_COUNTRY_REGION.China920_925.getValue()) {
            return 1;
        }
        if (rv.value == Constants.RFID_18K6C_COUNTRY_REGION.Open_Area902_928.getValue()) {
            return 2;
        }
        return -1;
    }

    @Override
    public int write_area(int area, int addr, int passwd, byte[] content) {
        int bk = 3;
        int status = Constants.Result.RFID_ERROR_FAILURE.getValue();
        if (area >= 0 && area <= 3 && content.length % 2 == 0) {
            switch (area) {
                case 0: {
                    bk = Constants.MemoryBank.RESERVED.getValue();
                    break;
                }
                case 1: {
                    bk = Constants.MemoryBank.EPC.getValue();
                    break;
                }
                case 2: {
                    bk = Constants.MemoryBank.TID.getValue();
                    break;
                }
                case 3: {
                    bk = Constants.MemoryBank.USER.getValue();
                }
            }
            char[] s = new char[content.length / 2];
            int i = 0;
            while (i < content.length / 2) {
                s[i] = (char)(this.btoi(content[i * 2 + 1]) + (this.btoi(content[i * 2]) << 8));
                ++i;
            }
            status = this.lk.Radio_WriteTag(content.length / 2, addr, bk, (long)passwd, s, 1);
        }
        if (status != Constants.Result.RFID_STATUS_OK.getValue()) {
            Log.e((String)"r2000_kt45", (String)("return status is " + status));
            return -1;
        }
        return 0;
    }

    @Override
    public int write_area(int area, String addr, String pwd, String count, String content) {
        long passwd;
        int num_count;
        int num_addr;
        try {
            num_addr = Integer.parseInt(addr, 16);
            num_count = Integer.parseInt(count, 10);
            passwd = Long.parseLong(pwd, 16);
        }
        catch (NumberFormatException p) {
            return -3;
        }
        int rev = this.write_card(area, num_addr, num_count * 2, (int)passwd, content);
        return rev;
    }

    public int write_card(int area, int addr, int count, int passwd, String cnt) {
        StringTokenizer cn = new StringTokenizer(cnt);
        if (cn.countTokens() < count) {
            return -2;
        }
        byte[] cf = new byte[count];
        int index = 0;
        while (cn.hasMoreTokens() && index < count) {
            try {
                int k = Integer.parseInt(cn.nextToken(), 16);
                if (k > 255) {
                    throw new NumberFormatException("can't bigger than 0xff");
                }
                cf[index++] = (byte)k;
            }
            catch (NumberFormatException p) {
                return -3;
            }
        }
        return this.write_area(area, addr, passwd, cf);
    }

    @Override
    public int set_antenna_power(int power) {
        int res = Constants.Result.RFID_ERROR_FAILURE.getValue();
        if (power >= 0 && power <= 30) {
            res = this.lk.Radio_SetAntennaPower(power * 10);
        }
        if (res != Constants.Result.RFID_STATUS_OK.getValue()) {
            return -1;
        }
        return 0;
    }

    @Override
    public int get_antenna_power() {
        Rfid_Value rv = new Rfid_Value();
        int p = this.lk.Radio_GetAntennaPower(rv);
        if (p != Constants.Result.RFID_STATUS_OK.getValue()) {
            return -1;
        }
        return rv.value / 10;
    }

    public int set_link_prof(int pf) {
        int res = Constants.Result.RFID_ERROR_FAILURE.getValue();
        if (pf >= 0 && pf <= 4) {
            res = this.lk.Radio_SetCurrentLinkProfile(pf);
        }
        if (res != Constants.Result.RFID_STATUS_OK.getValue()) {
            return -1;
        }
        return 0;
    }

    public int get_link_prof() {
        Rfid_Value rv = new Rfid_Value();
        int p = this.lk.Radio_GetCurrentLinkProfile(rv);
        if (p != Constants.Result.RFID_STATUS_OK.getValue()) {
            return -1;
        }
        return rv.value;
    }

    @Override
    public int select_card(byte[] epc) {
        Log.i((String)"r2000_kt45", (String)("epc leng is " + epc.length));
        byte[] byArray = epc;
        int n = epc.length;
        int n2 = 0;
        while (n2 < n) {
            byte i = byArray[n2];
            Log.i((String)"r2000_kt45", (String)String.format("%02x", i));
            ++n2;
        }
        int rv = this.SetMask(this.lk, epc, epc.length * 2);
        if (rv != Constants.Result.RFID_STATUS_OK.getValue()) {
            Log.e((String)"r2000_kt45", (String)"SetMask failed");
            return -1;
        }
        return 0;
    }

    @Override
    public int select_card(String epc) {
        StringTokenizer sepc = new StringTokenizer(epc);
        byte[] eepc = new byte[sepc.countTokens()];
        int index = 0;
        while (sepc.hasMoreTokens()) {
            try {
                eepc[index++] = (byte)Integer.parseInt(sepc.nextToken(), 16);
            }
            catch (NumberFormatException p) {
                return -1;
            }
        }
        if (this.select_card(eepc) != 0) {
            return -1;
        }
        return 0;
    }

    @Override
    public int set_Password(int which, String cur_pass, String new_pass) {
        if (which > 1 || which < 0) {
            return -1;
        }
        try {
            long cp = Long.parseLong(cur_pass, 16);
            if (cp > 0xFFFFFFFFL || cp < 0L) {
                throw new NumberFormatException("can't bigger than 0xffffffff");
            }
            long np = Long.parseLong(new_pass, 16);
            if (np > 0xFFFFFFFFL || np < 0L) {
                throw new NumberFormatException("can't bigger than 0xffffffff");
            }
            byte[] nps = new byte[4];
            nps[3] = (byte)(np >> 0 & 0xFFL);
            nps[2] = (byte)(np >> 8 & 0xFFL);
            nps[1] = (byte)(np >> 16 & 0xFFL);
            nps[0] = (byte)(np >> 24 & 0xFFL);
            return this.write_area(0, which * 2, (int)cp, nps);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private int SetMask(Linkage link, byte[] bytetemp, int length) {
        int status = Constants.Result.RFID_STATUS_OK.getValue();
        status = link.Radio_SetCurrentSingulationAlgorithm(0);
        if (status != Constants.Result.RFID_STATUS_OK.getValue()) {
            return status;
        }
        Log.i((String)"r2000_kt45", (String)"setcurrent ok");
        TagGroup group = new TagGroup();
        status = link.Radio_GetQueryTagGroup(group);
        if (status != Constants.Result.RFID_STATUS_OK.getValue()) {
            return status;
        }
        Log.i((String)"r2000_kt45", (String)"getquery ok");
        group.session = 2;
        status = link.Radio_SetQueryTagGroup(group);
        if (status != Constants.Result.RFID_STATUS_OK.getValue()) {
            return status;
        }
        Log.i((String)"r2000_kt45", (String)"setquery ok");
        FixedQParms rsfp = new FixedQParms();
        rsfp.qValue = 4;
        rsfp.retryCount = 0;
        rsfp.toggleTarget = 0;
        rsfp.repeatUntiNoTags = 0;
        status = link.Radio_SetSingulationAlgorithmFiParameters(rsfp);
        if (status != Constants.Result.RFID_STATUS_OK.getValue()) {
            return status;
        }
        int count = length * 4;
        Log.i((String)"r2000_kt45", (String)("---maskControlloer--------------------" + bytetemp.length));
        int offset = 32;
        SelectCriteria selectCriteria = new SelectCriteria();
        selectCriteria.countCriteria = 1;
        selectCriteria.mask_bank = 1;
        selectCriteria.mask_offset = offset;
        selectCriteria.mask_count = count;
        int i = 0;
        while (i < bytetemp.length) {
            selectCriteria.mask_mask[i] = bytetemp[i];
            ++i;
        }
        selectCriteria.action_target = 2;
        selectCriteria.action_action = 0;
        selectCriteria.action_enableTruncate = 0;
        status = link.Radio_SetSelectCriteria(selectCriteria, 0);
        Log.i((String)"r2000_kt45", (String)("=======================================" + status));
        return status;
    }

    private int SetAlgorithmDyParameters(Linkage link) {
        int status = Constants.Result.RFID_STATUS_OK.getValue();
        status = link.Radio_SetCurrentSingulationAlgorithm(1);
        if (status != Constants.Result.RFID_STATUS_OK.getValue()) {
            return status;
        }
        TagGroup group = new TagGroup();
        status = link.Radio_GetQueryTagGroup(group);
        if (status != Constants.Result.RFID_STATUS_OK.getValue()) {
            return status;
        }
        group.session = 2;
        status = link.Radio_SetQueryTagGroup(group);
        if (status != Constants.Result.RFID_STATUS_OK.getValue()) {
            return status;
        }
        DynamicQParms dynamic = new DynamicQParms();
        dynamic.minQValue = 0;
        dynamic.maxQValue = 15;
        dynamic.retryCount = 0;
        dynamic.startQValue = 4;
        dynamic.thresholdMultiplier = 4;
        dynamic.toggleTarget = 1;
        status = link.Radio_SetSingulationAlgorithmDyParameters(dynamic);
        if (status != Constants.Result.RFID_STATUS_OK.getValue()) {
            return status;
        }
        return status;
    }

    private class get_invdata
    extends Thread {
        private get_invdata() {
        }

        @Override
        public void run() {
            super.run();
            while (R2K.this.inSearch) {
                Message msg = new Message();
                ArrayList tg = R2K.this.get_inventory_data();
                if (tg == null) continue;
                msg.what = 1;
                msg.obj = tg;
                R2K.this.h.sendMessage(msg);
            }
            Log.d((String)"r2000_kt45", (String)"get data thread is interrupted*************************************");
        }
    }

    private class inv_thread
    extends Thread {
        private inv_thread() {
        }

        @Override
        public void run() {
            super.run();
            int rv = R2K.this.SetAlgorithmDyParameters(R2K.this.lk);
            if (rv != Constants.Result.RFID_STATUS_OK.getValue()) {
                Log.w((String)"r2000_kt45", (String)"set alg failed3333333333333333333333333333333333333333333333333333333333333333333333");
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            R2K.this.lk.Inventory(1);
            Log.d((String)"r2000_kt45", (String)"inventory thread is stoped************************************************");
        }
    }
}

