/*
 * Decompiled with CFR 0.152.
 */
package com.speedata.libuhf;

import android.content.Context;
import android.os.Build;
import android.serialport.SerialPort;
import android.text.TextUtils;
import android.util.Log;
import com.android.uhflibs.as3992_native;
import com.speedata.libuhf.DeviceControl;
import com.speedata.libuhf.FLX_QiLian;
import com.speedata.libuhf.IUHFService;
import com.speedata.libuhf.R2K;
import com.speedata.libuhf.XinLianQilian;
import com.speedata.libuhf.utils.SharedXmlUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class UHFManager {
    private static IUHFService iuhfService;
    private static byte[] feilixin_cmd;
    private static byte[] r2000_cmd;
    private static byte[] xinlian_cmd;
    private static final String FACTORY_FEILIXIN = "FEILIXIN";
    private static final String FACTORY_XINLIAN = "XINLIAN";
    private static final String FACTORY_R2000 = "R2000";
    private static final String FACTORY_3992 = "3992";
    private static int fd;
    private static DeviceControl pw94;
    private static Context mContext;

    static {
        byte[] byArray = new byte[8];
        byArray[0] = -69;
        byArray[2] = 3;
        byArray[4] = 1;
        byArray[5] = 2;
        byArray[6] = 6;
        byArray[7] = 126;
        feilixin_cmd = byArray;
        byte[] byArray2 = new byte[8];
        byArray2[0] = -64;
        byArray2[1] = 6;
        r2000_cmd = byArray2;
        byte[] byArray3 = new byte[5];
        byArray3[0] = -1;
        byArray3[2] = 3;
        byArray3[3] = 29;
        byArray3[4] = 12;
        xinlian_cmd = byArray3;
    }

    public static IUHFService getUHFService(Context context) {
        mContext = context;
        if (iuhfService == null && !UHFManager.judgeModle()) {
            return null;
        }
        return iuhfService;
    }

    private static boolean judgeModle() {
        String factory = SharedXmlUtil.getInstance(mContext).read("modle", "");
        if (TextUtils.isEmpty((CharSequence)factory)) {
            Log.d((String)"getModle_start", (String)String.valueOf(System.currentTimeMillis()));
            if (Build.VERSION.RELEASE.equals("4.4.2")) {
                UHFManager.powerOn("/sys/class/misc/mtgpio/pin", 64);
            } else if (Build.VERSION.RELEASE.equals("5.1")) {
                String xinghao = Build.MODEL;
                if (xinghao.equals("KT80") || xinghao.equals("W6") || xinghao.equals("N80")) {
                    UHFManager.powerOn("/sys/class/misc/mtgpio/pin", 119);
                } else if (xinghao.equals("KT55")) {
                    UHFManager.powerOn("/sys/class/misc/mtgpio/pin", 88);
                } else {
                    UHFManager.powerOn("/sys/class/misc/mtgpio/pin", 94);
                }
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            factory = UHFManager.getModle();
            SharedXmlUtil.getInstance(mContext).write("modle", factory);
            Log.d((String)"getModle_end", (String)String.valueOf(System.currentTimeMillis()));
        }
        boolean initResult = true;
        switch (factory) {
            case "FEILIXIN": {
                iuhfService = new FLX_QiLian();
                break;
            }
            case "XINLIAN": {
                iuhfService = new XinLianQilian();
                break;
            }
            case "R2000": {
                iuhfService = new R2K();
                break;
            }
            case "3992": {
                iuhfService = new as3992_native();
                break;
            }
            default: {
                initResult = false;
            }
        }
        return initResult;
    }

    private static void powerOn(String POWERCTL, int PW_GPIO) {
        pw94 = new DeviceControl(POWERCTL, PW_GPIO);
        pw94.PowerOnDevice();
    }

    private static String getModle() {
        String factory = "";
        SerialPort serialPort = new SerialPort();
        try {
            serialPort.OpenSerial("/dev/ttyMT2", 115200);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        fd = serialPort.getFd();
        byte[] bytes = new byte[1024];
        serialPort.clearPortBuf(fd);
        serialPort.WriteSerialByte(fd, r2000_cmd);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        try {
            bytes = serialPort.ReadSerial(fd, 1024);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (bytes != null) {
            factory = UHFManager.bytesToHexString(bytes);
        }
        if (factory.equals("240349006D00700069006E006A00530065007200690061006C004E0075006D0030003100")) {
            serialPort.CloseSerial(fd);
            pw94.PowerOffDevice();
            return FACTORY_R2000;
        }
        serialPort.clearPortBuf(fd);
        serialPort.WriteSerialByte(fd, feilixin_cmd);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        try {
            bytes = serialPort.ReadSerial(fd, 1024);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (bytes != null && (factory = UHFManager.bytesToHexString(bytes)).equals("BB0103000A025261794D6174726978B17E")) {
            serialPort.CloseSerial(fd);
            pw94.PowerOffDevice();
            return FACTORY_FEILIXIN;
        }
        serialPort.clearPortBuf(fd);
        serialPort.WriteSerialByte(fd, xinlian_cmd);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        try {
            bytes = serialPort.ReadSerial(fd, 1024);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        int length = 0;
        if (bytes != null && (length = bytes.length) == 27) {
            serialPort.CloseSerial(fd);
            pw94.PowerOffDevice();
            return FACTORY_XINLIAN;
        }
        serialPort.CloseSerial(fd);
        pw94.PowerOffDevice();
        return FACTORY_3992;
    }

    public static final String bytesToHexString(byte[] bArray) {
        StringBuffer sb = new StringBuffer(bArray.length);
        int i = 0;
        while (i < bArray.length) {
            String sTemp = Integer.toHexString(0xFF & bArray[i]);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTemp.toUpperCase());
            ++i;
        }
        return sb.toString();
    }
}

