/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import java.util.HashMap;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.LOG;
import org.apache.cordova.PluginResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class App
extends CordovaPlugin {
    public boolean execute(String action, JSONArray args, CallbackContext callbackContext) throws JSONException {
        PluginResult.Status status = PluginResult.Status.OK;
        String result = "";
        try {
            if (action.equals("clearCache")) {
                this.clearCache();
            } else if (action.equals("show")) {
                this.cordova.getActivity().runOnUiThread(new Runnable(){

                    public void run() {
                        App.this.webView.postMessage("spinner", "stop");
                    }
                });
            } else if (action.equals("loadUrl")) {
                this.loadUrl(args.getString(0), args.optJSONObject(1));
            } else if (!action.equals("cancelLoadUrl")) {
                if (action.equals("clearHistory")) {
                    this.clearHistory();
                } else if (action.equals("backHistory")) {
                    this.backHistory();
                } else if (action.equals("overrideButton")) {
                    this.overrideButton(args.getString(0), args.getBoolean(1));
                } else if (action.equals("overrideBackbutton")) {
                    this.overrideBackbutton(args.getBoolean(0));
                } else if (action.equals("exitApp")) {
                    this.exitApp();
                }
            }
            callbackContext.sendPluginResult(new PluginResult(status, result));
            return true;
        }
        catch (JSONException e) {
            callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.JSON_EXCEPTION));
            return false;
        }
    }

    public void clearCache() {
        this.cordova.getActivity().runOnUiThread(new Runnable(){

            public void run() {
                App.this.webView.clearCache(true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadUrl(String url, JSONObject props) throws JSONException {
        Object keys;
        LOG.d("App", "App.loadUrl(" + url + "," + props + ")");
        int wait = 0;
        boolean openExternal = false;
        boolean clearHistory = false;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (props != null) {
            keys = props.names();
            for (int i = 0; i < keys.length(); ++i) {
                String key = keys.getString(i);
                if (key.equals("wait")) {
                    wait = props.getInt(key);
                    continue;
                }
                if (key.equalsIgnoreCase("openexternal")) {
                    openExternal = props.getBoolean(key);
                    continue;
                }
                if (key.equalsIgnoreCase("clearhistory")) {
                    clearHistory = props.getBoolean(key);
                    continue;
                }
                Object value = props.get(key);
                if (value == null) continue;
                if (value.getClass().equals(String.class)) {
                    params.put(key, (String)value);
                    continue;
                }
                if (value.getClass().equals(Boolean.class)) {
                    params.put(key, (Boolean)value);
                    continue;
                }
                if (!value.getClass().equals(Integer.class)) continue;
                params.put(key, (Integer)value);
            }
        }
        if (wait > 0) {
            try {
                keys = this;
                synchronized (keys) {
                    this.wait(wait);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.webView.showWebPage(url, openExternal, clearHistory, params);
    }

    public void clearHistory() {
        this.webView.clearHistory();
    }

    public void backHistory() {
        this.cordova.getActivity().runOnUiThread(new Runnable(){

            public void run() {
                App.this.webView.backHistory();
            }
        });
    }

    public void overrideBackbutton(boolean override) {
        LOG.i("App", "WARNING: Back Button Default Behaviour will be overridden.  The backbutton event will be fired!");
        this.webView.bindButton(override);
    }

    public void overrideButton(String button, boolean override) {
        LOG.i("App", "WARNING: Volume Button Default Behaviour will be overridden.  The volume event will be fired!");
        this.webView.bindButton(button, override);
    }

    public boolean isBackbuttonOverridden() {
        return this.webView.isBackButtonBound();
    }

    public void exitApp() {
        this.webView.postMessage("exit", null);
    }
}

