/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.app.Activity;
import android.content.res.XmlResourceParser;
import android.util.Log;
import java.io.IOException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cordova.LOG;
import org.apache.cordova.Whitelist;
import org.xmlpull.v1.XmlPullParserException;

public class Config {
    public static final String TAG = "Config";
    private Whitelist whitelist = new Whitelist();
    private String startUrl;
    private static Config self = null;

    public static void init(Activity action) {
        self = new Config(action);
    }

    public static void init() {
        if (self == null) {
            self = new Config();
        }
    }

    private Config() {
    }

    private Config(Activity action) {
        if (action == null) {
            LOG.i("CordovaLog", "There is no activity. Is this on the lock screen?");
            return;
        }
        int id = action.getResources().getIdentifier("config", "xml", action.getPackageName());
        if (id == 0) {
            id = action.getResources().getIdentifier("cordova", "xml", action.getPackageName());
            LOG.i("CordovaLog", "config.xml missing, reverting to cordova.xml");
        }
        if (id == 0) {
            LOG.i("CordovaLog", "cordova.xml missing. Ignoring...");
            return;
        }
        this.whitelist.addWhiteListEntry("file:///*", false);
        this.whitelist.addWhiteListEntry("content:///*", false);
        this.whitelist.addWhiteListEntry("data:*", false);
        XmlResourceParser xml = action.getResources().getXml(id);
        int eventType = -1;
        while (eventType != 1) {
            if (eventType == 2) {
                String strNode = xml.getName();
                if (strNode.equals("access")) {
                    String origin = xml.getAttributeValue(null, "origin");
                    String subdomains = xml.getAttributeValue(null, "subdomains");
                    if (origin != null) {
                        this.whitelist.addWhiteListEntry(origin, subdomains != null && subdomains.compareToIgnoreCase("true") == 0);
                    }
                } else if (strNode.equals("log")) {
                    String level = xml.getAttributeValue(null, "level");
                    Log.d((String)TAG, (String)("The <log> tags is deprecated. Use <preference name=\"loglevel\" value=\"" + level + "\"/> instead."));
                    if (level != null) {
                        LOG.setLogLevel(level);
                    }
                } else if (strNode.equals("preference")) {
                    String value;
                    String name = xml.getAttributeValue(null, "name").toLowerCase(Locale.getDefault());
                    if (name.equalsIgnoreCase("LogLevel")) {
                        String level = xml.getAttributeValue(null, "value");
                        LOG.setLogLevel(level);
                    } else if (name.equalsIgnoreCase("SplashScreen")) {
                        value = xml.getAttributeValue(null, "value");
                        int resource = 0;
                        if (value == null) {
                            value = "splash";
                        }
                        resource = action.getResources().getIdentifier(value, "drawable", action.getPackageName());
                        action.getIntent().putExtra(name, resource);
                    } else if (name.equalsIgnoreCase("BackgroundColor")) {
                        int value2 = xml.getAttributeIntValue(null, "value", -16777216);
                        action.getIntent().putExtra(name, value2);
                    } else if (name.equalsIgnoreCase("LoadUrlTimeoutValue")) {
                        int value3 = xml.getAttributeIntValue(null, "value", 20000);
                        action.getIntent().putExtra(name, value3);
                    } else if (name.equalsIgnoreCase("SplashScreenDelay")) {
                        int value4 = xml.getAttributeIntValue(null, "value", 3000);
                        action.getIntent().putExtra(name, value4);
                    } else if (name.equalsIgnoreCase("KeepRunning")) {
                        boolean value5 = xml.getAttributeValue(null, "value").equals("true");
                        action.getIntent().putExtra(name, value5);
                    } else if (name.equalsIgnoreCase("InAppBrowserStorageEnabled")) {
                        boolean value6 = xml.getAttributeValue(null, "value").equals("true");
                        action.getIntent().putExtra(name, value6);
                    } else if (name.equalsIgnoreCase("DisallowOverscroll")) {
                        boolean value7 = xml.getAttributeValue(null, "value").equals("true");
                        action.getIntent().putExtra(name, value7);
                    } else {
                        value = xml.getAttributeValue(null, "value");
                        action.getIntent().putExtra(name, value);
                    }
                } else if (strNode.equals("content")) {
                    String src = xml.getAttributeValue(null, "src");
                    LOG.i("CordovaLog", "Found start page location: %s", src);
                    if (src != null) {
                        Pattern schemeRegex = Pattern.compile("^[a-z-]+://");
                        Matcher matcher = schemeRegex.matcher(src);
                        if (matcher.find()) {
                            this.startUrl = src;
                        } else {
                            if (src.charAt(0) == '/') {
                                src = src.substring(1);
                            }
                            this.startUrl = "file:///android_asset/www/" + src;
                        }
                    }
                }
            }
            try {
                eventType = xml.next();
            }
            catch (XmlPullParserException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void addWhiteListEntry(String origin, boolean subdomains) {
        if (self == null) {
            return;
        }
        Config.self.whitelist.addWhiteListEntry(origin, subdomains);
    }

    public static boolean isUrlWhiteListed(String url) {
        if (self == null) {
            return false;
        }
        return Config.self.whitelist.isUrlWhiteListed(url);
    }

    public static String getStartUrl() {
        if (self == null || Config.self.startUrl == null) {
            return "file:///android_asset/www/index.html";
        }
        return Config.self.startUrl;
    }
}

