/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.content.Intent;
import android.content.res.XmlResourceParser;
import android.net.Uri;
import android.os.Debug;
import android.util.Log;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaArgs;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.LOG;
import org.apache.cordova.PluginEntry;
import org.apache.cordova.PluginResult;
import org.json.JSONException;
import org.xmlpull.v1.XmlPullParserException;

public class PluginManager {
    private static String TAG = "PluginManager";
    private static final int SLOW_EXEC_WARNING_THRESHOLD = Debug.isDebuggerConnected() ? 60 : 16;
    private final HashMap<String, PluginEntry> entries = new HashMap();
    private final CordovaInterface ctx;
    private final CordovaWebView app;
    private boolean firstRun;
    protected HashMap<String, String> urlMap = new HashMap();
    private AtomicInteger numPendingUiExecs;

    public PluginManager(CordovaWebView app, CordovaInterface ctx) {
        this.ctx = ctx;
        this.app = app;
        this.firstRun = true;
        this.numPendingUiExecs = new AtomicInteger(0);
    }

    public void init() {
        LOG.d(TAG, "init()");
        if (this.firstRun) {
            this.loadPlugins();
            this.firstRun = false;
        } else {
            this.onPause(false);
            this.onDestroy();
            this.clearPluginObjects();
        }
        this.addService(new PluginEntry("PluginManager", new PluginManagerService()));
        this.startupPlugins();
    }

    public void loadPlugins() {
        int id = this.ctx.getActivity().getResources().getIdentifier("config", "xml", this.ctx.getActivity().getPackageName());
        if (id == 0) {
            this.pluginConfigurationMissing();
            return;
        }
        XmlResourceParser xml = this.ctx.getActivity().getResources().getXml(id);
        int eventType = -1;
        String service = "";
        String pluginClass = "";
        String paramType = "";
        boolean onload = false;
        boolean insideFeature = false;
        while (eventType != 1) {
            String strNode;
            if (eventType == 2) {
                strNode = xml.getName();
                if (strNode.equals("url-filter")) {
                    this.urlMap.put(xml.getAttributeValue(null, "value"), service);
                } else if (strNode.equals("feature")) {
                    insideFeature = true;
                    service = xml.getAttributeValue(null, "name");
                } else if (insideFeature && strNode.equals("param")) {
                    paramType = xml.getAttributeValue(null, "name");
                    if (paramType.equals("service")) {
                        service = xml.getAttributeValue(null, "value");
                    } else if (paramType.equals("package") || paramType.equals("android-package")) {
                        pluginClass = xml.getAttributeValue(null, "value");
                    } else if (paramType.equals("onload")) {
                        onload = "true".equals(xml.getAttributeValue(null, "value"));
                    }
                }
            } else if (eventType == 3 && ((strNode = xml.getName()).equals("feature") || strNode.equals("plugin"))) {
                PluginEntry entry = new PluginEntry(service, pluginClass, onload);
                this.addService(entry);
                service = "";
                pluginClass = "";
                insideFeature = false;
            }
            try {
                eventType = xml.next();
            }
            catch (XmlPullParserException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void clearPluginObjects() {
        for (PluginEntry entry : this.entries.values()) {
            entry.plugin = null;
        }
    }

    public void startupPlugins() {
        for (PluginEntry entry : this.entries.values()) {
            if (!entry.onload) continue;
            entry.createPlugin(this.app, this.ctx);
        }
    }

    public void exec(final String service, final String action, final String callbackId, final String rawArgs) {
        if (this.numPendingUiExecs.get() > 0) {
            this.numPendingUiExecs.getAndIncrement();
            this.ctx.getActivity().runOnUiThread(new Runnable(){

                public void run() {
                    PluginManager.this.execHelper(service, action, callbackId, rawArgs);
                    PluginManager.this.numPendingUiExecs.getAndDecrement();
                }
            });
        } else {
            this.execHelper(service, action, callbackId, rawArgs);
        }
    }

    private void execHelper(String service, String action, String callbackId, String rawArgs) {
        CordovaPlugin plugin = this.getPlugin(service);
        if (plugin == null) {
            Log.d((String)TAG, (String)("exec() call to unknown plugin: " + service));
            PluginResult cr = new PluginResult(PluginResult.Status.CLASS_NOT_FOUND_EXCEPTION);
            this.app.sendPluginResult(cr, callbackId);
            return;
        }
        try {
            CallbackContext callbackContext = new CallbackContext(callbackId, this.app);
            long pluginStartTime = System.currentTimeMillis();
            boolean wasValidAction = plugin.execute(action, rawArgs, callbackContext);
            long duration = System.currentTimeMillis() - pluginStartTime;
            if (duration > (long)SLOW_EXEC_WARNING_THRESHOLD) {
                Log.w((String)TAG, (String)("THREAD WARNING: exec() call to " + service + "." + action + " blocked the main thread for " + duration + "ms. Plugin should use CordovaInterface.getThreadPool()."));
            }
            if (!wasValidAction) {
                PluginResult cr = new PluginResult(PluginResult.Status.INVALID_ACTION);
                this.app.sendPluginResult(cr, callbackId);
            }
        }
        catch (JSONException e) {
            PluginResult cr = new PluginResult(PluginResult.Status.JSON_EXCEPTION);
            this.app.sendPluginResult(cr, callbackId);
        }
    }

    @Deprecated
    public void exec(String service, String action, String callbackId, String jsonArgs, boolean async) {
        this.exec(service, action, callbackId, jsonArgs);
    }

    public CordovaPlugin getPlugin(String service) {
        PluginEntry entry = this.entries.get(service);
        if (entry == null) {
            return null;
        }
        CordovaPlugin plugin = entry.plugin;
        if (plugin == null) {
            plugin = entry.createPlugin(this.app, this.ctx);
        }
        return plugin;
    }

    public void addService(String service, String className) {
        PluginEntry entry = new PluginEntry(service, className, false);
        this.addService(entry);
    }

    public void addService(PluginEntry entry) {
        this.entries.put(entry.service, entry);
    }

    public void onPause(boolean multitasking) {
        for (PluginEntry entry : this.entries.values()) {
            if (entry.plugin == null) continue;
            entry.plugin.onPause(multitasking);
        }
    }

    public void onResume(boolean multitasking) {
        for (PluginEntry entry : this.entries.values()) {
            if (entry.plugin == null) continue;
            entry.plugin.onResume(multitasking);
        }
    }

    public void onDestroy() {
        for (PluginEntry entry : this.entries.values()) {
            if (entry.plugin == null) continue;
            entry.plugin.onDestroy();
        }
    }

    public Object postMessage(String id, Object data) {
        Object obj = this.ctx.onMessage(id, data);
        if (obj != null) {
            return obj;
        }
        for (PluginEntry entry : this.entries.values()) {
            if (entry.plugin == null || (obj = entry.plugin.onMessage(id, data)) == null) continue;
            return obj;
        }
        return null;
    }

    public void onNewIntent(Intent intent) {
        for (PluginEntry entry : this.entries.values()) {
            if (entry.plugin == null) continue;
            entry.plugin.onNewIntent(intent);
        }
    }

    public boolean onOverrideUrlLoading(String url) {
        for (Map.Entry<String, String> pairs : this.urlMap.entrySet()) {
            if (!url.startsWith(pairs.getKey())) continue;
            return this.getPlugin(pairs.getValue()).onOverrideUrlLoading(url);
        }
        return false;
    }

    public void onReset() {
        Iterator<PluginEntry> it = this.entries.values().iterator();
        while (it.hasNext()) {
            CordovaPlugin plugin = it.next().plugin;
            if (plugin == null) continue;
            plugin.onReset();
        }
    }

    private void pluginConfigurationMissing() {
        LOG.e(TAG, "=====================================================================================");
        LOG.e(TAG, "ERROR: config.xml is missing.  Add res/xml/config.xml to your project.");
        LOG.e(TAG, "https://git-wip-us.apache.org/repos/asf?p=incubator-cordova-android.git;a=blob;f=framework/res/xml/plugins.xml");
        LOG.e(TAG, "=====================================================================================");
    }

    Uri remapUri(Uri uri) {
        for (PluginEntry entry : this.entries.values()) {
            Uri ret;
            if (entry.plugin == null || (ret = entry.plugin.remapUri(uri)) == null) continue;
            return ret;
        }
        return null;
    }

    private class PluginManagerService
    extends CordovaPlugin {
        private PluginManagerService() {
        }

        public boolean execute(String action, CordovaArgs args, CallbackContext callbackContext) throws JSONException {
            if ("startup".equals(action)) {
                PluginManager.this.numPendingUiExecs.getAndIncrement();
                PluginManager.this.ctx.getActivity().runOnUiThread(new Runnable(){

                    public void run() {
                        PluginManager.this.numPendingUiExecs.getAndDecrement();
                    }
                });
                return true;
            }
            return false;
        }
    }
}

