/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.api;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.Message;
import com.adobe.epubcheck.messages.MessageDictionary;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.messages.Severity;
import com.adobe.epubcheck.util.ReportingLevel;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonProperty;

public abstract class MasterReport
implements Report {
    public static Set<MessageId> allReportedMessageIds = new HashSet<MessageId>();
    int errorCount;
    int warningCount;
    int fatalErrorCount;
    int usageCount = 0;
    int reportingLevel = 2;
    private String ePubName;
    private MessageDictionary dictionary = new MessageDictionary(null, this);
    @JsonProperty
    String customMessageFileName = null;

    @Override
    public MessageDictionary getDictionary() {
        return this.dictionary;
    }

    protected MasterReport() {
    }

    @Override
    public void setOverrideFile(File overrideFile) {
        this.getDictionary().setOverrideFile(overrideFile);
    }

    private void reportMessageId(MessageId id) {
        allReportedMessageIds.add(id);
    }

    @Override
    public void message(MessageId id, EPUBLocation location, Object ... args) {
        Message message = this.getDictionary().getMessage(id);
        assert (message != null);
        Severity severity = message.getSeverity();
        if (ReportingLevel.getReportingLevel(severity) >= this.getReportingLevel()) {
            if (severity.equals((Object)Severity.ERROR)) {
                ++this.errorCount;
            } else if (severity.equals((Object)Severity.WARNING)) {
                ++this.warningCount;
            } else if (severity.equals((Object)Severity.FATAL)) {
                ++this.fatalErrorCount;
            } else if (severity.equals((Object)Severity.USAGE)) {
                ++this.usageCount;
            }
            this.message(message, location, args);
        }
        this.reportMessageId(id);
    }

    @Override
    public void setCustomMessageFile(String customMessageFileName) {
        this.customMessageFileName = customMessageFileName;
    }

    @Override
    public String getCustomMessageFile() {
        return this.customMessageFileName;
    }

    @Override
    public int getReportingLevel() {
        return this.reportingLevel;
    }

    @Override
    public void setReportingLevel(int reportingLevel) {
        if (reportingLevel >= 1 && reportingLevel <= 5) {
            this.reportingLevel = reportingLevel;
        } else {
            System.err.printf("Attempted to set invalid reporting level: %1d", reportingLevel);
        }
    }

    @Override
    public String getEpubFileName() {
        return this.ePubName;
    }

    @Override
    public void setEpubFileName(String value) {
        this.ePubName = value;
    }

    @Override
    public int getErrorCount() {
        return this.errorCount;
    }

    @Override
    public int getWarningCount() {
        return this.warningCount;
    }

    @Override
    public int getFatalErrorCount() {
        return this.fatalErrorCount;
    }

    @Override
    public void close() {
    }
}

