/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ctc;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ctc.epubpackage.EpubPackage;
import com.adobe.epubcheck.ctc.epubpackage.ManifestItem;
import com.adobe.epubcheck.ctc.epubpackage.SpineItem;
import com.adobe.epubcheck.ctc.xml.HTMLTagsAnalyseHandler;
import com.adobe.epubcheck.ctc.xml.XMLContentDocParser;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.ocf.EncryptionFilter;
import com.adobe.epubcheck.opf.DocumentValidator;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.util.SearchDictionary;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class EpubHTML5StructureCheck
implements DocumentValidator {
    static final int hasHtml = 1;
    static final int hasPublic = 2;
    static final int hasW3C = 4;
    static final int hasXhtml = 8;
    static final int hasHTML5 = 1;
    static final int hasHTML4 = 14;
    final ZipFile zip;
    final Report report;
    final EpubPackage epubPackage;
    final Hashtable<String, EncryptionFilter> enc;
    static final Pattern patternDocTypeElement = Pattern.compile("<*!*[Dd][Oo][Cc][Tt][Yy][Pp][Ee]");
    static final Pattern patternHtmlElement = Pattern.compile("([^Xx][Hh][Tt][Mm][Ll])");
    static final Pattern patternPublicElement = Pattern.compile("[Pp][Uu][Bb][Ll][Ii][Cc]");
    static final Pattern patternW3CElement = Pattern.compile("[Ww][3][Cc]//[Dd][Tt][Dd]");
    static final Pattern patternXhtmlElement = Pattern.compile("[Xx][Hh][Tt][Mm][Ll]");

    public EpubHTML5StructureCheck(EpubPackage epack, Report report) {
        this.zip = epack.getZip();
        this.report = report;
        this.epubPackage = epack;
        this.enc = new Hashtable();
    }

    @Override
    public boolean validate() {
        int i;
        boolean result = false;
        SearchDictionary vtsd = new SearchDictionary(SearchDictionary.DictionaryType.VALID_TEXT_MEDIA_TYPES);
        int landmarkNavCount = 0;
        boolean isGlobalFixed = EpubPackage.isGlobalFixed(this.epubPackage);
        Hashtable<String, SpineItem> spineItems = new Hashtable<String, SpineItem>();
        for (i = 0; i < this.epubPackage.getSpine().itemsLength(); ++i) {
            SpineItem si = this.epubPackage.getSpine().getItem(i);
            spineItems.put(si.getIdref(), si);
        }
        for (i = 0; i < this.epubPackage.getManifest().itemsLength(); ++i) {
            int docTypeMatches;
            String fileToParse;
            ZipEntry entry;
            ManifestItem mi = this.epubPackage.getManifest().getItem(i);
            if (!vtsd.isValidMediaType(mi.getMediaType())) continue;
            XMLContentDocParser parser = new XMLContentDocParser(this.epubPackage.getZip(), this.report);
            HTMLTagsAnalyseHandler sh = new HTMLTagsAnalyseHandler();
            sh.setReport(this.report);
            SpineItem si = (SpineItem)spineItems.get(mi.getId());
            boolean itemIsFixedFormat = isGlobalFixed;
            if (si != null) {
                String properties = si.getProperties();
                if (properties != null && properties != null && !properties.equals("")) {
                    String[] propertyArray;
                    properties = properties.replaceAll("[\\s]+", " ");
                    for (String prop : propertyArray = properties.split(" ")) {
                        if (prop.equals("rendition:layout-pre-paginated")) {
                            itemIsFixedFormat = true;
                            continue;
                        }
                        if (!prop.equals("rendition:layout-reflowable")) continue;
                        itemIsFixedFormat = false;
                    }
                }
                sh.setIsFixed(itemIsFixedFormat);
            }
            if ((entry = this.zip.getEntry(fileToParse = this.epubPackage.getManifestItemFileName(mi))) == null) continue;
            sh.setVersion(this.epubPackage.getVersion());
            sh.setFileName(fileToParse);
            String fileExtension = mi.getHref().substring(mi.getHref().lastIndexOf(46) + 1, mi.getHref().length());
            if (this.epubPackage.getVersion() == EPUBVersion.VERSION_2 && fileExtension.compareToIgnoreCase("html") != 0 && fileExtension.compareToIgnoreCase("htm") != 0 && fileExtension.compareToIgnoreCase("xhtml") != 0) {
                this.report.message(MessageId.HTM_014, EPUBLocation.create(this.epubPackage.getPackageMainPath() + "/" + mi.getHref()), new Object[0]);
            }
            if (0 != ((docTypeMatches = this.findMatchingDocumentTypePatterns(fileToParse)) & 0xE) && this.epubPackage.getVersion() == EPUBVersion.VERSION_3) {
                this.report.message(MessageId.HTM_015, EPUBLocation.create(this.epubPackage.getPackageMainPath() + "/" + mi.getHref()), new Object[0]);
            } else if (0 != (docTypeMatches & 1) && 8 != (docTypeMatches & 8) && this.epubPackage.getVersion() == EPUBVersion.VERSION_2) {
                this.report.message(MessageId.HTM_016, EPUBLocation.create(this.epubPackage.getPackageMainPath() + "/" + mi.getHref()), new Object[0]);
            }
            parser.parseDoc(fileToParse, sh);
            if (sh.getHtml5SpecTagsCounter() > 0) {
                this.report.info(fileToParse, FeatureEnum.HAS_HTML5, "true");
                if (this.epubPackage.isSpineItem(mi.getId())) {
                    this.report.info(null, FeatureEnum.HAS_HTML5, "true");
                }
            }
            landmarkNavCount += sh.getLandmarkNavCount();
        }
        if (landmarkNavCount != 1 && this.epubPackage.getVersion() == EPUBVersion.VERSION_3) {
            File zipFile = new File(this.zip.getName());
            this.report.message(MessageId.ACC_008, EPUBLocation.create(zipFile.getName()), new Object[0]);
        }
        return result;
    }

    InputStream getInputStream(String name) throws IOException {
        ZipEntry entry = this.zip.getEntry(name);
        if (entry == null) {
            return null;
        }
        InputStream in = this.zip.getInputStream(entry);
        EncryptionFilter filter = this.enc.get(name);
        if (filter == null) {
            return in;
        }
        if (filter.canDecrypt()) {
            return filter.decrypt(in);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int findMatchingDocumentTypePatterns(String entry) {
        InputStream is = null;
        int matchingPatterns = 0;
        try {
            is = this.getInputStream(entry);
            if (is == null) {
                throw new IOException("Input Stream not found: '" + entry + "'");
            }
            Scanner in = new Scanner(is);
            StringBuilder sb = new StringBuilder();
            int numBracketsToClose = 0;
            String line = null;
            while (in.hasNextLine()) {
                line = in.nextLine();
                Matcher matcher = patternDocTypeElement.matcher(line);
                if (!matcher.find()) continue;
                numBracketsToClose = 1;
                int i = matcher.start();
                if (i < 0) continue;
                sb.append("<");
                line = line.substring(i + 1);
                break;
            }
            while (numBracketsToClose > 0 && line != null) {
                for (int i = 0; numBracketsToClose > 0 && i < line.length(); ++i) {
                    Character ch = Character.valueOf(line.charAt(i));
                    if (ch.charValue() == '<') {
                        ++numBracketsToClose;
                    } else if (ch.charValue() == '>') {
                        --numBracketsToClose;
                    }
                    sb.append(ch);
                }
                if (in.hasNextLine()) {
                    sb.append(" ");
                    line = in.nextLine();
                    continue;
                }
                line = null;
            }
            if (numBracketsToClose > 0) {
                int n = -1;
                return n;
            }
            line = sb.toString();
            matchingPatterns |= this.checkPattern(line, patternHtmlElement, 1);
            matchingPatterns |= this.checkPattern(line, patternPublicElement, 2);
            matchingPatterns |= this.checkPattern(line, patternW3CElement, 4);
            matchingPatterns |= this.checkPattern(line, patternXhtmlElement, 8);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.report.message(MessageId.PKG_008, EPUBLocation.create(entry), e.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return matchingPatterns;
    }

    int checkPattern(String line, Pattern patternElement, int mask) {
        Matcher matcherElement = patternElement.matcher(line);
        return matcherElement.find() ? mask : 0;
    }
}

