/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.opf;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.EPUBProfile;
import com.adobe.epubcheck.api.FeatureReport;
import com.adobe.epubcheck.bitmap.BitmapCheckerFactory;
import com.adobe.epubcheck.css.CSSCheckerFactory;
import com.adobe.epubcheck.dict.SearchKeyMapCheckerFactory;
import com.adobe.epubcheck.dtbook.DTBookCheckerFactory;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.ContentCheckerFactory;
import com.adobe.epubcheck.opf.DocumentValidator;
import com.adobe.epubcheck.opf.LinkedResource;
import com.adobe.epubcheck.opf.LinkedResources;
import com.adobe.epubcheck.opf.MetadataSet;
import com.adobe.epubcheck.opf.OPFChecker;
import com.adobe.epubcheck.opf.OPFHandler;
import com.adobe.epubcheck.opf.OPFHandler30;
import com.adobe.epubcheck.opf.OPFItem;
import com.adobe.epubcheck.opf.ResourceCollection;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.ops.OPSCheckerFactory;
import com.adobe.epubcheck.overlay.OverlayCheckerFactory;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.vocab.DCMESVocab;
import com.adobe.epubcheck.vocab.PackageVocabs;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Set;

public class OPFChecker30
extends OPFChecker
implements DocumentValidator {
    public OPFChecker30(ValidationContext context) {
        super(context);
    }

    @Override
    protected void initContentCheckerFactoryMap() {
        HashMap<String, ContentCheckerFactory> map = new HashMap<String, ContentCheckerFactory>();
        map.put("application/vnd.epub.search-key-map+xml", SearchKeyMapCheckerFactory.getInstance());
        map.put("application/smil+xml", OverlayCheckerFactory.getInstance());
        map.put("application/xhtml+xml", OPSCheckerFactory.getInstance());
        map.put("application/x-dtbook+xml", DTBookCheckerFactory.getInstance());
        map.put("image/jpeg", BitmapCheckerFactory.getInstance());
        map.put("image/gif", BitmapCheckerFactory.getInstance());
        map.put("image/png", BitmapCheckerFactory.getInstance());
        map.put("image/svg+xml", OPSCheckerFactory.getInstance());
        map.put("text/css", CSSCheckerFactory.getInstance());
        this.contentCheckerFactoryMap.clear();
        this.contentCheckerFactoryMap.putAll(map);
    }

    @Override
    public void initHandler() {
        this.opfHandler = new OPFHandler30(this.context, this.opfParser);
    }

    @Override
    public void runChecks() {
        super.runChecks();
        this.checkCollectionsContent();
        this.checkPagination();
        this.checkSemantics();
        this.checkNav();
        this.checkSpecifics();
    }

    @Override
    public boolean validate() {
        int fatalErrorsSoFar = this.report.getFatalErrorCount();
        int errorsSoFar = this.report.getErrorCount();
        int warningsSoFar = this.report.getWarningCount();
        super.validate();
        this.checkLinkedResources();
        this.checkCollections();
        return fatalErrorsSoFar == this.report.getFatalErrorCount() && errorsSoFar == this.report.getErrorCount() && warningsSoFar == this.report.getWarningCount();
    }

    @Override
    protected void checkItem(OPFItem item, OPFHandler opfHandler) {
        String mimeType = item.getMimeType();
        if (mimeType == null || mimeType.equals("")) {
            return;
        }
        if (!mimeType.matches("[a-zA-Z0-9!#$&+-^_]+/[a-zA-Z0-9!#$&+-^_]+")) {
            return;
        }
        if ("application/xhtml+xml".equals(mimeType) && !"xhtml".equals(Files.getFileExtension((String)item.getPath()))) {
            this.report.message(MessageId.HTM_014a, EPUBLocation.create(this.path, item.getLineNumber(), item.getColumnNumber()), item.getPath());
        }
    }

    @Override
    protected void checkSpineItem(OPFItem item, OPFHandler opfHandler) {
        String mimeType = item.getMimeType();
        if (item.getProperties().contains(PackageVocabs.ITEM_VOCAB.get(PackageVocabs.ITEM_PROPERTIES.DATA_NAV))) {
            this.report.message(MessageId.OPF_077, EPUBLocation.create(this.path, item.getLineNumber(), item.getColumnNumber()), new Object[0]);
        }
        if (OPFChecker30.isBlessedItemType(mimeType, this.version)) {
            return;
        }
        if (!item.getFallback().isPresent()) {
            this.report.message(MessageId.OPF_043, EPUBLocation.create(this.path, item.getLineNumber(), item.getColumnNumber()), mimeType);
        } else if (!new OPFChecker.FallbackChecker().checkItemFallbacks(item, opfHandler, false)) {
            this.report.message(MessageId.OPF_044, EPUBLocation.create(this.path, item.getLineNumber(), item.getColumnNumber()), mimeType);
        }
    }

    @Override
    protected void checkBindings() {
        Set<String> mimeTypes = ((XRefChecker)this.context.xrefChecker.get()).getBindingsMimeTypes();
        for (String mimeType : mimeTypes) {
            String handlerId = ((XRefChecker)this.context.xrefChecker.get()).getBindingHandlerId(mimeType);
            OPFItem handler = (OPFItem)this.opfHandler.getItemById(handlerId).get();
            if (handler.isScripted()) continue;
            this.report.message(MessageId.OPF_046, EPUBLocation.create(handler.getPath(), handler.getLineNumber(), handler.getColumnNumber()), new Object[0]);
        }
    }

    private void checkCollections() {
        for (ResourceCollection collection : ((OPFHandler30)this.opfHandler).getCollections().asList()) {
            if (collection.hasRole(ResourceCollection.Roles.DICTIONARY)) {
                this.checkDictCollection(collection);
            }
            if (collection.hasRole(ResourceCollection.Roles.INDEX)) {
                this.checkIndexCollection(collection);
            }
            if (!collection.hasRole(ResourceCollection.Roles.PREVIEW)) continue;
            this.checkPreviewCollection(collection);
        }
    }

    private void checkCollectionsContent() {
        for (ResourceCollection collection : ((OPFHandler30)this.opfHandler).getCollections().asList()) {
            if (!collection.hasRole(ResourceCollection.Roles.DICTIONARY)) continue;
            this.checkDictCollectionContent(collection);
        }
    }

    private void checkDictCollection(ResourceCollection collection) {
        if (collection.hasRole(ResourceCollection.Roles.DICTIONARY)) {
            boolean skmFound = false;
            for (LinkedResource resource : collection.getResources().asList()) {
                Optional<OPFItem> item = this.opfHandler.getItemByPath(resource.getPath());
                if (!item.isPresent()) {
                    this.report.message(MessageId.OPF_081, EPUBLocation.create(this.path), resource.getPath());
                    continue;
                }
                if ("application/vnd.epub.search-key-map+xml".equals(((OPFItem)item.get()).getMimeType())) {
                    if (skmFound) {
                        this.report.message(MessageId.OPF_082, EPUBLocation.create(this.path), new Object[0]);
                    }
                    skmFound = true;
                    continue;
                }
                if ("application/xhtml+xml".equals(((OPFItem)item.get()).getMimeType())) continue;
                this.report.message(MessageId.OPF_084, EPUBLocation.create(this.path), resource.getPath());
            }
            if (!skmFound) {
                this.report.message(MessageId.OPF_083, EPUBLocation.create(this.path), new Object[0]);
            }
        }
    }

    private void checkDictCollectionContent(ResourceCollection collection) {
        if (collection.hasRole(ResourceCollection.Roles.DICTIONARY)) {
            boolean dictFound = false;
            for (LinkedResource resource : collection.getResources().asList()) {
                final Optional<OPFItem> item = this.opfHandler.getItemByPath(resource.getPath());
                if (dictFound || !item.isPresent() || !"application/xhtml+xml".equals(((OPFItem)item.get()).getMimeType())) continue;
                dictFound = Iterables.tryFind(this.context.featureReport.getFeature(FeatureEnum.DICTIONARY), (Predicate)new Predicate<FeatureReport.Feature>(){

                    public boolean apply(FeatureReport.Feature dict) {
                        return ((OPFItem)item.get()).getPath().equals(((EPUBLocation)dict.getLocation().get()).getPath());
                    }
                }).isPresent();
            }
            if (!dictFound) {
                this.report.message(MessageId.OPF_078, EPUBLocation.create(this.path), new Object[0]);
            }
        }
    }

    private void checkIndexCollection(ResourceCollection collection) {
        if (collection.hasRole(ResourceCollection.Roles.INDEX) || collection.hasRole(ResourceCollection.Roles.INDEX_GROUP)) {
            for (LinkedResource resource : collection.getResources().asList()) {
                Optional<OPFItem> item = this.opfHandler.getItemByPath(resource.getPath());
                if (item.isPresent() && "application/xhtml+xml".equals(((OPFItem)item.get()).getMimeType())) continue;
                this.report.message(MessageId.OPF_071, EPUBLocation.create(this.path), new Object[0]);
            }
            for (ResourceCollection childCollection : collection.getCollections().asList()) {
                this.checkIndexCollection(childCollection);
            }
        }
    }

    private void checkPreviewCollection(ResourceCollection collection) {
        if (collection.hasRole(ResourceCollection.Roles.PREVIEW)) {
            for (LinkedResource resource : collection.getResources().asList()) {
                Optional<OPFItem> item = this.opfHandler.getItemByPath(resource.getPath());
                if (!item.isPresent() || !"application/xhtml+xml".equals(((OPFItem)item.get()).getMimeType()) && !"image/svg+xml".equals(((OPFItem)item.get()).getMimeType())) {
                    this.report.message(MessageId.OPF_075, EPUBLocation.create(this.path), new Object[0]);
                    continue;
                }
                try {
                    URI uri = new URI(resource.getURI());
                    if (!((String)Optional.fromNullable((Object)uri.getFragment()).or((Object)"")).startsWith("epubcfi(")) continue;
                    this.report.message(MessageId.OPF_076, EPUBLocation.create(this.path), new Object[0]);
                }
                catch (URISyntaxException e) {
                    this.report.message(MessageId.RSC_020, EPUBLocation.create(this.path), new Object[0]);
                }
            }
        }
    }

    private void checkLinkedResources() {
        LinkedResources links = ((OPFHandler30)this.opfHandler).getLinkedResources();
        for (LinkedResource link : links.asList()) {
            if (!this.opfHandler.getItemByPath(link.getPath()).isPresent()) continue;
            this.report.message(MessageId.OPF_067, EPUBLocation.create(this.path), link.getPath());
        }
    }

    private void checkPagination() {
        if ((this.context.profile == EPUBProfile.EDUPUB || this.context.pubTypes.contains("edupub")) && this.context.featureReport.hasFeature(FeatureEnum.PAGE_BREAK)) {
            Set<MetadataSet.Metadata> dcSourceMetas;
            if (!this.context.featureReport.hasFeature(FeatureEnum.PAGE_LIST)) {
                this.report.message(MessageId.NAV_003, EPUBLocation.create(this.path), new Object[0]);
            }
            if ((dcSourceMetas = ((OPFHandler30)this.opfHandler).getMetadata().getPrimary(DCMESVocab.VOCAB.get(DCMESVocab.PROPERTIES.SOURCE))).isEmpty()) {
                this.report.message(MessageId.OPF_066, EPUBLocation.create(this.path), new Object[0]);
            } else if (!MetadataSet.tryFindInRefines(dcSourceMetas, PackageVocabs.META_VOCAB.get(PackageVocabs.META_PROPERTIES.SOURCE_OF), (Optional<String>)Optional.of((Object)"pagination")).isPresent()) {
                this.report.message(MessageId.OPF_066, EPUBLocation.create(this.path), new Object[0]);
            }
        }
    }

    private void checkSemantics() {
        if ((this.context.profile == EPUBProfile.EDUPUB || this.context.pubTypes.contains("edupub")) && this.context.featureReport.hasFeature(FeatureEnum.HAS_MICRODATA) && !this.context.featureReport.hasFeature(FeatureEnum.HAS_RDFA)) {
            this.report.message(MessageId.HTM_051, (EPUBLocation)this.context.featureReport.getFeature(FeatureEnum.HAS_MICRODATA).iterator().next().getLocation().get(), new Object[0]);
        }
    }

    private void checkNav() {
        if (this.context.profile == EPUBProfile.EDUPUB || this.context.pubTypes.contains("edupub")) {
            Set<FeatureReport.Feature> sections = this.context.featureReport.getFeature(FeatureEnum.SECTIONS);
            Set<FeatureReport.Feature> tocLinks = this.context.featureReport.getFeature(FeatureEnum.TOC_LINKS);
            if (sections.size() != tocLinks.size()) {
                this.report.message(MessageId.NAV_004, tocLinks.isEmpty() ? EPUBLocation.create(this.path) : (EPUBLocation)tocLinks.iterator().next().getLocation().get(), new Object[0]);
            }
            if (this.context.featureReport.hasFeature(FeatureEnum.AUDIO) && !this.context.featureReport.hasFeature(FeatureEnum.LOA)) {
                this.report.message(MessageId.NAV_005, tocLinks.isEmpty() ? EPUBLocation.create(this.path) : (EPUBLocation)tocLinks.iterator().next().getLocation().get(), new Object[0]);
            }
            if (this.context.featureReport.hasFeature(FeatureEnum.FIGURE) && !this.context.featureReport.hasFeature(FeatureEnum.LOI)) {
                this.report.message(MessageId.NAV_006, tocLinks.isEmpty() ? EPUBLocation.create(this.path) : (EPUBLocation)tocLinks.iterator().next().getLocation().get(), new Object[0]);
            }
            if (this.context.featureReport.hasFeature(FeatureEnum.TABLE) && !this.context.featureReport.hasFeature(FeatureEnum.LOT)) {
                this.report.message(MessageId.NAV_007, tocLinks.isEmpty() ? EPUBLocation.create(this.path) : (EPUBLocation)tocLinks.iterator().next().getLocation().get(), new Object[0]);
            }
            if (this.context.featureReport.hasFeature(FeatureEnum.VIDEO) && !this.context.featureReport.hasFeature(FeatureEnum.LOV)) {
                this.report.message(MessageId.NAV_008, tocLinks.isEmpty() ? EPUBLocation.create(this.path) : (EPUBLocation)tocLinks.iterator().next().getLocation().get(), new Object[0]);
            }
        }
    }

    private void checkSpecifics() {
        if (this.context.featureReport.hasFeature(FeatureEnum.DICTIONARY) && !this.context.pubTypes.contains("dictionary")) {
            this.report.message(MessageId.OPF_079, (EPUBLocation)this.context.featureReport.getFeature(FeatureEnum.DICTIONARY).iterator().next().getLocation().get(), new Object[0]);
        }
        if ((this.context.profile == EPUBProfile.DICT || this.context.pubTypes.contains("dictionary")) && !this.context.featureReport.hasFeature(FeatureEnum.DICTIONARY)) {
            this.report.message(MessageId.OPF_078, EPUBLocation.create(this.path), new Object[0]);
        }
    }

    public static boolean isBlessedAudioType(String type) {
        return type.equals("audio/mpeg") || type.equals("audio/mp4");
    }

    public static boolean isBlessedVideoType(String type) {
        return type.startsWith("video/h264") || type.startsWith("video/webm") || type.startsWith("video/mp4");
    }

    public static boolean isBlessedFontType(String type) {
        return type.equals("application/vnd.ms-opentype") || type.equals("application/font-woff") || type.equals("image/svg+xml");
    }

    public static boolean isCoreMediaType(String type) {
        return OPFChecker30.isBlessedAudioType(type) || OPFChecker30.isBlessedVideoType(type) || OPFChecker30.isBlessedFontType(type) || OPFChecker30.isBlessedItemType(type, EPUBVersion.VERSION_3) || OPFChecker30.isBlessedImageType(type) || type.equals("text/javascript") || type.equals("application/pls+xml") || type.equals("application/smil+xml") || type.equals("image/svg+xml");
    }
}

