/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.opf;

import com.adobe.epubcheck.vocab.EpubCheckVocab;
import com.adobe.epubcheck.vocab.PackageVocabs;
import com.adobe.epubcheck.vocab.Property;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public class OPFItem {
    private final String id;
    private final String path;
    private final String mimetype;
    private final int lineNumber;
    private final int columnNumber;
    private final Optional<String> fallback;
    private final Optional<String> fallbackStyle;
    private final Set<Property> properties;
    private final boolean ncx;
    private final boolean inSpine;
    private final boolean nav;
    private final boolean scripted;
    private final boolean linear;
    private final boolean fixedLayout;

    private OPFItem(String id, String path, String mimetype, int lineNumber, int columnNumber, Optional<String> fallback, Optional<String> fallbackStyle, Set<Property> properties, boolean ncx, boolean inSpine, boolean nav, boolean scripted, boolean linear, boolean fxl) {
        this.id = id;
        this.path = path;
        this.mimetype = mimetype;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.fallback = fallback;
        this.fallbackStyle = fallbackStyle;
        this.properties = properties;
        this.ncx = ncx;
        this.inSpine = inSpine;
        this.nav = nav;
        this.scripted = scripted;
        this.linear = linear;
        this.fixedLayout = fxl;
    }

    public String getId() {
        return this.id;
    }

    public String getPath() {
        return this.path;
    }

    public String getMimeType() {
        return this.mimetype;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public Optional<String> getFallback() {
        return this.fallback;
    }

    public Optional<String> getFallbackStyle() {
        return this.fallbackStyle;
    }

    public Set<Property> getProperties() {
        return this.properties;
    }

    public boolean isNcx() {
        return this.ncx;
    }

    public boolean isScripted() {
        return this.scripted;
    }

    public boolean isNav() {
        return this.nav;
    }

    public boolean isInSpine() {
        return this.inSpine;
    }

    public boolean isLinear() {
        if (!this.inSpine) {
            throw new IllegalStateException("linear");
        }
        return this.linear;
    }

    public boolean isFixedLayout() {
        return this.fixedLayout;
    }

    public String toString() {
        return this.path + "[" + this.id + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OPFItem other = (OPFItem)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    public static final class Builder {
        private String id;
        private String path;
        private String mimeType;
        private int lineNumber;
        private int columnNumber;
        private String fallback = null;
        private String fallbackStyle = null;
        private boolean ncx = false;
        private boolean linear = true;
        private boolean inSpine = false;
        private boolean fxl = false;
        private ImmutableSet.Builder<Property> propertiesBuilder = new ImmutableSet.Builder();

        public Builder(String id, String path, String mimeType, int lineNumber, int columnNumber) {
            this.id = ((String)Preconditions.checkNotNull((Object)id)).trim();
            this.path = ((String)Preconditions.checkNotNull((Object)path)).trim();
            this.mimeType = ((String)Optional.fromNullable((Object)mimeType).or((Object)"undefined")).trim();
            this.lineNumber = lineNumber;
            this.columnNumber = columnNumber;
        }

        public Builder fallback(String fallback) {
            this.fallback = fallback;
            return this;
        }

        public Builder fallbackStyle(String fallbackStyle) {
            this.fallbackStyle = fallbackStyle;
            return this;
        }

        public Builder fixedLayout() {
            this.fxl = true;
            return this;
        }

        public Builder ncx() {
            this.ncx = true;
            return this;
        }

        public Builder nonlinear() {
            this.linear = false;
            return this;
        }

        public Builder inSpine() {
            this.inSpine = true;
            return this;
        }

        public Builder properties(Set<Property> properties) {
            if (properties != null) {
                this.propertiesBuilder.addAll(properties);
            }
            return this;
        }

        public OPFItem build() {
            if (!this.inSpine || !this.linear) {
                this.propertiesBuilder.add((Object)EpubCheckVocab.VOCAB.get(EpubCheckVocab.PROPERTIES.NON_LINEAR));
            }
            if (this.fxl) {
                this.propertiesBuilder.add((Object)EpubCheckVocab.VOCAB.get(EpubCheckVocab.PROPERTIES.FIXED_LAYOUT));
            }
            ImmutableSet properties = this.propertiesBuilder.build();
            return new OPFItem(this.id, this.path, this.mimeType, this.lineNumber, this.columnNumber, Optional.fromNullable((Object)Strings.emptyToNull((String)Strings.nullToEmpty((String)this.fallback).trim())), Optional.fromNullable((Object)Strings.emptyToNull((String)Strings.nullToEmpty((String)this.fallbackStyle).trim())), (Set)properties, this.ncx, this.inSpine, properties.contains(PackageVocabs.ITEM_VOCAB.get(PackageVocabs.ITEM_PROPERTIES.NAV)), properties.contains(PackageVocabs.ITEM_VOCAB.get(PackageVocabs.ITEM_PROPERTIES.SCRIPTED)), this.linear, this.fxl);
        }
    }
}

