/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.opf;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.OPFData;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.GenericResourceProvider;
import com.adobe.epubcheck.util.InvalidVersionException;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class OPFPeeker {
    private static final String FINISHED_PARSING = "FINISHED_PARSING";
    private final Report report;
    private final String path;
    private final GenericResourceProvider resourceProvider;

    public OPFPeeker(String path, Report report, GenericResourceProvider resourceProvider) {
        this.path = path;
        this.report = report;
        this.resourceProvider = resourceProvider;
    }

    public OPFData peek() throws InvalidVersionException, IOException {
        Closer closer = Closer.create();
        try {
            InputStream in = this.resourceProvider.getInputStream(this.path);
            if (in == null) {
                throw new IOException("Couldn't find resource " + this.path);
            }
            in = (InputStream)closer.register((Closeable)this.resourceProvider.getInputStream(this.path));
            OPFData oPFData = this.peek(in);
            return oPFData;
        }
        catch (Throwable e) {
            throw closer.rethrow(e, InvalidVersionException.class);
        }
        finally {
            closer.close();
        }
    }

    private OPFData peek(InputStream inputStream) throws InvalidVersionException {
        OPFData.OPFDataBuilder builder = new OPFData.OPFDataBuilder();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            factory.setFeature("http://xml.org/sax/features/validation", false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ParserHandler handler = new ParserHandler(builder);
            SAXParser parser = factory.newSAXParser();
            parser.getXMLReader().setEntityResolver(handler);
            parser.getXMLReader().setErrorHandler(handler);
            parser.getXMLReader().setContentHandler(handler);
            parser.getXMLReader().parse(new InputSource(inputStream));
        }
        catch (ParserConfigurationException e) {
            this.report.message(MessageId.RSC_005, EPUBLocation.create(this.path), e.getMessage());
        }
        catch (InvalidVersionException e) {
            throw e;
        }
        catch (SAXException e) {
            if (FINISHED_PARSING.equals(e.getMessage())) {
                OPFData data = builder.build();
                return data;
            }
            this.report.message(MessageId.RSC_005, EPUBLocation.create(this.path), e.getMessage());
        }
        catch (IOException e) {
            this.report.message(MessageId.PKG_008, EPUBLocation.create(this.path), this.path);
        }
        throw new InvalidVersionException("Version not found");
    }

    private static class ParserHandler
    extends DefaultHandler {
        private static final String VERSION_3 = "3.0";
        private static final String VERSION_2 = "2.0";
        private final OPFData.OPFDataBuilder builder;
        private boolean isPackageRoot = false;
        private String currentText = null;
        private String uniqueId = null;
        private boolean isUniqueId = false;

        public ParserHandler(OPFData.OPFDataBuilder builder) {
            this.builder = builder;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
            return new InputSource(new StringReader(""));
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("package".equals(localName)) {
                this.processPackage(attributes);
                this.isPackageRoot = true;
            } else {
                if (!this.isPackageRoot) {
                    throw new InvalidVersionException("Package element must be the first element in the package file");
                }
                if ("type".equals(localName) && "http://purl.org/dc/elements/1.1/".equals(uri)) {
                    this.currentText = "";
                } else if ("identifier".equals(localName) && "http://purl.org/dc/elements/1.1/".equals(uri)) {
                    String id = attributes.getValue("id");
                    boolean bl = this.isUniqueId = id != null && id.trim().equals(this.uniqueId);
                    if (this.isUniqueId) {
                        this.currentText = "";
                    }
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.currentText != null) {
                this.currentText = this.currentText + String.valueOf(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("metadata".equals(localName) || "package".equals(localName)) {
                throw new SAXException(OPFPeeker.FINISHED_PARSING);
            }
            if ("type".equals(localName) && "http://purl.org/dc/elements/1.1/".equals(uri)) {
                this.currentText = this.currentText.trim();
                if (this.currentText.length() > 0) {
                    this.builder.withType(this.currentText);
                }
                this.currentText = null;
            } else if (this.isUniqueId && "identifier".equals(localName) && "http://purl.org/dc/elements/1.1/".equals(uri)) {
                this.currentText = this.currentText.trim();
                if (this.currentText.length() > 0) {
                    this.builder.withUniqueId(this.currentText);
                }
                this.isUniqueId = false;
                this.currentText = null;
            }
        }

        private void processPackage(Attributes attributes) throws SAXException {
            String version = attributes.getValue("version");
            if (version == null) {
                throw new InvalidVersionException("Version attribute not found");
            }
            if (VERSION_3.equals(version)) {
                this.builder.withVersion(EPUBVersion.VERSION_3);
            } else if (VERSION_2.equals(version)) {
                this.builder.withVersion(EPUBVersion.VERSION_2);
            } else {
                throw new InvalidVersionException("Version not supported");
            }
            String uniqueId = attributes.getValue("unique-identifier");
            if (uniqueId != null) {
                this.uniqueId = uniqueId;
            }
        }
    }
}

