/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.opf;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.ocf.OCFPackage;
import com.adobe.epubcheck.opf.OPFChecker;
import com.adobe.epubcheck.opf.OPFItem;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.vocab.PackageVocabs;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;

public class XRefChecker {
    private final Hashtable<String, Resource> resources = new Hashtable();
    private final HashSet<String> undeclared = new HashSet();
    private final Vector<Reference> references = new Vector();
    private final Hashtable<String, String> bindings = new Hashtable();
    private final Report report;
    private final OCFPackage ocf;
    private final EPUBVersion version;

    public XRefChecker(OCFPackage ocf, Report report, EPUBVersion version) {
        this.ocf = ocf;
        this.report = report;
        this.version = version;
    }

    public String getMimeType(String path) {
        return this.resources.get(path) != null ? this.resources.get((Object)path).item.getMimeType() : null;
    }

    public Optional<Boolean> hasValidFallback(String path) {
        return this.resources.get(path) != null ? Optional.of((Object)this.resources.get((Object)path).hasValidItemFallback) : Optional.absent();
    }

    public Set<String> getBindingsMimeTypes() {
        return this.bindings.keySet();
    }

    public String getBindingHandlerId(String mimeType) {
        return this.bindings.get(mimeType);
    }

    public void registerBinding(String mimeType, String handlerId) {
        this.bindings.put(mimeType, handlerId);
    }

    public void registerResource(OPFItem item, boolean hasValidItemFallback, boolean hasValidImageFallback) {
        if (!this.resources.contains(item.getPath())) {
            this.resources.put(item.getPath(), new Resource(item, hasValidItemFallback, hasValidImageFallback));
        }
    }

    public void registerAnchor(String path, int lineNumber, int columnNumber, String id, Type type) {
        Resource res = (Resource)Preconditions.checkNotNull((Object)this.resources.get(path));
        if (!res.anchors.contains(id)) {
            res.anchors.put(id, new Anchor(id, lineNumber, columnNumber, type));
        }
    }

    public void registerReference(String srcResource, int srcLineNumber, int srcColumnNumber, String ref, Type type) {
        String refFragment;
        String refResource;
        int hash;
        if (ref.startsWith("data:")) {
            return;
        }
        int query = ref.indexOf(63);
        if (query >= 0 && !ref.matches("^[^:/?#]+://.*")) {
            ref = ref.substring(0, query).trim();
        }
        if ((hash = ref.indexOf("#")) >= 0) {
            refResource = ref.substring(0, hash);
            refFragment = ref.substring(hash + 1);
        } else {
            refResource = ref;
            refFragment = null;
        }
        this.report.info(srcResource, FeatureEnum.RESOURCE, refResource);
        this.references.add(new Reference(srcResource, srcLineNumber, srcColumnNumber, refResource, refFragment, type));
    }

    public void checkReferences() {
        Enumeration<Reference> refs = this.references.elements();
        while (refs.hasMoreElements()) {
            Reference ref = refs.nextElement();
            this.checkReference(ref);
        }
    }

    private void checkReference(Reference ref) {
        Resource res = this.resources.get(ref.refResource);
        Resource host = this.resources.get(ref.resource);
        if (res == null) {
            if (this.version == EPUBVersion.VERSION_3 && ref.type == Type.LINK) {
                if (ref.refResource.matches("^[^:/?#]+://.*") || this.ocf.hasEntry(ref.refResource)) {
                    return;
                }
                this.report.message(MessageId.RSC_007w, EPUBLocation.create(ref.resource, ref.lineNumber, ref.columnNumber, ref.refResource), new Object[0]);
            } else if (ref.refResource.matches("^[^:/?#]+://.*") && (this.version != EPUBVersion.VERSION_3 || ref.type != Type.AUDIO && ref.type != Type.VIDEO)) {
                this.report.message(MessageId.RSC_006, EPUBLocation.create(ref.resource, ref.lineNumber, ref.columnNumber, ref.refResource), new Object[0]);
            } else if (!this.ocf.hasEntry(ref.refResource) && !ref.refResource.matches("^[^:/?#]+://.*")) {
                this.report.message(MessageId.RSC_007, EPUBLocation.create(ref.resource, ref.lineNumber, ref.columnNumber, ref.refResource), new Object[0]);
            } else if (!this.undeclared.contains(ref.refResource)) {
                this.undeclared.add(ref.refResource);
                this.report.message(MessageId.RSC_008, EPUBLocation.create(ref.resource, ref.lineNumber, ref.columnNumber, ref.refResource), new Object[0]);
            }
            return;
        }
        switch (ref.type) {
            case HYPERLINK: {
                if (!(OPFChecker.isBlessedItemType(res.item.getMimeType(), this.version) || OPFChecker.isDeprecatedBlessedItemType(res.item.getMimeType()) || res.hasValidItemFallback)) {
                    this.report.message(MessageId.RSC_010, EPUBLocation.create(ref.resource, ref.lineNumber, ref.columnNumber, ref.refResource + (ref.fragment != null ? '#' + ref.fragment : "")), new Object[0]);
                }
                if (res.item.isInSpine()) break;
                this.report.message(MessageId.RSC_011, EPUBLocation.create(ref.resource, ref.lineNumber, ref.columnNumber, ref.refResource + (ref.fragment != null ? '#' + ref.fragment : "")), new Object[0]);
                break;
            }
            case IMAGE: {
                if (ref.fragment != null) {
                    this.report.message(MessageId.RSC_009, EPUBLocation.create(ref.resource, ref.lineNumber, ref.columnNumber, ref.refResource + "#" + ref.fragment), new Object[0]);
                    return;
                }
                if (OPFChecker.isBlessedImageType(res.item.getMimeType()) || res.hasValidImageFallback) break;
                this.report.message(MessageId.MED_003, EPUBLocation.create(ref.resource, ref.lineNumber, ref.columnNumber), res.item.getMimeType());
                break;
            }
            case REGION_BASED_NAV: {
                if (!res.item.isFixedLayout()) {
                    this.report.message(MessageId.NAV_009, EPUBLocation.create(ref.resource, ref.lineNumber, ref.columnNumber), new Object[0]);
                }
                return;
            }
            case SEARCH_KEY: {
                if (ref.fragment != null && ref.fragment.startsWith("epubcfi(") || res.item.isInSpine()) break;
                this.report.message(MessageId.RSC_021, EPUBLocation.create(ref.resource, ref.lineNumber, ref.columnNumber), ref.refResource);
                break;
            }
            case STYLESHEET: {
                if (ref.fragment == null) break;
                this.report.message(MessageId.RSC_013, EPUBLocation.create(ref.resource, ref.lineNumber, ref.columnNumber, ref.refResource + "#" + ref.fragment), new Object[0]);
                return;
            }
            case SVG_CLIP_PATH: 
            case SVG_PAINT: 
            case SVG_SYMBOL: {
                if (ref.fragment != null) break;
                this.report.message(MessageId.RSC_015, EPUBLocation.create(ref.resource, ref.lineNumber, ref.columnNumber, ref.refResource), new Object[0]);
                return;
            }
        }
        if (ref.fragment != null) {
            if (ref.fragment.startsWith("epubcfi(")) {
                return;
            }
            if (ref.fragment.contains("=") && host != null && host.item.getProperties().contains(PackageVocabs.ITEM_VOCAB.get(PackageVocabs.ITEM_PROPERTIES.DATA_NAV))) {
                return;
            }
            Anchor anchor = res.anchors.get(ref.fragment);
            if (anchor == null) {
                this.report.message(MessageId.RSC_012, EPUBLocation.create(ref.resource, ref.lineNumber, ref.columnNumber, ref.refResource + "#" + ref.fragment), new Object[0]);
                return;
            }
            switch (ref.type) {
                case SVG_CLIP_PATH: 
                case SVG_PAINT: {
                    if (anchor.type == ref.type) break;
                    this.report.message(MessageId.RSC_014, EPUBLocation.create(ref.resource, ref.lineNumber, ref.columnNumber, ref.refResource + "#" + ref.fragment), new Object[0]);
                    break;
                }
                case HYPERLINK: 
                case SVG_SYMBOL: {
                    if (anchor.type == ref.type || anchor.type == Type.GENERIC) break;
                    this.report.message(MessageId.RSC_014, EPUBLocation.create(ref.resource, ref.lineNumber, ref.columnNumber, ref.refResource + "#" + ref.fragment), new Object[0]);
                    break;
                }
            }
        }
    }

    private static class Resource {
        public final OPFItem item;
        public final Hashtable<String, Anchor> anchors;
        public final boolean hasValidItemFallback;
        public final boolean hasValidImageFallback;

        Resource(OPFItem item, boolean hasValidItemFallback, boolean hasValidImageFallback) {
            this.item = item;
            this.hasValidItemFallback = hasValidItemFallback;
            this.hasValidImageFallback = hasValidImageFallback;
            this.anchors = new Hashtable();
        }
    }

    private static class Anchor {
        public final String id;
        public final int lineNumber;
        public final int columnNumber;
        public final Type type;

        public Anchor(String id, int lineNumber, int columnNumber, Type type) {
            this.id = id;
            this.lineNumber = lineNumber;
            this.columnNumber = columnNumber;
            this.type = type;
        }
    }

    private static class Reference {
        public final String resource;
        public final int lineNumber;
        public final int columnNumber;
        public final String refResource;
        public final String fragment;
        public final Type type;

        public Reference(String srcResource, int srcLineNumber, int srcColumnNumber, String refResource, String fragment, Type type) {
            this.fragment = fragment;
            this.lineNumber = srcLineNumber;
            this.columnNumber = srcColumnNumber;
            this.refResource = refResource;
            this.resource = srcResource;
            this.type = type;
        }
    }

    public static enum Type {
        GENERIC,
        HYPERLINK,
        LINK,
        IMAGE,
        OBJECT,
        STYLESHEET,
        AUDIO,
        VIDEO,
        SVG_PAINT,
        SVG_CLIP_PATH,
        SVG_SYMBOL,
        REGION_BASED_NAV,
        SEARCH_KEY;

    }
}

