/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ops;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.css.CSSCheckerFactory;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.OPFChecker;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.util.HandlerUtil;
import com.adobe.epubcheck.util.PathUtil;
import com.adobe.epubcheck.util.URISchemes;
import com.adobe.epubcheck.xml.XMLElement;
import com.adobe.epubcheck.xml.XMLHandler;
import com.adobe.epubcheck.xml.XMLParser;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Stack;

public class OPSHandler
implements XMLHandler {
    protected URI base;
    protected final ValidationContext context;
    protected final XMLParser parser;
    protected final String path;
    protected final Report report;
    protected final Optional<XRefChecker> xrefChecker;
    protected long openElements;
    protected long charsCount;
    protected int tableDepth = 0;
    protected boolean hasTh = false;
    protected boolean hasThead = false;
    protected boolean hasCaption = false;
    protected Optional<EPUBLocation> nonStandardStylesheetLink = Optional.absent();
    protected boolean hasCss = false;
    protected boolean epubTypeInUse = false;
    protected boolean checkedUnsupportedXMLVersion = false;
    protected StringBuilder textNode;
    protected Stack<ElementLocation> elementLocationStack = new Stack();

    public OPSHandler(ValidationContext context, XMLParser parser) {
        this.context = context;
        this.path = context.path;
        this.xrefChecker = context.xrefChecker;
        this.report = context.report;
        this.parser = parser;
    }

    protected void checkPaint(XMLElement e, String attr) {
        String paint = e.getAttribute(attr);
        if (this.xrefChecker.isPresent() && paint != null && paint.startsWith("url(") && paint.endsWith(")")) {
            String href = paint.substring(4, paint.length() - 1);
            href = PathUtil.resolveRelativeReference(this.path, href, this.base == null ? null : this.base.toString());
            ((XRefChecker)this.xrefChecker.get()).registerReference(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), href, XRefChecker.Type.SVG_PAINT);
        }
    }

    protected void checkImage(XMLElement e, String attrNS, String attr) {
        String href = e.getAttributeNS(attrNS, attr);
        if (this.xrefChecker.isPresent() && href != null) {
            href = PathUtil.resolveRelativeReference(this.path, href, this.base == null ? null : this.base.toString());
            ((XRefChecker)this.xrefChecker.get()).registerReference(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), href, XRefChecker.Type.IMAGE);
        }
    }

    protected void checkObject(XMLElement e, String attrNS, String attr) {
        String href = e.getAttributeNS(attrNS, attr);
        if (this.xrefChecker.isPresent() && href != null) {
            href = PathUtil.resolveRelativeReference(this.path, href, this.base == null ? null : this.base.toString());
            ((XRefChecker)this.xrefChecker.get()).registerReference(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), href, XRefChecker.Type.OBJECT);
        }
    }

    protected void checkLink(XMLElement e, String attrNS, String attr) {
        String href = e.getAttributeNS(attrNS, attr);
        String rel = e.getAttributeNS(attrNS, "rel");
        if (this.xrefChecker.isPresent() && href != null && rel != null && rel.toLowerCase().contains("stylesheet")) {
            href = PathUtil.resolveRelativeReference(this.path, href, this.base == null ? null : this.base.toString());
            ((XRefChecker)this.xrefChecker.get()).registerReference(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), href, XRefChecker.Type.STYLESHEET);
            String mimetype = ((XRefChecker)this.xrefChecker.get()).getMimeType(href);
            if (mimetype != null) {
                if (OPFChecker.isBlessedStyleType(mimetype) || OPFChecker.isDeprecatedBlessedStyleType(mimetype)) {
                    this.hasCss = true;
                } else {
                    this.nonStandardStylesheetLink = Optional.of((Object)EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), href));
                }
            }
        }
    }

    protected void checkStylesheetFallback() {
        if (this.nonStandardStylesheetLink.isPresent() && !this.hasCss && !((Boolean)((XRefChecker)this.xrefChecker.get()).hasValidFallback((String)((EPUBLocation)this.nonStandardStylesheetLink.get()).getContext().get()).or((Object)false)).booleanValue()) {
            this.report.message(MessageId.CSS_010, (EPUBLocation)this.nonStandardStylesheetLink.get(), new Object[0]);
        }
    }

    protected void checkSymbol(XMLElement e, String attrNS, String attr) {
        String href = e.getAttributeNS(attrNS, attr);
        if (this.xrefChecker.isPresent() && href != null) {
            href = PathUtil.resolveRelativeReference(this.path, href, this.base == null ? null : this.base.toString());
            ((XRefChecker)this.xrefChecker.get()).registerReference(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), href, XRefChecker.Type.SVG_SYMBOL);
        }
    }

    protected void checkHRef(XMLElement e, String attrNS, String attr) {
        String href = e.getAttributeNS(attrNS, attr);
        if (href == null) {
            return;
        }
        if ((href = href.trim()).isEmpty()) {
            this.report.message(MessageId.HTM_045, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), href), new Object[0]);
            return;
        }
        if (href.contains("#epubcfi")) {
            return;
        }
        if (".".equals(href)) {
            return;
        }
        URI uri = this.checkURI(href);
        if (uri == null) {
            return;
        }
        if ("http".equals(uri.getScheme())) {
            this.report.info(this.path, FeatureEnum.REFERENCE, href);
        }
        if (URISchemes.contains(uri.getScheme()) || null != this.base && URISchemes.contains(this.base.getScheme())) {
            return;
        }
        if (uri.getScheme() != null) {
            this.report.message(MessageId.HTM_025, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), href), new Object[0]);
            return;
        }
        try {
            href = PathUtil.resolveRelativeReference(this.path, href, this.base == null ? null : this.base.toString());
        }
        catch (IllegalArgumentException err) {
            this.report.message(MessageId.OPF_010, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), href), err.getMessage());
            return;
        }
        this.processHyperlink(href);
    }

    protected void processHyperlink(String href) {
        if (this.xrefChecker.isPresent()) {
            ((XRefChecker)this.xrefChecker.get()).registerReference(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), href, XRefChecker.Type.HYPERLINK);
        }
    }

    @Override
    public void startElement() {
        String eNS;
        ++this.openElements;
        XMLElement e = this.parser.getCurrentElement();
        ElementLocation currentLocation = new ElementLocation(this.parser.getLineNumber(), this.parser.getColumnNumber());
        this.elementLocationStack.push(currentLocation);
        if (!this.checkedUnsupportedXMLVersion) {
            HandlerUtil.checkXMLVersion(this.parser);
            this.checkedUnsupportedXMLVersion = true;
        }
        String id = e.getAttribute("id");
        String baseTest = e.getAttributeNS("http://www.w3.org/XML/1998/namespace", "base");
        if (baseTest != null) {
            this.base = this.checkURI(baseTest);
        }
        if (!this.epubTypeInUse && (eNS = e.getAttributeNS("http://www.idpf.org/2007/ops", "type")) != null) {
            this.epubTypeInUse = true;
        }
        String ns = e.getNamespace();
        String name = e.getName().toLowerCase();
        XRefChecker.Type resourceType = XRefChecker.Type.GENERIC;
        if (ns != null) {
            if (ns.equals("http://www.w3.org/2000/svg")) {
                if (name.equals("lineargradient") || name.equals("radialgradient") || name.equals("pattern")) {
                    resourceType = XRefChecker.Type.SVG_PAINT;
                } else if (name.equals("clippath")) {
                    resourceType = XRefChecker.Type.SVG_CLIP_PATH;
                } else if (name.equals("symbol")) {
                    resourceType = XRefChecker.Type.SVG_SYMBOL;
                } else if (name.equals("a")) {
                    this.checkHRef(e, "http://www.w3.org/1999/xlink", "href");
                } else if (name.equals("use")) {
                    this.checkSymbol(e, "http://www.w3.org/1999/xlink", "href");
                } else if (name.equals("image")) {
                    this.checkImage(e, "http://www.w3.org/1999/xlink", "href");
                }
                this.checkPaint(e, "fill");
                this.checkPaint(e, "stroke");
            } else if (ns.equals("http://www.w3.org/1999/xhtml")) {
                if (name.equals("a")) {
                    this.checkHRef(e, null, "href");
                } else if (name.equals("img")) {
                    this.checkImage(e, null, "src");
                } else if (name.equals("object")) {
                    this.checkObject(e, null, "data");
                } else if (name.equals("link")) {
                    this.checkLink(e, null, "href");
                } else if (name.equals("base")) {
                    this.base = this.checkURI(e.getAttribute("href"));
                } else if (name.equals("style")) {
                    this.textNode = new StringBuilder();
                } else if (name.equals("iframe")) {
                    this.checkIFrame(e);
                } else if (name.equals("table")) {
                    ++this.tableDepth;
                } else if (name.equals("th") && this.tableDepth > 0) {
                    this.hasTh = true;
                } else if (name.equals("thead") && this.tableDepth > 0) {
                    this.hasThead = true;
                } else if (name.equals("caption") && this.tableDepth > 0) {
                    this.hasCaption = true;
                } else if (name.equals("i") || name.equals("b") || name.equals("em") || name.equals("strong")) {
                    this.checkBoldItalics(e);
                }
                resourceType = XRefChecker.Type.HYPERLINK;
                String style = e.getAttribute("style");
                if (style != null && style.length() > 0) {
                    CSSCheckerFactory.getInstance().newInstance(this.context, style, currentLocation.getLineNumber(), true).runChecks();
                }
            }
        }
        if (this.xrefChecker.isPresent() && id != null) {
            ((XRefChecker)this.xrefChecker.get()).registerAnchor(this.path, currentLocation.getLineNumber(), currentLocation.getColumnNumber(), id, resourceType);
        }
    }

    protected void checkBoldItalics(XMLElement e) {
        this.report.message(MessageId.HTM_038, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), e.getName()), new Object[0]);
    }

    protected void checkIFrame(XMLElement e) {
        this.report.message(MessageId.HTM_036, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), e.getName()), new Object[0]);
    }

    protected URI checkURI(String uri) {
        try {
            return new URI(((String)Preconditions.checkNotNull((Object)uri)).trim());
        }
        catch (URISyntaxException e) {
            this.report.message(MessageId.RSC_020, this.parser.getLocation(), uri);
            return null;
        }
    }

    @Override
    public void endElement() {
        --this.openElements;
        XMLElement e = this.parser.getCurrentElement();
        String ns = e.getNamespace();
        String name = e.getName();
        if (this.openElements == 0L) {
            this.report.info(this.path, FeatureEnum.CHARS_COUNT, Long.toString(this.charsCount));
            if (!this.epubTypeInUse) {
                if (this.context.version == EPUBVersion.VERSION_3) {
                    this.report.message(MessageId.ACC_007, EPUBLocation.create(this.path), new Object[0]);
                }
            } else {
                this.epubTypeInUse = false;
            }
        }
        ElementLocation currentLocation = this.elementLocationStack.pop();
        if ("http://www.w3.org/1999/xhtml".equals(ns)) {
            if ("script".equals(name)) {
                String attr = e.getAttribute("type");
                this.report.info(this.path, FeatureEnum.HAS_SCRIPTS, attr == null ? "" : attr);
            } else if ("style".equals(name)) {
                String style = this.textNode.toString();
                if (style.length() > 0) {
                    CSSCheckerFactory.getInstance().newInstance(this.context, style, currentLocation.getLineNumber(), false).runChecks();
                }
                this.textNode = null;
            } else if ("head".equals(name)) {
                this.checkStylesheetFallback();
            } else if ("table".equals(name) && this.tableDepth > 0) {
                --this.tableDepth;
                EPUBLocation location = EPUBLocation.create(this.path, currentLocation.getLineNumber(), currentLocation.getColumnNumber(), "table");
                this.checkDependentCondition(MessageId.ACC_005, this.tableDepth == 0, this.hasTh, location);
                this.checkDependentCondition(MessageId.ACC_006, this.tableDepth == 0, this.hasThead, location);
                this.checkDependentCondition(MessageId.ACC_012, this.tableDepth == 0, this.hasCaption, location);
                this.hasCaption = false;
                this.hasThead = false;
                this.hasTh = false;
            }
        }
    }

    protected void checkDependentCondition(MessageId id, boolean condition1, boolean condition2, EPUBLocation location) {
        if (condition1 && !condition2) {
            this.report.message(id, location, new Object[0]);
        }
    }

    @Override
    public void ignorableWhitespace(char[] chars, int arg1, int arg2) {
    }

    @Override
    public void characters(char[] chars, int start, int length) {
        this.charsCount += (long)length;
        if (this.textNode != null) {
            this.textNode.append(chars, start, length);
        }
    }

    @Override
    public void processingInstruction(String arg0, String arg1) {
    }

    class ElementLocation {
        int lineNumber;
        int columnNumber;

        public ElementLocation(int line, int column) {
            this.lineNumber = line;
            this.columnNumber = column;
        }

        int getLineNumber() {
            return this.lineNumber;
        }

        int getColumnNumber() {
            return this.columnNumber;
        }
    }
}

