/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.overlay;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.OPFChecker30;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.util.HandlerUtil;
import com.adobe.epubcheck.util.PathUtil;
import com.adobe.epubcheck.vocab.StructureVocab;
import com.adobe.epubcheck.vocab.Vocab;
import com.adobe.epubcheck.vocab.VocabUtil;
import com.adobe.epubcheck.xml.XMLElement;
import com.adobe.epubcheck.xml.XMLHandler;
import com.adobe.epubcheck.xml.XMLParser;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;

public class OverlayHandler
implements XMLHandler {
    private static Map<String, Vocab> RESERVED_VOCABS = ImmutableMap.of((Object)"", StructureVocab.VOCAB);
    private static Map<String, Vocab> KNOWN_VOCAB_URIS = ImmutableMap.of();
    private static Set<String> DEFAULT_VOCAB_URIS = ImmutableSet.of((Object)"http://www.idpf.org/epub/vocab/structure/#");
    private final ValidationContext context;
    private final String path;
    private final Report report;
    private final XMLParser parser;
    private boolean checkedUnsupportedXMLVersion;
    private Map<String, Vocab> vocabs = RESERVED_VOCABS;

    public OverlayHandler(ValidationContext context, XMLParser parser) {
        this.context = context;
        this.path = context.path;
        this.report = context.report;
        this.parser = parser;
        this.checkedUnsupportedXMLVersion = false;
    }

    @Override
    public void startElement() {
        XMLElement e;
        String name;
        if (!this.checkedUnsupportedXMLVersion) {
            HandlerUtil.checkXMLVersion(this.parser);
            this.checkedUnsupportedXMLVersion = true;
        }
        if ((name = (e = this.parser.getCurrentElement()).getName()).equals("smil")) {
            this.vocabs = VocabUtil.parsePrefixDeclaration(e.getAttributeNS("http://www.idpf.org/2007/ops", "prefix"), RESERVED_VOCABS, KNOWN_VOCAB_URIS, DEFAULT_VOCAB_URIS, this.report, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()));
        } else if (name.equals("seq")) {
            this.processSeq(e);
        } else if (name.equals("text")) {
            this.processSrc(e);
        } else if (name.equals("audio")) {
            this.processRef(e.getAttribute("src"), XRefChecker.Type.AUDIO);
        } else if (name.equals("body") || name.equals("par")) {
            this.checkType(e.getAttributeNS("http://www.idpf.org/2007/ops", "type"));
        }
    }

    private void checkType(String type) {
        VocabUtil.parsePropertyList(type, this.vocabs, this.report, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()));
    }

    private void processSrc(XMLElement e) {
        this.processRef(e.getAttribute("src"), XRefChecker.Type.HYPERLINK);
    }

    private void processRef(String ref, XRefChecker.Type type) {
        if (ref != null && this.context.xrefChecker.isPresent()) {
            String mimeType;
            ref = PathUtil.resolveRelativeReference(this.path, ref, null);
            if (type == XRefChecker.Type.AUDIO && (mimeType = ((XRefChecker)this.context.xrefChecker.get()).getMimeType(ref)) != null && !OPFChecker30.isBlessedAudioType(mimeType)) {
                this.report.message(MessageId.MED_005, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()), ref, mimeType);
            }
            ((XRefChecker)this.context.xrefChecker.get()).registerReference(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), ref, type);
        }
    }

    private void processSeq(XMLElement e) {
        this.processRef(e.getAttributeNS("http://www.idpf.org/2007/ops", "textref"), XRefChecker.Type.HYPERLINK);
        this.checkType(e.getAttributeNS("http://www.idpf.org/2007/ops", "type"));
    }

    @Override
    public void characters(char[] chars, int arg1, int arg2) {
    }

    @Override
    public void endElement() {
    }

    @Override
    public void ignorableWhitespace(char[] chars, int arg1, int arg2) {
    }

    @Override
    public void processingInstruction(String arg0, String arg1) {
    }
}

