/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.vocab;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;

public final class Property {
    private final String name;
    private final String prefixedName;
    private final String fullName;
    private final Enum<?> enumee;

    public static Property newFrom(String name, String base, String prefix) {
        return new Property(name, base, prefix, null);
    }

    public static Property newFrom(String name, String base, String prefix, Enum<?> enumee) {
        return new Property(name, base, prefix, enumee);
    }

    public static <E extends Enum<E>> Set<E> filter(Set<Property> properties, final Class<E> clazz) {
        Preconditions.checkNotNull(clazz);
        if (properties == null) {
            return ImmutableSet.of();
        }
        return Sets.immutableEnumSet((Iterable)Collections2.filter((Collection)Collections2.transform(properties, (Function)new Function<Property, E>(){

            public E apply(Property input) {
                try {
                    return (Enum)clazz.cast(input.toEnum());
                }
                catch (Exception e) {
                    return null;
                }
            }
        }), (Predicate)Predicates.notNull()));
    }

    private Property(String name, String base, String prefix, Enum<?> enumee) {
        this.name = name;
        this.fullName = base + name;
        this.prefixedName = Strings.isNullOrEmpty((String)prefix) ? name : prefix + ':' + name;
        this.enumee = enumee;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getPrefixedName() {
        return this.prefixedName;
    }

    public Enum<?> toEnum() {
        if (this.enumee == null) {
            throw new UnsupportedOperationException();
        }
        return this.enumee;
    }

    public String toString() {
        return "Property [" + this.prefixedName + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fullName == null ? 0 : this.fullName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Property other = (Property)obj;
        return !(this.fullName == null ? other.fullName != null : !this.fullName.equals(other.fullName));
    }
}

