/*
 * Decompiled with CFR 0.152.
 */
package org.idpf.epubcheck.util.css;

import com.google.common.base.CharMatcher;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import java.io.IOException;
import org.idpf.epubcheck.util.css.CssExceptions;
import org.idpf.epubcheck.util.css.CssReader;
import org.idpf.epubcheck.util.css.CssScanner;
import org.idpf.epubcheck.util.css.CssToken;

class CssEscape {
    static final Optional<CssEscape> ABSENT = Optional.absent();
    private final boolean debug = false;
    private final CssReader reader;
    private final CssToken.TokenBuilder err;
    private CharSequence sequence;
    int character;

    CssEscape(CssReader reader, CssToken.TokenBuilder err) {
        this.reader = reader;
        this.err = err;
    }

    Optional<CssEscape> create() throws IOException, CssExceptions.CssException {
        StringBuilder sb = new StringBuilder();
        int[] eight = this.reader.peek(8);
        int first = eight[0];
        if (first == -1) {
            this.err.error(CssExceptions.CssErrorCode.SCANNER_PREMATURE_EOF, this.reader, new Object[0]);
            return Optional.absent();
        }
        if (CssScanner.isNewLine(eight) > 0) {
            return Optional.absent();
        }
        if (CssScanner.HEXCHAR.matches((char)first)) {
            boolean seenSpace = false;
            for (int cur : eight) {
                if (cur == -1) break;
                char ch = (char)cur;
                boolean isHexChar = CssScanner.HEXCHAR.matches(ch);
                boolean isSpace = CssScanner.WHITESPACE.matches(ch);
                if (!isHexChar && !isSpace) break;
                if (CssScanner.HEXCHAR.matches(ch) && !seenSpace && sb.length() < 6) {
                    sb.append((char)cur);
                }
                if (!isSpace) continue;
                if (!seenSpace) {
                    sb.append((char)cur);
                    if (cur != 13) break;
                    seenSpace = true;
                    continue;
                }
                if (cur != 12) break;
                sb.append((char)cur);
                break;
            }
            this.character = Integer.parseInt(CssScanner.WHITESPACE.trimTrailingFrom((CharSequence)sb.toString()), 16);
            sb.insert(0, '\\');
            this.sequence = sb.toString();
        } else {
            sb.append('\\').append((char)eight[0]);
            this.sequence = sb.toString();
            this.character = eight[0];
        }
        return Optional.of((Object)this);
    }

    int render(CssToken.TokenBuilder builder, CharMatcher asLiteral) {
        char ch = (char)this.character;
        if (asLiteral.matches(ch)) {
            builder.append(ch);
        } else {
            builder.append(this.sequence);
        }
        return this.sequence.length() - 1;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("escaped", (Object)this.sequence).add("unescaped", (char)this.character).toString();
    }
}

