/*
 * Decompiled with CFR 0.152.
 */
package org.idpf.epubcheck.util.css;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.idpf.epubcheck.util.css.CssReader;

public final class CssLocation {
    final int line;
    final int col;
    private final int charOffset;
    private final String systemID;
    public static final String NO_SID = "VIRTUAL";

    CssLocation(int line, int col, int charOffset, String systemID) {
        this.line = (Integer)Preconditions.checkNotNull((Object)line);
        this.col = (Integer)Preconditions.checkNotNull((Object)col);
        this.charOffset = (Integer)Preconditions.checkNotNull((Object)charOffset);
        this.systemID = (String)Preconditions.checkNotNull((Object)systemID);
    }

    static CssLocation create(CssReader reader) {
        return new CssLocation(reader.line, reader.col, reader.offset, reader.systemID);
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.col;
    }

    public int getCharOffset() {
        return this.charOffset;
    }

    public String getSystemID() {
        return this.systemID;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("line", this.line).add("col", this.col).add("charOffset", this.charOffset).toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CssLocation) {
            CssLocation loc = (CssLocation)obj;
            if (loc.charOffset == this.charOffset && loc.line == this.line && loc.col == this.col && loc.systemID.equals(this.systemID)) {
                return true;
            }
        }
        return false;
    }
}

