/*
 * Decompiled with CFR 0.152.
 */
package org.idpf.epubcheck.util.css;

import com.google.common.base.CharMatcher;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

final class CssReader {
    static final int DEFAULT_PUSHBACK_BUFFER_SIZE = 8096;
    private final int[] buf;
    private int pos;
    private final Reader in;
    private int prevLine = 1;
    final String systemID;
    int curChar = 0;
    int prevChar = 0;
    int offset = 0;
    int line = 1;
    int col = 1;

    CssReader(Reader reader, String systemID, int pushbackSize) {
        this.in = Preconditions.checkNotNull((Object)reader) instanceof BufferedReader ? reader : new BufferedReader(reader);
        this.systemID = (String)Preconditions.checkNotNull((Object)systemID);
        Preconditions.checkArgument((pushbackSize >= 1 ? 1 : 0) != 0);
        this.pos = pushbackSize;
        this.buf = new int[pushbackSize];
    }

    int next() throws IOException {
        this.prevChar = this.curChar;
        Preconditions.checkState((this.prevChar > -1 ? 1 : 0) != 0);
        this.curChar = this.pos < this.buf.length ? this.buf[this.pos++] : this.in.read();
        ++this.offset;
        if (this.curChar == 13 || this.curChar == 10) {
            if (this.curChar != 10 || this.prevChar != 13) {
                this.prevLine = this.line++;
            }
        } else if (this.prevLine < this.line) {
            this.col = 1;
            this.prevLine = this.line;
        } else if (this.prevChar != 0) {
            ++this.col;
        }
        return this.curChar;
    }

    int peek() throws IOException {
        Mark m = this.mark();
        int ch = this.next();
        this.unread(ch, m);
        return ch;
    }

    int[] peek(int n) throws IOException {
        int[] buf = new int[n];
        Mark m = this.mark();
        boolean seenEOF = false;
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = !seenEOF ? this.next() : -1;
            if (buf[i] != -1) continue;
            seenEOF = true;
        }
        if (!seenEOF) {
            this.unread(buf, m);
        } else {
            ArrayList ints = Lists.newArrayList();
            for (int aBuf : buf) {
                ints.add(aBuf);
                if (aBuf == -1) break;
            }
            this.unread(ints, m);
        }
        return buf;
    }

    int at(int n) throws IOException {
        Mark mark = this.mark();
        ArrayList cbuf = Lists.newArrayList();
        for (int i = 0; i < n; ++i) {
            cbuf.add(this.next());
            if (this.curChar == -1) break;
        }
        this.unread(cbuf, mark);
        return (Integer)cbuf.get(cbuf.size() - 1);
    }

    int[] collect(int n) throws IOException {
        int[] buf = new int[n];
        boolean seenEOF = false;
        for (int i = 0; i < buf.length; ++i) {
            if (seenEOF) {
                buf[i] = -1;
                continue;
            }
            buf[i] = this.next();
            if (this.curChar != -1) continue;
            seenEOF = true;
        }
        return buf;
    }

    CssReader forward(CharMatcher matcher) throws IOException {
        Mark mark;
        do {
            mark = this.mark();
            this.next();
        } while (this.curChar != -1 && (!matcher.matches((char)this.curChar) || this.prevChar == 92));
        this.unread(this.curChar, mark);
        return this;
    }

    CssReader forward(int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            Mark mark = this.mark();
            this.next();
            if (this.curChar != -1) continue;
            this.unread(this.curChar, mark);
            break;
        }
        return this;
    }

    void unread(int ch, Mark mark) {
        Preconditions.checkState((this.pos > 0 ? 1 : 0) != 0);
        this.buf[--this.pos] = ch;
        this.reset(mark);
    }

    void unread(int[] cbuf, Mark mark) throws IOException {
        this.unread(cbuf, 0, cbuf.length, mark);
    }

    void unread(List<Integer> cbuf, Mark mark) throws IOException {
        this.unread(Ints.toArray(cbuf), mark);
    }

    void unread(int[] cbuf, int off, int len, Mark mark) {
        Preconditions.checkArgument((len < this.pos ? 1 : 0) != 0);
        this.pos -= len;
        System.arraycopy(cbuf, off, this.buf, this.pos, len);
        this.reset(mark);
    }

    Mark mark() {
        return new Mark(this.curChar, this.prevChar, this.line, this.col, this.prevLine, this.offset);
    }

    private CssReader reset(Mark mark) {
        this.curChar = mark.mCur;
        this.prevChar = mark.mPrev;
        this.line = mark.mLine;
        this.col = mark.mCol;
        this.prevLine = mark.mPrevLine;
        this.offset = mark.mOffset;
        return this;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("curChar", (char)this.curChar).add("prevChar", (char)this.prevChar).toString();
    }

    final class Mark {
        final int mLine;
        final int mCol;
        final int mPrev;
        final int mCur;
        final int mPrevLine;
        final int mOffset;

        private Mark(int curChar, int prevChar, int line, int col, int prevLine, int offset) {
            this.mCur = curChar;
            this.mPrev = prevChar;
            this.mLine = line;
            this.mCol = col;
            this.mPrevLine = prevLine;
            this.mOffset = offset;
        }
    }
}

